/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNavigableSet;
import org.teavm.classlib.java.util.TSortedSet;
import org.teavm.classlib.java.util.TTreeMap;
import org.teavm.interop.Rename;

public class TTreeSet<E>
extends TAbstractSet<E>
implements TCloneable,
TNavigableSet<E> {
    private static final Object VALUE = new Object();
    private TTreeMap<E, Object> map;

    public TTreeSet() {
        this.map = new TTreeMap();
    }

    public TTreeSet(TComparator<? super E> comparator) {
        this.map = new TTreeMap(comparator);
    }

    public TTreeSet(TCollection<? extends E> coll) {
        this.map = new TTreeMap();
        TIterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.map.put(iter.next(), VALUE);
        }
    }

    public TTreeSet(TSortedSet<E> s) {
        this.map = new TTreeMap(s.comparator());
        TIterator iter = s.iterator();
        while (iter.hasNext()) {
            this.map.put(iter.next(), VALUE);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public TIterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Rename(value="clone")
    public TObject clone0() {
        try {
            TTreeSet clone = (TTreeSet)super.clone();
            clone.map = (TTreeMap)this.map.clone();
            return clone;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, e) != VALUE;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == VALUE;
    }

    @Override
    public TComparator<? super E> comparator() {
        return this.map.comparator();
    }

    @Override
    public TSortedSet<E> subSet(E fromElement, E toElement) {
        return this.map.subMap(fromElement, true, toElement, false).navigableKeySet();
    }

    @Override
    public TSortedSet<E> headSet(E toElement) {
        return this.map.headMap(toElement, false).navigableKeySet();
    }

    @Override
    public TSortedSet<E> tailSet(E fromElement) {
        return this.map.tailMap(fromElement, true).navigableKeySet();
    }

    @Override
    public E first() {
        return this.map.firstKey();
    }

    @Override
    public E last() {
        return this.map.lastKey();
    }

    @Override
    public E lower(E e) {
        return this.map.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.map.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.map.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.map.higherKey(e);
    }

    @Override
    public E pollFirst() {
        TMap.Entry<E, Object> entry = this.map.pollFirstEntry();
        return entry != null ? (E)entry.getKey() : null;
    }

    @Override
    public E pollLast() {
        TMap.Entry<E, Object> entry = this.map.pollLastEntry();
        return entry != null ? (E)entry.getKey() : null;
    }

    @Override
    public TNavigableSet<E> descendingSet() {
        return this.map.descendingKeySet();
    }

    @Override
    public TIterator<E> descendingIterator() {
        return this.map.descendingKeySet().iterator();
    }

    @Override
    public TNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.map.subMap(fromElement, true, toElement, false).navigableKeySet();
    }

    @Override
    public TNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return this.map.headMap(toElement, inclusive).navigableKeySet();
    }

    @Override
    public TNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.map.tailMap(fromElement, inclusive).navigableKeySet();
    }

    @Override
    public Object clone() {
        return new TTreeSet<E>(this);
    }
}

