/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.charset.impl;

import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCharsetDecoder;
import org.teavm.classlib.java.nio.charset.TCoderResult;

public abstract class TBufferedDecoder
extends TCharsetDecoder {
    private byte[] inArray = new byte[512];
    private char[] outArray = new char[512];

    public TBufferedDecoder(TCharset cs, float averageCharsPerByte, float maxCharsPerByte) {
        super(cs, averageCharsPerByte, maxCharsPerByte);
    }

    @Override
    protected TCoderResult decodeLoop(TByteBuffer in, TCharBuffer out) {
        TCoderResult result;
        byte[] inArray = this.inArray;
        int inPos = 0;
        int inSize = 0;
        char[] outArray = this.outArray;
        do {
            if (inPos + 32 > inSize && in.hasRemaining()) {
                for (int i = inPos; i < inSize; ++i) {
                    inArray[i - inPos] = inArray[i];
                }
                inPos = inSize - inPos;
                inSize = Math.min(in.remaining() + inPos, inArray.length);
                in.get(inArray, inPos, inSize - inPos);
                inPos = 0;
            }
            if (!out.hasRemaining()) {
                result = !in.hasRemaining() && inPos >= inSize ? TCoderResult.UNDERFLOW : TCoderResult.OVERFLOW;
                break;
            }
            int outPos = 0;
            int outSize = Math.min(out.remaining(), outArray.length);
            Controller controller = new Controller(in, out);
            result = this.arrayDecode(inArray, inPos, inSize, outArray, outPos, outSize, controller);
            inPos = controller.inPosition;
            if (result == null && outPos == controller.outPosition) {
                result = TCoderResult.UNDERFLOW;
            }
            outPos = controller.outPosition;
            out.put(outArray, 0, outPos);
        } while (result == null);
        in.position(in.position() - (inSize - inPos));
        return result;
    }

    protected abstract TCoderResult arrayDecode(byte[] var1, int var2, int var3, char[] var4, int var5, int var6, Controller var7);

    public static class Controller {
        private TByteBuffer in;
        private TCharBuffer out;
        int inPosition;
        int outPosition;

        Controller(TByteBuffer in, TCharBuffer out) {
            this.in = in;
            this.out = out;
        }

        public boolean hasMoreInput() {
            return this.in.hasRemaining();
        }

        public boolean hasMoreInput(int sz) {
            return this.in.remaining() >= sz;
        }

        public boolean hasMoreOutput() {
            return this.out.hasRemaining();
        }

        public boolean hasMoreOutput(int sz) {
            return this.out.remaining() >= sz;
        }

        public void setInPosition(int inPosition) {
            this.inPosition = inPosition;
        }

        public void setOutPosition(int outPosition) {
            this.outPosition = outPosition;
        }
    }
}

