/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferImpl;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Int32Array;

class TIntBufferNative
extends TIntBufferImpl
implements TArrayBufferViewProvider {
    Object gcRef;
    int[] array;
    boolean readOnly;
    @TNativeBufferObjectMarker
    final Object base;
    Address address;
    int capacity;
    boolean swap;

    TIntBufferNative(Object gcRef, int[] array, int position, int limit, boolean readOnly, Object base, Address address, int capacity, boolean swap) {
        super(position, limit);
        this.gcRef = gcRef;
        this.array = array;
        this.readOnly = readOnly;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.swap = swap;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    int[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return (int)(this.address.diff(Address.ofData((int[])this.array)) / 4L);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    TIntBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TIntBufferNative(this.gcRef, this.array, position, limit, readOnly, this.base, this.address.add(start * 4), capacity, this.swap);
    }

    @Override
    int getElement(int index) {
        int result = this.address.add(index * 4).getInt();
        return this.swap ? Integer.reverseBytes(result) : result;
    }

    @Override
    void putElement(int index, int value) {
        this.address.add(index * 4).putInt(this.swap ? Integer.reverseBytes(value) : value);
    }

    @Override
    void getImpl(int index, int[] dst, int offset, int length) {
        Address addr = this.address.add(index * 4);
        if (this.swap) {
            while (length-- > 0) {
                dst[offset++] = Integer.reverseBytes(addr.getInt());
                addr = addr.add(4);
            }
        } else {
            this.copy(addr, dst, offset, length);
        }
    }

    @Override
    void putImpl(int index, int[] src, int offset, int length) {
        Address addr = this.address.add(index * 4);
        if (this.swap) {
            while (length-- > 0) {
                addr.putInt(Integer.reverseBytes(src[offset++]));
                addr = addr.add(4);
            }
        } else {
            this.copy(src, offset, addr, length);
        }
    }

    @Override
    void putImpl(int index, TIntBuffer src, int offset, int length) {
        if (src instanceof TIntBufferNative) {
            TIntBufferNative srcImpl = (TIntBufferNative)src;
            Address addr = this.address.add(index * 4);
            if (srcImpl.swap == this.swap) {
                TByteBufferNative.copy(srcImpl.address.add(offset * 4), addr, length * 4);
            } else {
                Address srcAddr = srcImpl.address.add(offset * 4);
                while (length-- > 0) {
                    addr.putInt(Integer.reverseBytes(srcAddr.getInt()));
                    addr = addr.add(4);
                    srcAddr = srcAddr.add(4);
                }
            }
        } else if (this.swap) {
            Address addr = this.address.add(index * 4);
            while (length-- > 0) {
                addr.putInt(Integer.reverseBytes(src.get(offset++)));
                addr = addr.add(4);
            }
        } else {
            Address addr = this.address.add(index * 4);
            while (length-- > 0) {
                addr.putInt(src.get(offset++));
                addr = addr.add(4);
            }
        }
    }

    @Override
    public TByteOrder order() {
        return this.swap ? TByteBufferNative.oppositeOrder(TByteOrder.nativeOrder()) : TByteOrder.nativeOrder();
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new Int32Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 4;
    }

    void copy(int[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData((int[])from).add(fromOffset * 4), to, count * 4);
    }

    void copy(Address from, int[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData((int[])to).add(toOffset * 4), count * 4);
    }
}

