/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

public class TModifier {
    private static String[] modifierNames;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    private static final int[] canonicalOrder;

    private TModifier() {
    }

    public static boolean isPublic(int mod) {
        return (mod & 1) != 0;
    }

    public static boolean isPrivate(int mod) {
        return (mod & 2) != 0;
    }

    public static boolean isProtected(int mod) {
        return (mod & 4) != 0;
    }

    public static boolean isStatic(int mod) {
        return (mod & 8) != 0;
    }

    public static boolean isFinal(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isSynchronized(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean isVolatile(int mod) {
        return (mod & 0x40) != 0;
    }

    public static boolean isTransient(int mod) {
        return (mod & 0x80) != 0;
    }

    public static boolean isNative(int mod) {
        return (mod & 0x100) != 0;
    }

    public static boolean isInterface(int mod) {
        return (mod & 0x200) != 0;
    }

    public static boolean isAbstract(int mod) {
        return (mod & 0x400) != 0;
    }

    public static boolean isStrict(int mod) {
        return (mod & 0x800) != 0;
    }

    public static String toString(int mod) {
        return TModifier.toString(mod, false);
    }

    public static String toString(int mod, boolean abstractExpected) {
        StringBuilder sb = new StringBuilder();
        String[] modifierNames = TModifier.getModifierNames();
        int index = 0;
        for (int modifier : canonicalOrder) {
            if (modifier == 1024 && abstractExpected) {
                if ((mod & 0x400) == 0) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append("default");
                }
            } else if ((mod & modifier) != 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(modifierNames[index]);
            }
            ++index;
        }
        return sb.toString();
    }

    private static String[] getModifierNames() {
        if (modifierNames == null) {
            modifierNames = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp", "interface"};
        }
        return modifierNames;
    }

    static {
        canonicalOrder = new int[]{1, 4, 2, 1024, 8, 16, 128, 64, 32, 256, 2048, 512};
    }
}

