/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.intimpl;

import java.util.function.IntPredicate;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;

public class TSpecializedConcatIntStream
extends TSimpleIntStreamImpl {
    TSimpleIntStreamImpl first;
    TSimpleIntStreamImpl second;
    TSimpleIntStreamImpl current;

    public TSpecializedConcatIntStream(TSimpleIntStreamImpl first, TSimpleIntStreamImpl second) {
        this.first = first;
        this.second = second;
        this.current = first;
    }

    @Override
    public boolean next(IntPredicate consumer) {
        if (this.current == null) {
            return false;
        }
        if (this.current.next(consumer)) {
            return true;
        }
        if (this.current == this.first) {
            this.current = this.second;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    protected int estimateSize() {
        int firstSize = this.first.estimateSize();
        int secondSize = this.second.estimateSize();
        return firstSize >= 0 && secondSize >= 0 ? firstSize + secondSize : -1;
    }

    @Override
    public long count() {
        return this.first.count() + this.second.count();
    }

    @Override
    public void close() throws Exception {
        RuntimeException suppressed = null;
        try {
            this.first.close();
        }
        catch (RuntimeException e) {
            suppressed = e;
        }
        try {
            this.second.close();
        }
        catch (RuntimeException e) {
            if (suppressed != null) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }
}

