/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TArrayList;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TSet;

public class TWeakHashMap<K, V>
extends TAbstractMap<K, V>
implements TMap<K, V> {
    private static final int DEFAULT_SIZE = 16;
    private final ReferenceQueue<K> referenceQueue;
    private int elementCount;
    private Entry<K, V>[] elementData;
    private final int loadFactor;
    private int threshold;
    private int modCount;

    private static <K, V> Entry<K, V>[] newEntryArray(int size) {
        return new Entry[size];
    }

    public TWeakHashMap() {
        this(16);
    }

    public TWeakHashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = TWeakHashMap.newEntryArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = 7500;
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public TWeakHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = TWeakHashMap.newEntryArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = (int)(loadFactor * 10000.0f);
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public TWeakHashMap(TMap<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        this.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            while (this.referenceQueue.poll() != null) {
            }
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * (long)this.loadFactor / 10000L);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        this.poll();
        return new TAbstractSet<TMap.Entry<K, V>>(){

            @Override
            public int size() {
                return TWeakHashMap.this.size();
            }

            @Override
            public void clear() {
                TWeakHashMap.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    TWeakHashMap.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Object key;
                Entry entry;
                if (object instanceof TMap.Entry && (entry = TWeakHashMap.this.getEntry(((TMap.Entry)object).getKey())) != null && ((key = entry.get()) != null || entry.isNull)) {
                    return object.equals(entry);
                }
                return false;
            }

            @Override
            public TIterator<TMap.Entry<K, V>> iterator() {
                return new HashIterator(entry -> entry);
            }
        };
    }

    @Override
    public TSet<K> keySet() {
        this.poll();
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new TAbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return TWeakHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return TWeakHashMap.this.size();
                }

                @Override
                public void clear() {
                    TWeakHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (TWeakHashMap.this.containsKey(key)) {
                        TWeakHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public TIterator<K> iterator() {
                    return new HashIterator<Object>(TMap.Entry::getKey);
                }

                @Override
                public Object[] toArray() {
                    TArrayList coll = new TArrayList(this.size());
                    TIterator iter = this.iterator();
                    while (iter.hasNext()) {
                        coll.add(iter.next());
                    }
                    return coll.toArray();
                }

                @Override
                public <T> T[] toArray(T[] contents) {
                    ArrayList coll = new ArrayList(this.size());
                    TIterator iter = this.iterator();
                    while (iter.hasNext()) {
                        coll.add(iter.next());
                    }
                    return coll.toArray(contents);
                }
            };
        }
        return this.cachedKeySet;
    }

    @Override
    public TCollection<V> values() {
        this.poll();
        if (this.cachedValues == null) {
            this.cachedValues = new TAbstractCollection<V>(){

                @Override
                public int size() {
                    return TWeakHashMap.this.size();
                }

                @Override
                public void clear() {
                    TWeakHashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return TWeakHashMap.this.containsValue(object);
                }

                @Override
                public TIterator<V> iterator() {
                    return new HashIterator<Object>(TMap.Entry::getValue);
                }
            };
        }
        return this.cachedValues;
    }

    @Override
    public V get(Object key) {
        this.poll();
        if (key != null) {
            int index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null) {
                if (key.equals(entry.get())) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private Entry<K, V> getEntry(Object key) {
        this.poll();
        if (key != null) {
            int index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null) {
                if (key.equals(entry.get())) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.poll();
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void poll() {
        Entry toRemove;
        while ((toRemove = (Entry)this.referenceQueue.poll()) != null) {
            this.removeEntry(toRemove);
        }
    }

    private void removeEntry(Entry<K, V> toRemove) {
        Entry<K, V> last = null;
        int index = (toRemove.hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (toRemove == entry) {
                ++this.modCount;
                if (last == null) {
                    this.elementData[index] = entry.next;
                } else {
                    last.next = entry.next;
                }
                --this.elementCount;
                break;
            }
            last = entry;
            entry = entry.next;
        }
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> entry;
        this.poll();
        int index = 0;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !key.equals(entry.get())) {
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                entry = entry.next;
            }
        }
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = key == null ? 0 : (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = new Entry<K, V>(key, value, this.referenceQueue);
            entry.next = this.elementData[index];
            this.elementData[index] = entry;
            return null;
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    private void rehash() {
        int length = this.elementData.length << 1;
        if (length == 0) {
            length = 1;
        }
        Entry<K, V>[] newData = TWeakHashMap.newEntryArray(length);
        Entry<K, V>[] entryArray = this.elementData;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry<K, V> elementDatum;
            Entry<K, V> entry = elementDatum = entryArray[i];
            while (entry != null) {
                int index = entry.isNull ? 0 : (entry.hash & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> entry;
        this.poll();
        int index = 0;
        Entry<K, V> last = null;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !key.equals(entry.get())) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            return entry.value;
        }
        return null;
    }

    @Override
    public int size() {
        this.poll();
        return this.elementCount;
    }

    private void putAllImpl(TMap<? extends K, ? extends V> map) {
        if (map.entrySet() != null) {
            super.putAll(map);
        }
    }

    private static final class Entry<K, V>
    extends WeakReference<K>
    implements TMap.Entry<K, V> {
        int hash;
        boolean isNull;
        V value;
        Entry<K, V> next;

        Entry(K key, V object, ReferenceQueue<K> queue) {
            super(key, queue);
            this.isNull = key == null;
            this.hash = this.isNull ? 0 : key.hashCode();
            this.value = object;
        }

        @Override
        public K getKey() {
            return (K)super.get();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V object) {
            V result = this.value;
            this.value = object;
            return result;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)other;
            Object key = super.get();
            return Objects.equals(key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        public int hashCode() {
            return this.hash ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(super.get()) + "=" + String.valueOf(this.value);
        }

        static interface Type<R, K, V> {
            public R get(TMap.Entry<K, V> var1);
        }
    }

    class HashIterator<R>
    implements TIterator<R> {
        private int position;
        private int expectedModCount;
        private Entry<K, V> currentEntry;
        private Entry<K, V> nextEntry;
        private K nextKey;
        final Entry.Type<R, K, V> type;

        HashIterator(Entry.Type<R, K, V> type) {
            this.type = type;
            this.expectedModCount = TWeakHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null && (this.nextKey != null || this.nextEntry.isNull)) {
                return true;
            }
            while (true) {
                if (this.nextEntry == null) {
                    while (this.position < TWeakHashMap.this.elementData.length) {
                        this.nextEntry = TWeakHashMap.this.elementData[this.position++];
                        if (this.nextEntry == null) continue;
                    }
                    if (this.nextEntry == null) {
                        return false;
                    }
                }
                this.nextKey = this.nextEntry.get();
                if (this.nextKey != null || this.nextEntry.isNull) {
                    return true;
                }
                this.nextEntry = this.nextEntry.next;
            }
        }

        @Override
        public R next() {
            if (this.expectedModCount == TWeakHashMap.this.modCount) {
                if (this.hasNext()) {
                    this.currentEntry = this.nextEntry;
                    this.nextEntry = this.currentEntry.next;
                    R result = this.type.get(this.currentEntry);
                    this.nextKey = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            if (this.expectedModCount != TWeakHashMap.this.modCount) throw new ConcurrentModificationException();
            if (this.currentEntry == null) throw new IllegalStateException();
            TWeakHashMap.this.removeEntry(this.currentEntry);
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

