/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.teavm.classlib.impl.ResourceBundleImpl;

public abstract class TResourceBundle {
    protected TResourceBundle parent;
    private Locale locale;
    private static final TResourceBundle MISSING = new MissingBundle();
    private static final TResourceBundle MISSINGBASE = new MissingBundle();
    private static final Map<String, TResourceBundle> cache = new HashMap<String, TResourceBundle>();
    private static final Map<String, Supplier<ResourceBundle>> bundleProviders = ResourceBundleImpl.createBundleMap(false);
    private String name;

    public static TResourceBundle getBundle(String bundleName) throws MissingResourceException {
        return TResourceBundle.getBundleImpl(bundleName, Locale.getDefault(), ClassLoader.getSystemClassLoader());
    }

    public static TResourceBundle getBundle(String bundleName, Locale locale) {
        return TResourceBundle.getBundleImpl(bundleName, locale, ClassLoader.getSystemClassLoader());
    }

    public static TResourceBundle getBundle(String bundleName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (loader == null) {
            throw new NullPointerException();
        }
        if (bundleName != null) {
            TResourceBundle bundle;
            if (!locale.equals(Locale.getDefault()) && (bundle = TResourceBundle.handleGetBundle(bundleName, "_" + String.valueOf(locale), false)) != null) {
                return bundle;
            }
            bundle = TResourceBundle.handleGetBundle(bundleName, "_" + String.valueOf(Locale.getDefault()), true);
            if (bundle != null) {
                return bundle;
            }
            throw new MissingResourceException("Bundle not found", bundleName + "_" + String.valueOf(locale), "");
        }
        throw new NullPointerException();
    }

    private static TResourceBundle getBundleImpl(String bundleName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (bundleName != null) {
            TResourceBundle bundle;
            Object localeName;
            if (!locale.equals(Locale.getDefault())) {
                localeName = locale.toString();
                if (((String)localeName).length() > 0) {
                    localeName = "_" + (String)localeName;
                }
                if ((bundle = TResourceBundle.handleGetBundle(bundleName, (String)localeName, false)) != null) {
                    return bundle;
                }
            }
            if (((String)(localeName = Locale.getDefault().toString())).length() > 0) {
                localeName = "_" + (String)localeName;
            }
            if ((bundle = TResourceBundle.handleGetBundle(bundleName, (String)localeName, true)) != null) {
                return bundle;
            }
            throw new MissingResourceException("Bundle not found", bundleName + "_" + String.valueOf(locale), "");
        }
        throw new NullPointerException();
    }

    public abstract Enumeration<String> getKeys();

    public Locale getLocale() {
        return this.locale;
    }

    public String getBaseBundleName() {
        return this.name;
    }

    public final Object getObject(String key) {
        TResourceBundle last;
        TResourceBundle theParent = this;
        do {
            Object result;
            if ((result = theParent.handleGetObject(key)) != null) {
                return result;
            }
            last = theParent;
        } while ((theParent = theParent.parent) != null);
        throw new MissingResourceException("", last.getClass().getName(), key);
    }

    public boolean containsKey(String key) {
        TResourceBundle theParent = this;
        do {
            Object result;
            if ((result = theParent.handleGetObject(key)) == null) continue;
            return true;
        } while ((theParent = theParent.parent) != null);
        return false;
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    private static TResourceBundle handleGetBundle(String base, String locale, boolean loadBase) {
        String bundleName = base + locale;
        TResourceBundle result = cache.get(bundleName);
        if (result != null) {
            if (result == MISSINGBASE) {
                return null;
            }
            if (result == MISSING) {
                if (!loadBase) {
                    return null;
                }
                String extension = TResourceBundle.strip(locale);
                if (extension == null) {
                    return null;
                }
                return TResourceBundle.handleGetBundle(base, extension, loadBase);
            }
            return result;
        }
        Supplier<ResourceBundle> provider = bundleProviders.get(bundleName);
        TResourceBundle bundle = provider != null ? (TResourceBundle)((Object)provider.get()) : null;
        String extension = TResourceBundle.strip(locale);
        if (bundle != null) {
            TResourceBundle parent;
            if (extension != null && (parent = TResourceBundle.handleGetBundle(base, extension, true)) != null) {
                bundle.setParent(parent);
            }
            cache.put(bundleName, bundle);
            bundle.name = base;
            return bundle;
        }
        if (extension != null && (loadBase || extension.length() > 0) && (bundle = TResourceBundle.handleGetBundle(base, extension, loadBase)) != null) {
            cache.put(bundleName, bundle);
            bundle.name = base;
            return bundle;
        }
        cache.put(bundleName, loadBase ? MISSINGBASE : MISSING);
        return null;
    }

    protected abstract Object handleGetObject(String var1);

    protected void setParent(TResourceBundle bundle) {
        this.parent = bundle;
    }

    private static String strip(String name) {
        int index = name.lastIndexOf(95);
        if (index != -1) {
            return name.substring(0, index);
        }
        return null;
    }

    private void setLocale(String name) {
        String language = "";
        String country = "";
        String variant = "";
        if (name.length() > 1) {
            int nextIndex = name.indexOf(95, 1);
            if (nextIndex == -1) {
                nextIndex = name.length();
            }
            language = name.substring(1, nextIndex);
            if (nextIndex + 1 < name.length()) {
                int index = nextIndex;
                if ((nextIndex = name.indexOf(95, nextIndex + 1)) == -1) {
                    nextIndex = name.length();
                }
                country = name.substring(index + 1, nextIndex);
                if (nextIndex + 1 < name.length()) {
                    variant = name.substring(nextIndex + 1);
                }
            }
        }
        this.locale = new Locale(language, country, variant);
    }

    static class MissingBundle
    extends TResourceBundle {
        MissingBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        public Object handleGetObject(String name) {
            return null;
        }
    }
}

