/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import org.teavm.classlib.impl.text.DoubleAnalyzer;
import org.teavm.classlib.impl.text.DoubleSynthesizer;
import org.teavm.classlib.impl.text.FloatAnalyzer;
import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.java.lang.TArithmeticException;
import org.teavm.classlib.java.text.TDecimalFormatParser;
import org.teavm.classlib.java.text.TDecimalFormatSymbols;
import org.teavm.classlib.java.text.TFieldPosition;
import org.teavm.classlib.java.text.TNumberFormat;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.util.TLocale;

public class TDecimalFormat
extends TNumberFormat {
    private static final long[] POW10_ARRAY = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final int[] POW10_INT_ARRAY = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final long MAX_LONG_DIV_10 = 0xCCCCCCCCCCCCCCCL;
    TDecimalFormatSymbols symbols;
    FormatField[] positivePrefix = new FormatField[0];
    FormatField[] negativePrefix = new FormatField[]{new TextField("-")};
    FormatField[] positiveSuffix = new FormatField[0];
    FormatField[] negativeSuffix = new FormatField[0];
    private int multiplier = 1;
    private int groupingSize;
    private boolean decimalSeparatorAlwaysShown;
    private boolean parseBigDecimal;
    int exponentDigits;
    String pattern;

    public TDecimalFormat() {
        this(CLDRHelper.resolveNumberFormat(TLocale.getDefault().getLanguage(), TLocale.getDefault().getCountry()));
    }

    public TDecimalFormat(String pattern) {
        this(pattern, new TDecimalFormatSymbols());
    }

    public TDecimalFormat(String pattern, TDecimalFormatSymbols value) {
        this.symbols = (TDecimalFormatSymbols)value.clone();
        this.applyPattern(pattern);
    }

    public void applyPattern(String pattern) {
        TDecimalFormatParser parser = new TDecimalFormatParser();
        parser.parse(pattern);
        parser.apply(this);
        this.pattern = pattern;
    }

    String toPattern() {
        return this.pattern;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols symbols) {
        this.symbols = (TDecimalFormatSymbols)symbols.clone();
    }

    private StringBuffer fieldsToText(FormatField[] fields, StringBuffer buffer) {
        for (FormatField field : fields) {
            field.render(this, buffer);
        }
        return buffer;
    }

    private String fieldsToText(FormatField[] fields) {
        if (fields == null) {
            return null;
        }
        return this.fieldsToText(fields, new StringBuffer()).toString();
    }

    private FormatField[] textToFields(String text) {
        return new FormatField[]{new TextField(text)};
    }

    public String getPositivePrefix() {
        return this.fieldsToText(this.positivePrefix);
    }

    public void setPositivePrefix(String newValue) {
        this.positivePrefix = this.textToFields(newValue);
    }

    public String getNegativePrefix() {
        return this.fieldsToText(this.negativePrefix);
    }

    public void setNegativePrefix(String newValue) {
        this.negativePrefix = this.textToFields(newValue);
    }

    public String getPositiveSuffix() {
        return this.fieldsToText(this.positiveSuffix);
    }

    public void setPositiveSuffix(String newValue) {
        this.positiveSuffix = this.textToFields(newValue);
    }

    public String getNegativeSuffix() {
        return this.fieldsToText(this.negativeSuffix);
    }

    public void setNegativeSuffix(String newValue) {
        this.negativeSuffix = this.textToFields(newValue);
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int newValue) {
        this.multiplier = newValue;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int newValue) {
        this.groupingSize = newValue;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.decimalSeparatorAlwaysShown = newValue;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean newValue) {
        this.parseBigDecimal = newValue;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TDecimalFormat)) {
            return false;
        }
        TDecimalFormat other = (TDecimalFormat)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return Arrays.equals(this.positivePrefix, other.positivePrefix) && Arrays.equals(this.positiveSuffix, other.positiveSuffix) && Arrays.equals(this.negativePrefix, other.negativePrefix) && Arrays.equals(this.negativeSuffix, other.negativeSuffix) && this.multiplier == other.multiplier && this.groupingSize == other.groupingSize && this.decimalSeparatorAlwaysShown == other.decimalSeparatorAlwaysShown && this.parseBigDecimal == other.parseBigDecimal && this.exponentDigits == other.exponentDigits;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + Arrays.hashCode(this.positivePrefix);
        result = result * 31 + Arrays.hashCode(this.positiveSuffix);
        result = result * 31 + Arrays.hashCode(this.negativePrefix);
        result = result * 31 + Arrays.hashCode(this.negativeSuffix);
        result = result * 31 + this.multiplier;
        result = result * 31 + this.groupingSize;
        result = result * 31 + (this.decimalSeparatorAlwaysShown ? 1 : 0);
        result = result * 31 + (this.parseBigDecimal ? 1 : 0);
        result = result * 31 + this.exponentDigits;
        return result;
    }

    @Override
    public Number parse(String string, TParsePosition position) {
        return this.isParseBigDecimal() ? this.parseBigDecimal(string, position) : this.parseNumber(string, position);
    }

    private BigDecimal parseBigDecimal(String string, TParsePosition position) {
        String suffix;
        BigInteger mantissa = BigInteger.ZERO;
        int exponent = 0;
        int index = position.getIndex();
        boolean allowGroupSeparator = false;
        String exponentSeparator = this.symbols.getExponentSeparator();
        int intSize = 0;
        int fracSize = 0;
        boolean fractionalPart = false;
        boolean positive = true;
        String negPrefix = this.getNegativePrefix();
        String posPrefix = this.getPositivePrefix();
        if (string.regionMatches(index, negPrefix, 0, negPrefix.length())) {
            positive = false;
            index += negPrefix.length();
        } else if (string.regionMatches(index, posPrefix, 0, posPrefix.length())) {
            index += posPrefix.length();
        } else {
            position.setErrorIndex(index);
            return null;
        }
        String string2 = suffix = positive ? this.getPositiveSuffix() : this.getNegativeSuffix();
        if (suffix == null) {
            suffix = this.getPositiveSuffix();
        }
        while (index < string.length()) {
            char c = string.charAt(index);
            int digit = c - this.symbols.getZeroDigit();
            if (digit >= 0 && digit <= 9) {
                if (!fractionalPart) {
                    ++intSize;
                    allowGroupSeparator = this.isGroupingUsed() && this.groupingSize > 1;
                } else {
                    ++fracSize;
                }
                mantissa = mantissa.multiply(BigInteger.TEN).add(BigInteger.valueOf(digit));
                ++index;
                continue;
            }
            if (c == this.symbols.getDecimalSeparator()) {
                if (fractionalPart) break;
                if (intSize < 1) {
                    position.setErrorIndex(index);
                    return null;
                }
                fractionalPart = true;
                allowGroupSeparator = false;
                ++index;
                continue;
            }
            if (c == this.symbols.getGroupingSeparator()) {
                if (!allowGroupSeparator) break;
                allowGroupSeparator = false;
                ++index;
                continue;
            }
            if (!string.regionMatches(index, exponentSeparator, 0, exponentSeparator.length()) || this.exponentDigits == 0) break;
            if ((index += exponentSeparator.length()) == string.length()) {
                position.setErrorIndex(index);
                return null;
            }
            boolean positiveExponent = true;
            if (string.charAt(index) == this.symbols.getMinusSign()) {
                positiveExponent = false;
                ++index;
            }
            int exponentLength = 0;
            while (index < string.length() && (digit = string.charAt(index) - this.symbols.getZeroDigit()) >= 0 && digit <= 9) {
                exponent = exponent * 10 + digit;
                ++exponentLength;
                ++index;
            }
            if (exponentLength == 0) {
                position.setErrorIndex(index);
                return null;
            }
            if (positiveExponent) break;
            exponent = -exponent;
            break;
        }
        if (fracSize == 0 && fractionalPart && !this.isDecimalSeparatorAlwaysShown()) {
            position.setErrorIndex(index);
            return null;
        }
        if (suffix != null && !string.regionMatches(index, suffix, 0, suffix.length())) {
            position.setErrorIndex(index);
            return null;
        }
        position.setIndex(index);
        BigDecimal result = new BigDecimal(mantissa, -(exponent -= fracSize));
        if (this.multiplier != 1) {
            result = result.divide(BigDecimal.valueOf(this.multiplier));
        }
        if (!positive) {
            result = result.negate();
        }
        return result;
    }

    private Number parseNumber(String string, TParsePosition position) {
        String suffix;
        long mantissa = 0L;
        int shift = 0;
        int exponent = 0;
        int index = position.getIndex();
        boolean allowGroupSeparator = false;
        String exponentSeparator = this.symbols.getExponentSeparator();
        int intSize = 0;
        int fracSize = 0;
        boolean fractionalPart = false;
        boolean positive = true;
        String negPrefix = this.getNegativePrefix();
        String posPrefix = this.getPositivePrefix();
        if (string.regionMatches(index, negPrefix, 0, negPrefix.length())) {
            positive = false;
            index += negPrefix.length();
        } else if (string.regionMatches(index, posPrefix, 0, posPrefix.length())) {
            index += posPrefix.length();
        } else {
            position.setErrorIndex(index);
            return null;
        }
        String string2 = suffix = positive ? this.getPositiveSuffix() : this.getNegativeSuffix();
        if (suffix == null) {
            suffix = this.getPositiveSuffix();
        }
        if (string.regionMatches(index, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            if (suffix != null && !string.regionMatches(index += this.symbols.getInfinity().length(), suffix, 0, suffix.length())) {
                position.setErrorIndex(index);
                return null;
            }
            position.setIndex(index);
            return positive ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        while (index < string.length()) {
            char c = string.charAt(index);
            int digit = c - this.symbols.getZeroDigit();
            if (digit >= 0 && digit <= 9) {
                if (!fractionalPart) {
                    ++intSize;
                    allowGroupSeparator = this.isGroupingUsed() && this.groupingSize > 1;
                } else {
                    ++fracSize;
                }
                if (mantissa > 0xCCCCCCCCCCCCCCCL) {
                    if (shift == 0 && digit > 5) {
                        ++mantissa;
                    }
                    ++shift;
                } else {
                    long next = mantissa * 10L;
                    if (next > Long.MAX_VALUE - (long)digit) {
                        ++shift;
                    } else {
                        mantissa = next + (long)digit;
                    }
                }
                ++index;
                continue;
            }
            if (c == this.symbols.getDecimalSeparator()) {
                if (fractionalPart) break;
                if (intSize < 1) {
                    position.setErrorIndex(index);
                    return null;
                }
                fractionalPart = true;
                allowGroupSeparator = false;
                ++index;
                continue;
            }
            if (c == this.symbols.getGroupingSeparator()) {
                if (!allowGroupSeparator) break;
                allowGroupSeparator = false;
                ++index;
                continue;
            }
            if (!string.regionMatches(index, exponentSeparator, 0, exponentSeparator.length()) || this.exponentDigits == 0) break;
            if ((index += exponentSeparator.length()) == string.length()) {
                position.setErrorIndex(index);
                return null;
            }
            boolean positiveExponent = true;
            if (string.charAt(index) == this.symbols.getMinusSign()) {
                positiveExponent = false;
                ++index;
            }
            int exponentLength = 0;
            while (index < string.length() && (digit = string.charAt(index) - this.symbols.getZeroDigit()) >= 0 && digit <= 9) {
                exponent = exponent * 10 + digit;
                ++exponentLength;
                ++index;
            }
            if (exponentLength == 0) {
                position.setErrorIndex(index);
                return null;
            }
            if (positiveExponent) break;
            exponent = -exponent;
            break;
        }
        if (fracSize == 0 && fractionalPart && !this.isDecimalSeparatorAlwaysShown()) {
            position.setErrorIndex(index);
            return null;
        }
        if (suffix != null && !string.regionMatches(index, suffix, 0, suffix.length())) {
            position.setErrorIndex(index);
            return null;
        }
        position.setIndex(index);
        if (this.multiplier != 1) {
            int multiplierDigits = this.fastLn10(this.multiplier);
            if (POW10_INT_ARRAY[multiplierDigits] != this.multiplier) {
                mantissa /= (long)this.multiplier;
            } else {
                exponent -= multiplierDigits;
            }
        }
        if ((exponent += shift - fracSize) > 0 && exponent < POW10_ARRAY.length) {
            if (mantissa < Long.MAX_VALUE / POW10_ARRAY[exponent]) {
                mantissa *= POW10_ARRAY[exponent];
                exponent = 0;
            }
        } else if (exponent < 0 && -exponent < POW10_ARRAY.length && mantissa % POW10_ARRAY[-exponent] == 0L) {
            mantissa /= POW10_ARRAY[-exponent];
            exponent = 0;
        }
        if (mantissa == 0L && !positive) {
            return -0.0;
        }
        if (exponent == 0) {
            return positive ? mantissa : -mantissa;
        }
        exponent += 18;
        if (mantissa != 0L) {
            while (mantissa / 1000000000000000000L == 0L) {
                mantissa *= 10L;
                --exponent;
            }
        }
        return DoubleSynthesizer.synthesizeDouble(mantissa, exponent, !positive);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer buffer, TFieldPosition field) {
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, buffer, field);
        }
        if (object instanceof BigInteger) {
            return this.format((BigInteger)object, buffer, field);
        }
        return super.format(object, buffer, field);
    }

    private StringBuffer format(BigInteger value, StringBuffer buffer, TFieldPosition field) {
        return this.format(new BigDecimal(value), buffer, field);
    }

    private StringBuffer format(BigDecimal value, StringBuffer buffer, TFieldPosition field) {
        if (this.exponentDigits > 0) {
            this.formatExponent(value, buffer);
        } else {
            this.formatRegular(value, buffer);
        }
        return buffer;
    }

    @Override
    public StringBuffer format(long value, StringBuffer buffer, TFieldPosition field) {
        if (this.exponentDigits > 0) {
            this.formatExponent(value, buffer);
        } else {
            this.formatRegular(value, buffer);
        }
        return buffer;
    }

    @Override
    public StringBuffer format(double value, StringBuffer buffer, TFieldPosition field) {
        if (Double.isNaN(value)) {
            this.fieldsToText(this.positivePrefix, buffer).append(this.symbols.getNaN());
            this.appendSuffix(true, buffer);
        } else if (Double.isInfinite(value)) {
            this.fieldsToText(value > 0.0 ? this.positivePrefix : this.negativePrefix, buffer).append(this.symbols.getInfinity());
            this.appendSuffix(value > 0.0, buffer);
        } else {
            DoubleAnalyzer.Result analysisResult = Constants.doubleAnalysisResult;
            DoubleAnalyzer.analyze(value, analysisResult);
            if (this.exponentDigits > 0) {
                this.formatExponent(analysisResult.mantissa, analysisResult.exponent, !analysisResult.sign, buffer);
            } else {
                this.formatRegular(analysisResult.mantissa, analysisResult.exponent, !analysisResult.sign, buffer);
            }
        }
        return buffer;
    }

    private void formatExponent(long value, StringBuffer buffer) {
        long absValue = Math.abs(value);
        int exponent = this.fastLn10(absValue);
        this.formatExponent(absValue, exponent, value >= 0L, buffer);
    }

    private void formatRegular(long value, StringBuffer buffer) {
        long absValue = Math.abs(value);
        int exponent = this.fastLn10(absValue);
        this.formatRegular(absValue, exponent, value >= 0L, buffer);
    }

    private void formatExponent(long mantissa, int exponent, boolean sign, StringBuffer buffer) {
        int i;
        int newMantissaLength;
        int visibleExponent = this.fastLn10(mantissa);
        int mantissaLength = visibleExponent + 1;
        if (this.multiplier != 1) {
            int multiplierDigits = this.fastLn10(this.multiplier);
            int tenMultiplier = POW10_INT_ARRAY[multiplierDigits];
            if (tenMultiplier == this.multiplier) {
                exponent += multiplierDigits;
            } else {
                if (mantissa >= Long.MAX_VALUE / (long)this.multiplier) {
                    this.formatExponent(new BigDecimal(BigInteger.valueOf(mantissa), visibleExponent - exponent), buffer);
                    return;
                }
                visibleExponent = this.fastLn10(mantissa *= (long)this.multiplier);
                mantissaLength = visibleExponent + 1;
            }
        }
        int significantSize = this.getMinimumIntegerDigits() + this.getMaximumFractionDigits();
        int exponentMultiplier = this.getMaximumIntegerDigits() - this.getMinimumIntegerDigits() + 1;
        if (exponentMultiplier > 1) {
            int delta = exponent - exponent / exponentMultiplier * exponentMultiplier;
            exponent -= delta;
            visibleExponent -= delta;
        } else {
            exponent -= this.getMinimumIntegerDigits() - 1;
            visibleExponent -= this.getMinimumIntegerDigits() - 1;
        }
        if (significantSize < 0) {
            mantissa = 0L;
        } else if (significantSize < mantissaLength && (newMantissaLength = this.fastLn10(mantissa = this.applyRounding(mantissa, mantissaLength, significantSize, sign)) + 1) > mantissaLength) {
            mantissaLength = newMantissaLength;
            ++exponent;
            ++visibleExponent;
        }
        this.fieldsToText(sign ? this.positivePrefix : this.negativePrefix, buffer);
        int exponentPos = Math.max(visibleExponent, 0);
        for (i = mantissaLength - 1; i >= exponentPos; --i) {
            long mantissaDigitMask = POW10_ARRAY[i];
            buffer.append(this.forDigit((int)(mantissa / mantissaDigitMask)));
            mantissa %= mantissaDigitMask;
        }
        for (i = exponentPos - 1; i >= visibleExponent; --i) {
            buffer.append('0');
        }
        int requiredSize = (significantSize -= mantissaLength - visibleExponent) - (this.getMaximumFractionDigits() - this.getMinimumFractionDigits());
        if (requiredSize > 0 || mantissa != 0L && significantSize > 0) {
            buffer.append(this.symbols.getDecimalSeparator());
            int limit = Math.max(0, visibleExponent - significantSize);
            int count = 0;
            for (int i2 = visibleExponent - 1; i2 >= limit; --i2) {
                long mantissaDigitMask = POW10_ARRAY[i2];
                buffer.append(this.forDigit((int)(mantissa / mantissaDigitMask)));
                ++count;
                if ((mantissa %= mantissaDigitMask) == 0L) break;
            }
            while (count++ < requiredSize) {
                buffer.append('0');
            }
        }
        buffer.append(this.symbols.getExponentSeparator());
        if (exponent < 0) {
            exponent = -exponent;
            buffer.append(this.symbols.getMinusSign());
        }
        int exponentLength = Math.max(this.exponentDigits, this.fastLn10(exponent) + 1);
        for (int i3 = exponentLength - 1; i3 >= 0; --i3) {
            int exponentDigit = POW10_INT_ARRAY[i3];
            buffer.append(this.forDigit(exponent / exponentDigit));
            exponent %= exponentDigit;
        }
        this.appendSuffix(sign, buffer);
    }

    private void formatRegular(long mantissa, int exponent, boolean sign, StringBuffer buffer) {
        int i;
        int newMantissaLength;
        int roundingPos;
        int mantissaLength = this.fastLn10(mantissa) + 1;
        ++exponent;
        if (this.multiplier != 1) {
            int multiplierDigits = this.fastLn10(this.multiplier);
            int tenMultiplier = POW10_INT_ARRAY[multiplierDigits];
            if (tenMultiplier == this.multiplier) {
                exponent += multiplierDigits;
            } else {
                if (mantissa >= Long.MAX_VALUE / (long)this.multiplier) {
                    this.formatRegular(new BigDecimal(BigInteger.valueOf(mantissa), mantissaLength - exponent), buffer);
                    return;
                }
                mantissaLength = this.fastLn10(mantissa *= (long)this.multiplier) + 1;
            }
        }
        if ((roundingPos = exponent + this.getMaximumFractionDigits()) < 0) {
            mantissa = 0L;
        } else if (roundingPos < mantissaLength && (newMantissaLength = this.fastLn10(mantissa = this.applyRounding(mantissa, mantissaLength, roundingPos, sign)) + 1) > mantissaLength) {
            mantissaLength = newMantissaLength;
            ++exponent;
        }
        this.fieldsToText(sign ? this.positivePrefix : this.negativePrefix, buffer);
        int intLength = Math.max(0, exponent);
        int digitPos = Math.max(intLength, this.getMinimumIntegerDigits()) - 1;
        for (int i2 = this.getMinimumIntegerDigits() - 1; i2 >= intLength; --i2) {
            buffer.append('0');
            if (this.isGroupingUsed() && this.groupingSize > 0 && digitPos % this.groupingSize == 0 && digitPos > 0) {
                buffer.append(this.symbols.getGroupingSeparator());
            }
            --digitPos;
        }
        int significantIntDigits = Math.min(mantissaLength, intLength);
        int mantissaDigit = mantissaLength - 1;
        for (i = 0; i < significantIntDigits; ++i) {
            long mantissaDigitMask = POW10_ARRAY[mantissaDigit--];
            buffer.append(this.forDigit(Math.abs((int)(mantissa / mantissaDigitMask))));
            mantissa %= mantissaDigitMask;
            if (this.isGroupingUsed() && this.groupingSize > 0 && digitPos % this.groupingSize == 0 && digitPos > 0) {
                buffer.append(this.symbols.getGroupingSeparator());
            }
            --digitPos;
        }
        intLength -= significantIntDigits;
        for (i = 0; i < intLength; ++i) {
            buffer.append('0');
            if (this.isGroupingUsed() && this.groupingSize > 0 && digitPos % this.groupingSize == 0 && digitPos > 0) {
                buffer.append(this.symbols.getGroupingSeparator());
            }
            --digitPos;
        }
        if (mantissa == 0L) {
            if (this.getMinimumFractionDigits() == 0) {
                if (this.isDecimalSeparatorAlwaysShown()) {
                    buffer.append(this.symbols.getDecimalSeparator());
                }
            } else {
                buffer.append(this.symbols.getDecimalSeparator());
                for (i = 0; i < this.getMinimumFractionDigits(); ++i) {
                    buffer.append('0');
                }
            }
        } else {
            int i3;
            buffer.append(this.symbols.getDecimalSeparator());
            int fracZeros = Math.min(this.getMaximumFractionDigits(), Math.max(0, -exponent));
            digitPos = 0;
            for (int i4 = 0; i4 < fracZeros; ++i4) {
                ++digitPos;
                buffer.append('0');
            }
            int significantFracDigits = Math.min(this.getMaximumFractionDigits() - digitPos, mantissaDigit);
            for (i3 = 0; i3 < significantFracDigits && mantissa != 0L; ++i3) {
                ++digitPos;
                long mantissaDigitMask = POW10_ARRAY[mantissaDigit];
                buffer.append(this.forDigit(Math.abs((int)(mantissa / mantissaDigitMask))));
                mantissa %= mantissaDigitMask;
                --mantissaDigit;
            }
            for (i3 = digitPos; i3 < this.getMinimumFractionDigits(); ++i3) {
                ++digitPos;
                buffer.append('0');
            }
        }
        this.appendSuffix(sign, buffer);
    }

    private void formatExponent(BigDecimal value, StringBuffer buffer) {
        int i;
        if (this.multiplier != 1) {
            value = value.multiply(BigDecimal.valueOf(this.multiplier));
        }
        boolean positive = value.compareTo(BigDecimal.ZERO) >= 0;
        int mantissaLength = value.precision();
        int visibleExponent = mantissaLength - 1;
        int exponent = visibleExponent - value.scale();
        BigInteger mantissa = value.unscaledValue();
        int significantSize = this.getMinimumIntegerDigits() + this.getMaximumFractionDigits();
        int exponentMultiplier = this.getMaximumIntegerDigits() - this.getMinimumIntegerDigits() + 1;
        if (exponentMultiplier > 1) {
            int delta = exponent - exponent / exponentMultiplier * exponentMultiplier;
            exponent -= delta;
            visibleExponent -= delta;
        } else {
            exponent -= this.getMinimumIntegerDigits() - 1;
            visibleExponent -= this.getMinimumIntegerDigits() - 1;
        }
        if (significantSize < 0) {
            mantissa = BigInteger.ZERO;
        } else if (significantSize < mantissaLength) {
            mantissa = this.applyRounding(mantissa, mantissaLength, significantSize);
        }
        this.fieldsToText(positive ? this.positivePrefix : this.negativePrefix, buffer);
        int exponentPos = Math.max(visibleExponent, 0);
        BigInteger mantissaDigitMask = this.pow10(BigInteger.ONE, mantissaLength - 1);
        for (i = mantissaLength - 1; i >= exponentPos; --i) {
            BigInteger[] parts = mantissa.divideAndRemainder(mantissaDigitMask);
            buffer.append(this.forDigit(Math.abs(parts[0].intValue())));
            mantissa = parts[1];
            mantissaDigitMask = mantissaDigitMask.divide(BigInteger.TEN);
        }
        for (i = exponentPos - 1; i >= visibleExponent; --i) {
            buffer.append('0');
        }
        int requiredSize = (significantSize -= mantissaLength - visibleExponent) - (this.getMaximumFractionDigits() - this.getMinimumFractionDigits());
        if (requiredSize > 0 || !mantissa.equals(BigInteger.ZERO) && significantSize > 0) {
            buffer.append(this.symbols.getDecimalSeparator());
            int limit = Math.max(0, visibleExponent - significantSize);
            int count = 0;
            for (int i2 = visibleExponent - 1; i2 >= limit; --i2) {
                BigInteger[] parts = mantissa.divideAndRemainder(mantissaDigitMask);
                buffer.append(this.forDigit(Math.abs(parts[0].intValue())));
                mantissa = parts[1];
                ++count;
                if (mantissa.equals(BigInteger.ZERO)) break;
                mantissaDigitMask = mantissaDigitMask.divide(BigInteger.TEN);
            }
            while (count++ < requiredSize) {
                buffer.append('0');
            }
        }
        buffer.append(this.symbols.getExponentSeparator());
        if (exponent < 0) {
            exponent = -exponent;
            buffer.append(this.symbols.getMinusSign());
        }
        int exponentLength = Math.max(this.exponentDigits, this.fastLn10(exponent) + 1);
        for (int i3 = exponentLength - 1; i3 >= 0; --i3) {
            int exponentDigit = POW10_INT_ARRAY[i3];
            buffer.append(this.forDigit(exponent / exponentDigit));
            exponent %= exponentDigit;
        }
        this.appendSuffix(positive, buffer);
    }

    private void appendSuffix(boolean positive, StringBuffer buffer) {
        if (positive) {
            if (this.positiveSuffix != null) {
                this.fieldsToText(this.positiveSuffix, buffer);
            }
        } else {
            this.fieldsToText(this.negativeSuffix != null ? this.negativeSuffix : (this.positiveSuffix != null ? this.positiveSuffix : new FormatField[]{}), buffer);
        }
    }

    private void formatRegular(BigDecimal value, StringBuffer buffer) {
        int i;
        BigInteger mantissa;
        if (this.multiplier != 1) {
            value = value.multiply(BigDecimal.valueOf(this.multiplier));
        }
        boolean positive = (mantissa = value.unscaledValue()).compareTo(BigInteger.ZERO) >= 0;
        int mantissaLength = value.precision();
        int exponent = value.precision() - value.scale();
        int roundingPos = exponent + this.getMaximumFractionDigits();
        if (roundingPos < 0) {
            mantissa = BigInteger.ZERO;
        } else if (roundingPos < mantissaLength) {
            mantissa = this.applyRounding(mantissa, mantissaLength, roundingPos);
        }
        this.fieldsToText(positive ? this.positivePrefix : this.negativePrefix, buffer);
        int intLength = Math.max(0, exponent);
        int digitPos = Math.max(intLength, this.getMinimumIntegerDigits()) - 1;
        for (int i2 = this.getMinimumIntegerDigits() - 1; i2 >= intLength; --i2) {
            buffer.append('0');
            if (this.isGroupingUsed() && this.groupingSize > 0 && digitPos % this.groupingSize == 0 && digitPos > 0) {
                buffer.append(this.symbols.getGroupingSeparator());
            }
            --digitPos;
        }
        int significantIntDigits = Math.min(mantissaLength, intLength);
        BigInteger mantissaDigitMask = this.pow10(BigInteger.ONE, mantissaLength - 1);
        for (i = 0; i < significantIntDigits; ++i) {
            BigInteger[] parts = mantissa.divideAndRemainder(mantissaDigitMask);
            buffer.append(this.forDigit(Math.abs(parts[0].intValue())));
            mantissa = parts[1];
            if (this.isGroupingUsed() && this.groupingSize > 0 && digitPos % this.groupingSize == 0 && digitPos > 0) {
                buffer.append(this.symbols.getGroupingSeparator());
            }
            --digitPos;
            --mantissaLength;
            mantissaDigitMask = mantissaDigitMask.divide(BigInteger.TEN);
        }
        intLength -= significantIntDigits;
        for (i = 0; i < intLength; ++i) {
            buffer.append('0');
            if (this.isGroupingUsed() && this.groupingSize > 0 && digitPos % this.groupingSize == 0 && digitPos > 0) {
                buffer.append(this.symbols.getGroupingSeparator());
            }
            --digitPos;
        }
        if (mantissa.equals(BigInteger.ZERO)) {
            if (this.getMinimumFractionDigits() == 0) {
                if (this.isDecimalSeparatorAlwaysShown()) {
                    buffer.append(this.symbols.getDecimalSeparator());
                }
            } else {
                buffer.append(this.symbols.getDecimalSeparator());
                for (i = 0; i < this.getMinimumFractionDigits(); ++i) {
                    buffer.append('0');
                }
            }
        } else {
            int i3;
            buffer.append(this.symbols.getDecimalSeparator());
            int fracZeros = Math.min(this.getMaximumFractionDigits(), Math.max(0, -exponent));
            digitPos = 0;
            for (int i4 = 0; i4 < fracZeros; ++i4) {
                ++digitPos;
                buffer.append('0');
            }
            int significantFracDigits = Math.min(this.getMaximumFractionDigits() - digitPos, mantissaLength);
            for (i3 = 0; i3 < significantFracDigits && !mantissa.equals(BigInteger.ZERO); ++i3) {
                ++digitPos;
                BigInteger[] parts = mantissa.divideAndRemainder(mantissaDigitMask);
                buffer.append(this.forDigit(Math.abs(parts[0].intValue())));
                mantissa = parts[1];
                --mantissaLength;
                mantissaDigitMask = mantissaDigitMask.divide(BigInteger.TEN);
            }
            for (i3 = digitPos; i3 < this.getMinimumFractionDigits(); ++i3) {
                ++digitPos;
                buffer.append('0');
            }
        }
        this.appendSuffix(positive, buffer);
    }

    private long applyRounding(long mantissa, int mantissaLength, int exponent, boolean sign) {
        long rounding = POW10_ARRAY[mantissaLength - exponent];
        switch (this.getRoundingMode()) {
            case CEILING: {
                mantissa = mantissa / rounding * rounding;
                if (!sign) break;
                mantissa += rounding;
                break;
            }
            case FLOOR: {
                mantissa = mantissa / rounding * rounding;
                if (sign) break;
                mantissa += rounding;
                break;
            }
            case UP: {
                mantissa = mantissa / rounding * rounding + rounding;
                break;
            }
            case DOWN: {
                mantissa = mantissa / rounding * rounding;
                break;
            }
            case UNNECESSARY: {
                if (mantissa % rounding == 0L) break;
                throw new TArithmeticException("Can't avoid rounding");
            }
            case HALF_DOWN: {
                if (mantissa % rounding == rounding / 2L) {
                    mantissa = mantissa / rounding * rounding;
                    break;
                }
                mantissa = (mantissa + rounding / 2L) / rounding * rounding;
                break;
            }
            case HALF_UP: {
                if (mantissa % rounding == rounding / 2L) {
                    mantissa = mantissa / rounding * rounding + rounding;
                    break;
                }
                mantissa = (mantissa + rounding / 2L) / rounding * rounding;
                break;
            }
            case HALF_EVEN: {
                if (mantissa % rounding == rounding / 2L) {
                    if ((mantissa = mantissa / rounding * rounding) / rounding % 2L == 0L) break;
                    mantissa += rounding;
                    break;
                }
                mantissa = (mantissa + rounding / 2L) / rounding * rounding;
            }
        }
        return mantissa;
    }

    private BigInteger applyRounding(BigInteger mantissa, int mantissaLength, int exponent) {
        BigInteger rounding = this.pow10(BigInteger.ONE, mantissaLength - exponent);
        BigInteger signedRounding = mantissa.compareTo(BigInteger.ZERO) >= 0 ? rounding : rounding.negate();
        switch (this.getRoundingMode()) {
            case CEILING: {
                mantissa = mantissa.divide(rounding).multiply(rounding);
                if (mantissa.compareTo(BigInteger.ZERO) < 0) break;
                mantissa = mantissa.add(rounding);
                break;
            }
            case FLOOR: {
                mantissa = mantissa.divide(rounding).multiply(rounding);
                if (mantissa.compareTo(BigInteger.ZERO) > 0) break;
                mantissa = mantissa.subtract(rounding);
                break;
            }
            case UP: {
                mantissa = mantissa.divide(rounding).multiply(rounding).add(signedRounding);
                break;
            }
            case DOWN: {
                mantissa = mantissa.divide(rounding).multiply(rounding);
                break;
            }
            case UNNECESSARY: {
                if (!mantissa.remainder(rounding).equals(BigInteger.ZERO)) break;
                throw new TArithmeticException("Can't avoid rounding");
            }
            case HALF_DOWN: {
                if (mantissa.remainder(rounding).equals(signedRounding.divide(BigInteger.valueOf(2L)))) {
                    mantissa = mantissa.divide(rounding).multiply(rounding);
                    break;
                }
                mantissa = mantissa.add(signedRounding.divide(BigInteger.valueOf(2L))).divide(rounding).multiply(rounding);
                break;
            }
            case HALF_UP: {
                if (mantissa.remainder(rounding).equals(signedRounding.divide(BigInteger.valueOf(2L)))) {
                    mantissa = mantissa.divide(rounding).multiply(rounding).add(signedRounding);
                    break;
                }
                mantissa = mantissa.add(signedRounding.divide(BigInteger.valueOf(2L))).divide(rounding).multiply(rounding);
                break;
            }
            case HALF_EVEN: {
                if (mantissa.remainder(rounding).equals(signedRounding.divide(BigInteger.valueOf(2L)))) {
                    if ((mantissa = mantissa.divide(rounding).multiply(rounding)).divide(rounding).remainder(BigInteger.valueOf(2L)).equals(BigInteger.ZERO)) break;
                    mantissa = mantissa.add(signedRounding);
                    break;
                }
                mantissa = mantissa.add(signedRounding.divide(BigInteger.valueOf(2L))).divide(rounding).multiply(rounding);
            }
        }
        return mantissa;
    }

    private int fastLn10(long value) {
        if (value == Long.MIN_VALUE) {
            return 18;
        }
        int result = 0;
        if (value >= 10000000000000000L) {
            result += 16;
            value /= 10000000000000000L;
        }
        if (value >= 100000000L) {
            result += 8;
            value /= 100000000L;
        }
        if (value >= 10000L) {
            result += 4;
            value /= 10000L;
        }
        if (value >= 100L) {
            result += 2;
            value /= 100L;
        }
        if (value >= 10L) {
            ++result;
            value /= 10L;
        }
        return result;
    }

    private int fastLn10(int value) {
        int result = 0;
        if (value >= 100000000) {
            result += 8;
            value /= 100000000;
        }
        if (value >= 10000) {
            result += 4;
            value /= 10000;
        }
        if (value >= 100) {
            result += 2;
            value /= 100;
        }
        if (value >= 10) {
            ++result;
            value /= 10;
        }
        return result;
    }

    private BigInteger pow10(BigInteger value, int power) {
        BigInteger digit = BigInteger.TEN;
        while (power != 0) {
            if ((power & 1) != 0) {
                value = value.multiply(digit);
            }
            digit = digit.multiply(digit);
            power >>>= 1;
        }
        return value;
    }

    private char forDigit(int n) {
        return (char)(this.symbols.getZeroDigit() + n);
    }

    static interface FormatField {
        public void render(TDecimalFormat var1, StringBuffer var2);
    }

    static class TextField
    implements FormatField {
        private String text;

        public TextField(String text) {
            this.text = text;
        }

        @Override
        public void render(TDecimalFormat format, StringBuffer buffer) {
            buffer.append(this.text);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TextField)) {
                return false;
            }
            TextField other = (TextField)obj;
            return this.text.equals(other.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }
    }

    static class Constants {
        static final DoubleAnalyzer.Result doubleAnalysisResult = new DoubleAnalyzer.Result();
        static final FloatAnalyzer.Result floatAnalysisResult = new FloatAnalyzer.Result();

        Constants() {
        }
    }

    static class MinusField
    implements FormatField {
        MinusField() {
        }

        @Override
        public void render(TDecimalFormat format, StringBuffer buffer) {
            buffer.append(format.symbols.getMinusSign());
        }

        public boolean equals(Object obj) {
            return obj instanceof MinusField;
        }

        public int hashCode() {
            return 3;
        }
    }

    static class PerMillField
    implements FormatField {
        PerMillField() {
        }

        @Override
        public void render(TDecimalFormat format, StringBuffer buffer) {
            buffer.append(format.symbols.getPerMill());
        }

        public boolean equals(Object obj) {
            return obj instanceof PerMillField;
        }

        public int hashCode() {
            return 2;
        }
    }

    static class PercentField
    implements FormatField {
        PercentField() {
        }

        @Override
        public void render(TDecimalFormat format, StringBuffer buffer) {
            buffer.append(format.symbols.getPercent());
        }

        public boolean equals(Object obj) {
            return obj instanceof PercentField;
        }

        public int hashCode() {
            return 1;
        }
    }

    static class CurrencyField
    implements FormatField {
        CurrencyField() {
        }

        @Override
        public void render(TDecimalFormat format, StringBuffer buffer) {
            if (format.getCurrency() == null) {
                buffer.append('\u00a4');
            } else {
                buffer.append(format.getCurrency().getSymbol(format.symbols.getLocale()));
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof CurrencyField;
        }

        public int hashCode() {
            return 0;
        }
    }

    static class MantissaAndExponent {
        long mantissa;
        int exponent;

        public MantissaAndExponent(long mantissa, int exponent) {
            this.mantissa = mantissa;
            this.exponent = exponent;
        }
    }
}

