/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Int8Array;

class TDoubleBufferOverDataView
extends TDoubleBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private DataView data;
    private boolean littleEndian;

    TDoubleBufferOverDataView(int position, int limit, boolean readOnly, DataView data, boolean littleEndian) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.littleEndian = littleEndian;
    }

    @Override
    TDoubleBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + start * 8, capacity * 8);
        return new TDoubleBufferOverDataView(position, limit, readOnly, slice, this.littleEndian);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    double getElement(int index) {
        return this.data.getFloat64(index * 8, this.littleEndian);
    }

    @Override
    void putElement(int index, double value) {
        this.data.setFloat64(index * 8, value, this.littleEndian);
    }

    @Override
    void getImpl(int index, double[] dst, int offset, int length) {
        index *= 8;
        while (length-- > 0) {
            dst[offset++] = this.data.getFloat64(index, this.littleEndian);
            index += 8;
        }
    }

    @Override
    void putImpl(int index, TDoubleBuffer src, int offset, int length) {
        if (src instanceof TDoubleBufferOverDataView) {
            TDoubleBufferOverDataView srcImpl = (TDoubleBufferOverDataView)src;
            Int8Array srcArray = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset * 8, length *= 8);
            Int8Array destArray = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index * 8, length);
            destArray.set((ArrayBufferView)srcArray, 0);
        } else {
            index *= 8;
            while (length-- > 0) {
                this.data.setFloat64(index, src.get(offset++), this.littleEndian);
                index += 8;
            }
        }
    }

    @Override
    void putImpl(int index, double[] src, int offset, int length) {
        index *= 8;
        while (length-- > 0) {
            this.data.setFloat64(index, src[offset++], this.littleEndian);
            index += 8;
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    double[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteOrder order() {
        return this.littleEndian ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    int capacityImpl() {
        return this.data.getByteLength() / 8;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 8;
    }
}

