/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRCurrency;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.CurrencyLocalization;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;

public class CurrencyLocalizationMetadataGenerator
implements MetadataGenerator {
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader reader = (CLDRReader)context.getService(CLDRReader.class);
        ResourceMap map = context.createResourceMap();
        for (Map.Entry<String, CLDRLocale> localeEntry : reader.getKnownLocales().entrySet()) {
            CLDRLocale locale = localeEntry.getValue();
            ResourceMap currencies = context.createResourceMap();
            map.put(localeEntry.getKey(), (Resource)currencies);
            for (Map.Entry<String, CLDRCurrency> currencyEntry : locale.getCurrencies().entrySet()) {
                CLDRCurrency currency = currencyEntry.getValue();
                CurrencyLocalization localization = (CurrencyLocalization)context.createResource(CurrencyLocalization.class);
                localization.setName(currency.getName());
                localization.setSymbol(currency.getSymbol() != null ? currency.getSymbol() : "");
                currencies.put(currencyEntry.getKey(), (Resource)localization);
            }
        }
        return map;
    }
}

