/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.Consumer;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TLinkedHashMapIterator;
import org.teavm.classlib.java.util.TSequencedCollection;

class TLinkedHashMapValues<V>
extends TAbstractCollection<V>
implements TSequencedCollection<V> {
    private final TLinkedHashMap<?, V> base;
    private final boolean reversed;

    TLinkedHashMapValues(TLinkedHashMap<?, V> base, boolean reversed) {
        this.base = base;
        this.reversed = reversed;
    }

    @Override
    public final int size() {
        return this.base.size();
    }

    @Override
    public final void clear() {
        this.base.clear();
    }

    @Override
    public final TIterator<V> iterator() {
        return new TLinkedHashMapIterator.ValueIterator(this.base, this.reversed);
    }

    @Override
    public final boolean contains(Object o) {
        return this.base.containsValue(o);
    }

    @Override
    public final void forEach(Consumer<? super V> action) {
        if (this.base.elementCount > 0) {
            int prevModCount = this.base.modCount;
            TLinkedHashMap.LinkedHashMapEntry entry = this.reversed ? this.base.tail : this.base.head;
            do {
                action.accept(entry.value);
                TLinkedHashMap.LinkedHashMapEntry linkedHashMapEntry = entry = this.reversed ? entry.chainBackward : entry.chainForward;
                if (this.base.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    @Override
    public final V getFirst() {
        return (V)TLinkedHashMap.checkNotNull(this.reversed ? this.base.tail : this.base.head).value;
    }

    @Override
    public final V getLast() {
        return (V)TLinkedHashMap.checkNotNull(this.reversed ? this.base.head : this.base.tail).value;
    }

    @Override
    public final V removeFirst() {
        THashMap.HashEntry e = TLinkedHashMap.checkNotNull(this.reversed ? this.base.tail : this.base.head);
        return this.base.remove(e.key);
    }

    @Override
    public final V removeLast() {
        THashMap.HashEntry e = TLinkedHashMap.checkNotNull(this.reversed ? this.base.head : this.base.tail);
        return this.base.remove(e.key);
    }

    @Override
    public TSequencedCollection<V> reversed() {
        if (this.reversed) {
            return this.base.sequencedValues();
        }
        return new TLinkedHashMapValues<V>(this.base, true);
    }
}

