/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.Consumer;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TLinkedHashMapIterator;
import org.teavm.classlib.java.util.TSequencedSet;

class TLinkedHashMapKeySet<K>
extends TAbstractSet<K>
implements TSequencedSet<K> {
    private final TLinkedHashMap<K, ?> base;
    private final boolean reversed;

    TLinkedHashMapKeySet(TLinkedHashMap<K, ?> base, boolean reversed) {
        this.base = base;
        this.reversed = reversed;
    }

    @Override
    public final int size() {
        return this.base.elementCount;
    }

    @Override
    public final void clear() {
        this.base.clear();
    }

    @Override
    public final TIterator<K> iterator() {
        return new TLinkedHashMapIterator.KeyIterator(this.base, this.reversed);
    }

    @Override
    public final boolean contains(Object o) {
        return this.base.containsKey(o);
    }

    @Override
    public final boolean remove(Object key) {
        int befCount = this.base.elementCount;
        this.base.remove(key);
        return this.base.elementCount != befCount;
    }

    @Override
    public final void forEach(Consumer<? super K> action) {
        if (this.base.elementCount > 0) {
            int prevModCount = this.base.modCount;
            TLinkedHashMap.LinkedHashMapEntry entry = this.reversed ? this.base.tail : this.base.head;
            do {
                action.accept(entry.key);
                TLinkedHashMap.LinkedHashMapEntry linkedHashMapEntry = entry = this.reversed ? entry.chainBackward : entry.chainForward;
                if (this.base.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    @Override
    public final K getFirst() {
        return (K)TLinkedHashMap.checkNotNull(this.reversed ? this.base.tail : this.base.head).key;
    }

    @Override
    public final K getLast() {
        return (K)TLinkedHashMap.checkNotNull(this.reversed ? this.base.head : this.base.tail).key;
    }

    @Override
    public final K removeFirst() {
        TLinkedHashMap.LinkedHashMapEntry e = TLinkedHashMap.checkNotNull(this.reversed ? this.base.tail : this.base.head);
        this.base.remove(e.key);
        return (K)e.key;
    }

    @Override
    public final K removeLast() {
        TLinkedHashMap.LinkedHashMapEntry e = TLinkedHashMap.checkNotNull(this.reversed ? this.base.head : this.base.tail);
        this.base.remove(e.key);
        return (K)e.key;
    }

    @Override
    public TSequencedSet<K> reversed() {
        if (this.reversed) {
            return this.base.sequencedKeySet();
        }
        return new TLinkedHashMapKeySet<K>(this.base, true);
    }
}

