/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import java.io.OutputStream;
import org.teavm.classlib.java.io.TDataOutput;
import org.teavm.classlib.java.io.TFilterOutputStream;
import org.teavm.classlib.java.lang.TDouble;
import org.teavm.classlib.java.lang.TFloat;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TString;

public class TDataOutputStream
extends TFilterOutputStream
implements TDataOutput {
    protected int written;
    byte[] buff = new byte[8];

    public TDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    public final int size() {
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
        return this.written;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) {
            throw new TNullPointerException();
        }
        this.out.write(buffer, offset, count);
        this.written += count;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.out.write(oneByte);
        ++this.written;
    }

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.out.write(val ? 1 : 0);
        ++this.written;
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.out.write(val);
        ++this.written;
    }

    @Override
    public final void writeBytes(TString str) throws IOException {
        if (str.length() == 0) {
            return;
        }
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)str.charAt(index);
        }
        this.out.write(bytes);
        this.written += bytes.length;
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.buff[0] = (byte)(val >> 8);
        this.buff[1] = (byte)val;
        this.out.write(this.buff, 0, 2);
        this.written += 2;
    }

    @Override
    public final void writeChars(TString str) throws IOException {
        byte[] newBytes = new byte[str.length() * 2];
        for (int index = 0; index < str.length(); ++index) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(str.charAt(index) >> 8);
            newBytes[newIndex + 1] = (byte)str.charAt(index);
        }
        this.out.write(newBytes);
        this.written += newBytes.length;
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.writeLong(TDouble.doubleToLongBits(val));
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.writeInt(TFloat.floatToIntBits(val));
    }

    @Override
    public final void writeInt(int val) throws IOException {
        this.buff[0] = (byte)(val >> 24);
        this.buff[1] = (byte)(val >> 16);
        this.buff[2] = (byte)(val >> 8);
        this.buff[3] = (byte)val;
        this.out.write(this.buff, 0, 4);
        this.written += 4;
    }

    @Override
    public final void writeLong(long val) throws IOException {
        this.buff[0] = (byte)(val >> 56);
        this.buff[1] = (byte)(val >> 48);
        this.buff[2] = (byte)(val >> 40);
        this.buff[3] = (byte)(val >> 32);
        this.buff[4] = (byte)(val >> 24);
        this.buff[5] = (byte)(val >> 16);
        this.buff[6] = (byte)(val >> 8);
        this.buff[7] = (byte)val;
        this.out.write(this.buff, 0, 8);
        this.written += 8;
    }

    int writeLongToBuffer(long val, byte[] buffer, int offset) throws IOException {
        buffer[offset++] = (byte)(val >> 56);
        buffer[offset++] = (byte)(val >> 48);
        buffer[offset++] = (byte)(val >> 40);
        buffer[offset++] = (byte)(val >> 32);
        buffer[offset++] = (byte)(val >> 24);
        buffer[offset++] = (byte)(val >> 16);
        buffer[offset++] = (byte)(val >> 8);
        buffer[offset++] = (byte)val;
        return offset;
    }

    @Override
    public final void writeShort(int val) throws IOException {
        this.buff[0] = (byte)(val >> 8);
        this.buff[1] = (byte)val;
        this.out.write(this.buff, 0, 2);
        this.written += 2;
    }

    int writeShortToBuffer(int val, byte[] buffer, int offset) throws IOException {
        buffer[offset++] = (byte)(val >> 8);
        buffer[offset++] = (byte)val;
        return offset;
    }

    @Override
    public final void writeUTF(TString str) throws IOException {
        long utfCount = this.countUTFBytes(str);
        if (utfCount > 65535L) {
            throw new IOException("UTF Error");
        }
        byte[] buffer = new byte[(int)utfCount + 2];
        int offset = 0;
        offset = this.writeShortToBuffer((int)utfCount, buffer, offset);
        offset = this.writeUTFBytesToBuffer(str, buffer, offset);
        this.write(buffer, 0, offset);
    }

    long countUTFBytes(TString str) {
        int utfCount = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            utfCount += 3;
        }
        return utfCount;
    }

    int writeUTFBytesToBuffer(TString str, byte[] buffer, int offset) throws IOException {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                buffer[offset++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                buffer[offset++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                buffer[offset++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            buffer[offset++] = (byte)(0xE0 | 0xF & charValue >> 12);
            buffer[offset++] = (byte)(0x80 | 0x3F & charValue >> 6);
            buffer[offset++] = (byte)(0x80 | 0x3F & charValue);
        }
        return offset;
    }
}

