/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Float32Array;

class TFloatBufferOverTypedArray
extends TFloatBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private Float32Array data;
    private float[] array;

    TFloatBufferOverTypedArray(int position, int limit, boolean readOnly, Float32Array data, float[] array) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.array = array;
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        Float32Array slice = new Float32Array(this.data.getBuffer(), this.data.getByteOffset() + start * 4, capacity);
        return new TFloatBufferOverTypedArray(position, limit, readOnly, slice, this.array);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    float getElement(int index) {
        return this.data.get(index);
    }

    @Override
    void putElement(int index, float value) {
        this.data.set(index, value);
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    float[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.data.getByteOffset() / 4;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, float[] dst, int offset, int length) {
        Float32Array slice = new Float32Array(this.data.getBuffer(), this.data.getByteOffset() + index * 4, length);
        Float32Array.fromJavaArray((float[])dst).set((ArrayBufferView)slice, offset);
    }

    @Override
    void putImpl(int index, float[] src, int offset, int length) {
        Float32Array slice = new Float32Array(Float32Array.fromJavaArray((float[])src).getBuffer(), offset * 4, length);
        this.data.set((ArrayBufferView)slice, index);
    }

    @Override
    void putImpl(int index, TFloatBuffer src, int offset, int length) {
        if (src instanceof TFloatBufferOverTypedArray) {
            TFloatBufferOverTypedArray srcImpl = (TFloatBufferOverTypedArray)src;
            Float32Array slice = new Float32Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + index * 4, length);
            this.data.set((ArrayBufferView)slice, index);
        } else {
            while (length-- > 0) {
                this.data.set(index++, src.get(offset++));
            }
        }
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 4;
    }
}

