/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import org.teavm.classlib.java.lang.reflect.BaseAnnotationDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGCAnnotationDependencyListener
extends BaseAnnotationDependencyListener {
    public WasmGCAnnotationDependencyListener() {
        super(true);
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        super.methodReached(agent, method);
        MethodReference methodRef = method.getMethod().getReference();
        if (methodRef.getClassName().equals("java.lang.Class") && methodRef.getName().equals("getDeclaredAnnotationsImpl")) {
            method.getResult().propagate(agent.getType("[" + Annotation.class.getName()));
            this.reachGetAnnotations(agent, method.getVariable(0), method.getResult().getArrayItem());
        }
    }

    private void reachGetAnnotations(DependencyAgent agent, DependencyNode inputNode, DependencyNode outputNode) {
        inputNode.getClassValueNode().addConsumer(type -> {
            String className = type.getName();
            ClassReader cls = agent.getClassSource().get(className);
            if (cls == null) {
                return;
            }
            for (AnnotationReader annotation : cls.getAnnotations().all()) {
                agent.linkClass(annotation.getType());
            }
            this.propagateAnnotationImplementations(agent, cls, outputNode);
        });
    }

    private void propagateAnnotationImplementations(DependencyAgent agent, ClassReader cls, DependencyNode outputNode) {
        ArrayList<AnnotationReader> annotations = new ArrayList<AnnotationReader>();
        for (AnnotationReader annot : cls.getAnnotations().all()) {
            String retentionPolicy;
            AnnotationReader retention;
            ClassReader annotType = agent.getClassSource().get(annot.getType());
            if (annotType == null || (retention = annotType.getAnnotations().get(Retention.class.getName())) == null || !(retentionPolicy = retention.getValue("value").getEnumValue().getFieldName()).equals("RUNTIME")) continue;
            annotations.add(annot);
        }
        for (AnnotationReader annotation : annotations) {
            this.propagateAnnotationInstance(agent, annotation, outputNode);
        }
    }

    private void propagateAnnotationInstance(DependencyAgent agent, AnnotationReader annotation, DependencyNode outputNode) {
        ClassReader annotationClass = agent.getClassSource().get(annotation.getType());
        if (annotationClass == null) {
            return;
        }
        String implementor = this.getAnnotationImplementor(agent, annotation.getType());
        if (implementor != null) {
            agent.linkClass(implementor).initClass(null);
            outputNode.propagate(agent.getType(implementor));
            for (MethodReader methodDecl : annotationClass.getMethods()) {
                if (methodDecl.hasModifier(ElementModifier.STATIC)) continue;
                AnnotationValue value = annotation.getValue(methodDecl.getName());
                if (value == null) {
                    value = methodDecl.getAnnotationDefault();
                }
                FieldDependency field = agent.linkField(new FieldReference(implementor, "$" + methodDecl.getName()));
                this.propagateAnnotationValue(agent, value, methodDecl.getResultType(), field.getValue());
            }
        }
    }

    private void propagateAnnotationValue(DependencyAgent agent, AnnotationValue value, ValueType type, DependencyNode outputNode) {
        switch (value.getType()) {
            case 9: {
                outputNode.propagate(agent.getType(type.toString()));
                ValueType itemType = ((ValueType.Array)type).getItemType();
                for (AnnotationValue annotationValue : value.getList()) {
                    this.propagateAnnotationValue(agent, annotationValue, itemType, outputNode.getArrayItem());
                }
                break;
            }
            case 10: {
                break;
            }
            case 8: {
                String className;
                ValueType cls = value.getJavaClass();
                while (cls instanceof ValueType.Array) {
                    cls = ((ValueType.Array)cls).getItemType();
                }
                if (cls instanceof ValueType.Object) {
                    className = ((ValueType.Object)cls).getClassName();
                    agent.linkClass(className).initClass(null);
                }
                if (value.getJavaClass() instanceof ValueType.Object) {
                    className = ((ValueType.Object)value.getJavaClass()).getClassName();
                    outputNode.getClassValueNode().propagate(agent.getType(className));
                } else {
                    outputNode.getClassValueNode().propagate(agent.getType(value.getJavaClass().toString()));
                }
                outputNode.propagate(agent.getType("java.lang.Class"));
                break;
            }
            case 11: {
                this.propagateAnnotationInstance(agent, value.getAnnotation(), outputNode);
            }
        }
    }
}

