/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.threeten.bp.format.SimpleDateTimeTextProvider;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.TemporalField;

public abstract class DateTimeTextProvider {
    private static DateTimeTextProvider mutableProvider;

    static DateTimeTextProvider getInstance() {
        return ProviderSingleton.PROVIDER;
    }

    public static void setInitializer(DateTimeTextProvider provider) {
        if (mutableProvider != null) {
            throw new IllegalStateException("Provider was already set, possibly with a default during initialization");
        }
        mutableProvider = provider;
    }

    public abstract String getText(TemporalField var1, long var2, TextStyle var4, Locale var5);

    public abstract Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField var1, TextStyle var2, Locale var3);

    static class ProviderSingleton {
        static final DateTimeTextProvider PROVIDER = ProviderSingleton.initialize();

        ProviderSingleton() {
        }

        static DateTimeTextProvider initialize() {
            mutableProvider = new SimpleDateTimeTextProvider();
            return mutableProvider;
        }
    }
}

