/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TTakeWhileStream<T>
extends TSimpleStreamImpl<T> {
    private TSimpleStreamImpl<T> sourceStream;
    private Predicate<? super T> predicate;
    private boolean isStopped;

    TTakeWhileStream(TSimpleStreamImpl<T> sourceStream, Predicate<? super T> predicate) {
        this.sourceStream = sourceStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        if (this.isStopped) {
            return false;
        }
        boolean result = this.sourceStream.next(e -> {
            if (!this.predicate.test(e)) {
                this.isStopped = true;
                return false;
            }
            return consumer.test(e);
        });
        if (!result) {
            this.isStopped = true;
        }
        return result;
    }
}

