/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferImpl;

class TFloatBufferOverArray
extends TFloatBufferImpl {
    boolean readOnly;
    int start;
    float[] array;

    public TFloatBufferOverArray(int capacity) {
        this(0, capacity, new float[capacity], 0, capacity, false);
    }

    public TFloatBufferOverArray(int start, int capacity, float[] array, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TFloatBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    float getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, float value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    float[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

