/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TDeque;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TObjects;

public class TArrayDeque<E>
extends TAbstractCollection<E>
implements TDeque<E>,
TCloneable,
TSerializable {
    private int version;
    private Object[] array;
    private int head;
    private int tail;

    public TArrayDeque() {
        this(8);
    }

    public TArrayDeque(int numElements) {
        this.array = new Object[numElements + 1];
    }

    public TArrayDeque(TCollection<? extends E> c) {
        if (c.isEmpty()) {
            this.array = new Object[8];
        } else {
            this.array = new Object[c.size() + 1];
            int index = 0;
            TIterator it = c.iterator();
            while (it.hasNext()) {
                this.array[index++] = it.next();
            }
            this.tail = this.array.length - 1;
        }
    }

    @Override
    public void addFirst(E e) {
        TObjects.requireNonNull(e);
        this.ensureCapacity(this.size() + 1);
        this.head = TArrayDeque.modDec(this.head, this.array.length);
        this.array[this.head] = e;
        ++this.version;
    }

    @Override
    public void addLast(E e) {
        TObjects.requireNonNull(e);
        this.ensureCapacity(this.size() + 1);
        this.array[this.tail] = e;
        this.tail = TArrayDeque.modInc(this.tail, this.array.length);
        ++this.version;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E value = this.pollFirst();
        if (value == null) {
            throw new TNoSuchElementException();
        }
        return value;
    }

    @Override
    public E removeLast() {
        E value = this.pollLast();
        if (value == null) {
            throw new TNoSuchElementException();
        }
        return value;
    }

    @Override
    public E pollFirst() {
        if (this.head == this.tail) {
            return null;
        }
        Object result = this.array[this.head];
        this.array[this.head] = null;
        this.head = TArrayDeque.modInc(this.head, this.array.length);
        ++this.version;
        return (E)result;
    }

    @Override
    public E pollLast() {
        if (this.head == this.tail) {
            return null;
        }
        this.tail = TArrayDeque.modDec(this.tail, this.array.length);
        Object result = this.array[this.tail];
        this.array[this.tail] = null;
        ++this.version;
        return (E)result;
    }

    @Override
    public E getFirst() {
        E result = this.peekFirst();
        if (result == null) {
            throw new TNoSuchElementException();
        }
        return result;
    }

    @Override
    public E getLast() {
        E result = this.peekLast();
        if (result == null) {
            throw new TNoSuchElementException();
        }
        return result;
    }

    @Override
    public E peekFirst() {
        return (E)(!this.isEmpty() ? this.array[this.head] : null);
    }

    @Override
    public E peekLast() {
        return (E)(!this.isEmpty() ? this.array[TArrayDeque.modDec(this.tail, this.array.length)] : null);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        TIterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(o)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        TIterator<E> it = this.descendingIterator();
        while (it.hasNext()) {
            if (!it.next().equals(o)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public int size() {
        return this.tail >= this.head ? this.tail - this.head : this.array.length - this.head + this.tail;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    private boolean removeAt(int index) {
        if (this.head < this.tail) {
            if (this.tail - index < index - this.head) {
                for (int i = index + 1; i < this.tail; ++i) {
                    this.array[i - 1] = this.array[i];
                }
                this.array[--this.tail] = null;
                return true;
            }
            for (int i = index - 1; i >= this.head; --i) {
                this.array[i + 1] = this.array[i];
            }
            this.array[this.head++] = null;
            return false;
        }
        if (index >= this.head) {
            for (int i = index - 1; i >= this.head; --i) {
                this.array[i + 1] = this.array[i];
            }
            this.array[this.head] = null;
            this.head = TArrayDeque.modInc(this.head, this.array.length);
            return false;
        }
        for (int i = index + 1; i < this.tail; ++i) {
            this.array[i - 1] = this.array[i];
        }
        this.tail = TArrayDeque.modDec(this.tail, this.array.length);
        this.array[this.tail] = null;
        return true;
    }

    private static int modInc(int i, int mod) {
        return ++i == mod ? 0 : i;
    }

    private static int modDec(int i, int mod) {
        return --i == -1 ? mod - 1 : i;
    }

    @Override
    public TIterator<E> iterator() {
        return new TIterator<E>(){
            private int refVersion;
            private int index;
            private int lastIndex;
            private int left;
            {
                this.refVersion = TArrayDeque.this.version;
                this.index = TArrayDeque.this.head;
                this.lastIndex = -1;
                this.left = TArrayDeque.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.left > 0;
            }

            @Override
            public E next() {
                if (--this.left < 0) {
                    throw new TNoSuchElementException();
                }
                if (TArrayDeque.this.version > this.refVersion) {
                    throw new TConcurrentModificationException();
                }
                this.lastIndex = this.index;
                Object result = TArrayDeque.this.array[this.index];
                this.index = TArrayDeque.modInc(this.index, TArrayDeque.this.array.length);
                return result;
            }

            @Override
            public void remove() {
                if (this.lastIndex < 0) {
                    throw new IllegalStateException();
                }
                boolean toLeft = TArrayDeque.this.removeAt(this.lastIndex);
                if (toLeft) {
                    this.index = TArrayDeque.modInc(this.index, TArrayDeque.this.array.length);
                }
                this.lastIndex = -1;
            }
        };
    }

    @Override
    public TIterator<E> descendingIterator() {
        return new TIterator<E>(){
            private int refVersion;
            private int index;
            private int lastIndex;
            private int left;
            {
                this.refVersion = TArrayDeque.this.version;
                this.index = TArrayDeque.this.tail;
                this.lastIndex = -1;
                this.left = TArrayDeque.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.left > 0;
            }

            @Override
            public E next() {
                if (--this.left < 0) {
                    throw new TNoSuchElementException();
                }
                if (TArrayDeque.this.version > this.refVersion) {
                    throw new TConcurrentModificationException();
                }
                this.lastIndex = this.index = TArrayDeque.modDec(this.index, TArrayDeque.this.array.length);
                Object result = TArrayDeque.this.array[this.index];
                return result;
            }

            @Override
            public void remove() {
                if (this.lastIndex < 0) {
                    throw new IllegalStateException();
                }
                boolean toLeft = TArrayDeque.this.removeAt(this.lastIndex);
                if (!toLeft) {
                    this.index = TArrayDeque.modInc(this.index, TArrayDeque.this.array.length);
                }
                this.lastIndex = -1;
            }
        };
    }

    private void ensureCapacity(int capacity) {
        if (capacity < this.array.length) {
            return;
        }
        int newArraySize = Math.max(this.array.length * 2, capacity * 3 / 2 + 1);
        if (newArraySize < 1) {
            newArraySize = Integer.MAX_VALUE;
        }
        Object[] newArray = new Object[newArraySize];
        int j = 0;
        if (this.head <= this.tail) {
            for (int i = this.head; i < this.tail; ++i) {
                newArray[j++] = this.array[i];
            }
        } else {
            int i;
            for (i = this.head; i < this.array.length; ++i) {
                newArray[j++] = this.array[i];
            }
            for (i = 0; i < this.tail; ++i) {
                newArray[j++] = this.array[i];
            }
        }
        this.head = 0;
        this.tail = j;
        this.array = newArray;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, null);
        this.head = this.tail;
    }

    @Override
    protected TArrayDeque<E> clone() {
        return new TArrayDeque<E>(this);
    }
}

