/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.charset.impl;

import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCharsetEncoder;
import org.teavm.classlib.java.nio.charset.TCoderResult;

public abstract class TBufferedEncoder
extends TCharsetEncoder {
    private char[] inArray = new char[512];
    private byte[] outArray = new byte[512];

    public TBufferedEncoder(TCharset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
        super(cs, averageBytesPerChar, maxBytesPerChar, replacement);
    }

    public TBufferedEncoder(TCharset cs, float averageBytesPerChar, float maxBytesPerChar) {
        super(cs, averageBytesPerChar, maxBytesPerChar);
    }

    @Override
    protected TCoderResult encodeLoop(TCharBuffer in, TByteBuffer out) {
        TCoderResult result;
        char[] inArray = this.inArray;
        int inPos = 0;
        int inSize = 0;
        byte[] outArray = this.outArray;
        do {
            if (inPos + 32 > inSize && in.hasRemaining()) {
                for (int i = inPos; i < inSize; ++i) {
                    inArray[i - inPos] = inArray[i];
                }
                inPos = inSize - inPos;
                inSize = Math.min(in.remaining() + inPos, inArray.length);
                in.get(inArray, inPos, inSize - inPos);
                inPos = 0;
            }
            if (!out.hasRemaining()) {
                result = !in.hasRemaining() && inPos >= inSize ? TCoderResult.UNDERFLOW : TCoderResult.OVERFLOW;
                break;
            }
            int outPos = 0;
            int outSize = Math.min(out.remaining(), outArray.length);
            Controller controller = new Controller(in, out);
            result = this.arrayEncode(inArray, inPos, inSize, outArray, outPos, outSize, controller);
            inPos = controller.inPosition;
            outPos = controller.outPosition;
            if (result == null) {
                if (!in.hasRemaining() && inPos >= inSize) {
                    result = TCoderResult.UNDERFLOW;
                } else if (!out.hasRemaining() && inPos >= inSize) {
                    result = TCoderResult.OVERFLOW;
                }
            }
            out.put(outArray, 0, outPos);
        } while (result == null);
        in.position(in.position() - (inSize - inPos));
        return result;
    }

    protected abstract TCoderResult arrayEncode(char[] var1, int var2, int var3, byte[] var4, int var5, int var6, Controller var7);

    public static class Controller {
        private TCharBuffer in;
        private TByteBuffer out;
        int inPosition;
        int outPosition;

        Controller(TCharBuffer in, TByteBuffer out) {
            this.in = in;
            this.out = out;
        }

        public boolean hasMoreInput() {
            return this.in.hasRemaining();
        }

        public boolean hasMoreInput(int sz) {
            return this.in.remaining() >= sz;
        }

        public boolean hasMoreOutput() {
            return this.out.hasRemaining();
        }

        public boolean hasMoreOutput(int sz) {
            return this.out.remaining() >= sz;
        }

        public void setInPosition(int inPosition) {
            this.inPosition = inPosition;
        }

        public void setOutPosition(int outPosition) {
            this.outPosition = outPosition;
        }
    }
}

