/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TThread;

public class TThreadLocal<T>
extends TObject {
    private Map<Object, Object> map;
    private boolean initialized;
    private T value;
    private static final Object NULL = new Object();

    protected T initialValue() {
        return null;
    }

    public T get() {
        if (TThreadLocal.isInMainThread()) {
            if (!this.initialized) {
                this.value = this.initialValue();
                this.initialized = true;
            }
            this.cleanupMap();
            return this.value;
        }
        Object key = TThread.currentThread().key;
        this.initMap();
        Object value = this.map.get(key);
        if (value == null) {
            value = this.initialValue();
            this.map.put(key, value == null ? NULL : value);
        } else if (value == NULL) {
            value = null;
        }
        this.cleanupMap();
        return (T)value;
    }

    public void set(T value) {
        if (TThreadLocal.isInMainThread()) {
            this.initialized = true;
            this.value = value;
            this.cleanupMap();
        } else {
            this.initMap();
            this.map.put(TThread.currentThread().key, value == null ? NULL : value);
            this.cleanupMap();
        }
    }

    public void remove() {
        if (TThreadLocal.isInMainThread()) {
            this.initialized = false;
            this.value = null;
            this.cleanupMap();
        } else if (this.map != null) {
            this.map.remove(TThread.currentThread().key);
            this.cleanupMap();
        }
    }

    private void initMap() {
        if (this.map == null) {
            this.map = new WeakHashMap<Object, Object>();
        }
    }

    private void cleanupMap() {
        if (this.map != null && this.map.isEmpty()) {
            this.map = null;
        }
    }

    public static <S> TThreadLocal<S> withInitial(final Supplier<? extends S> supplier) {
        return new TThreadLocal<S>(){

            @Override
            protected S initialValue() {
                return supplier.get();
            }
        };
    }

    private static boolean isInMainThread() {
        return TThread.currentThread() == TThread.getMainThread();
    }
}

