/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Properties;
import org.teavm.backend.c.intrinsic.RuntimeInclude;
import org.teavm.backend.c.runtime.Memory;
import org.teavm.backend.c.runtime.fs.CFileSystem;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.console.JSStderrPrintStream;
import org.teavm.classlib.impl.console.JSStdoutPrintStream;
import org.teavm.classlib.impl.console.StderrOutputStream;
import org.teavm.classlib.impl.console.StdoutOutputStream;
import org.teavm.classlib.java.io.TConsole;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.io.TPrintStream;
import org.teavm.classlib.java.lang.SystemDependencyPlugin;
import org.teavm.classlib.java.lang.SystemNativeGenerator;
import org.teavm.classlib.java.lang.TArrayStoreException;
import org.teavm.classlib.java.lang.TConsoleInputStream;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TSecurityManager;
import org.teavm.classlib.java.lang.reflect.TArray;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.browser.Performance;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.GC;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.fs.VirtualFileSystemProvider;

public final class TSystem
extends TObject {
    private static TPrintStream outCache;
    private static TPrintStream errCache;
    private static TInputStream inCache;
    private static Properties properties;

    private TSystem() {
    }

    public static TPrintStream out() {
        if (outCache == null) {
            outCache = PlatformDetector.isJavaScript() ? (TPrintStream)((Object)new JSStdoutPrintStream()) : new TPrintStream((OutputStream)StdoutOutputStream.INSTANCE, false);
        }
        return outCache;
    }

    public static TPrintStream err() {
        if (errCache == null) {
            errCache = PlatformDetector.isJavaScript() ? (TPrintStream)((Object)new JSStderrPrintStream()) : new TPrintStream((OutputStream)StderrOutputStream.INSTANCE, false);
        }
        return errCache;
    }

    public static TInputStream in() {
        if (inCache == null) {
            inCache = new TConsoleInputStream();
        }
        return inCache;
    }

    public static TConsole console() {
        return null;
    }

    public static TSecurityManager getSecurityManager() {
        return new TSecurityManager();
    }

    public static void arraycopy(TObject src, int srcPos, TObject dest, int destPos, int length) {
        if (src == null || dest == null) {
            throw new TNullPointerException("Either src or dest is null");
        }
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > TArray.getLength(src) || destPos + length > TArray.getLength(dest)) {
            throw new TIndexOutOfBoundsException();
        }
        if (src != dest) {
            Class<?> srcType = src.getClass().getComponentType();
            Class<?> targetType = dest.getClass().getComponentType();
            if (srcType == null || targetType == null) {
                throw new TArrayStoreException();
            }
            if (srcType != targetType) {
                if (!srcType.isPrimitive() && !targetType.isPrimitive()) {
                    Object[] srcArray = (Object[])src;
                    int pos = srcPos;
                    for (int i = 0; i < length; ++i) {
                        Object elem;
                        if (targetType.isInstance(elem = srcArray[pos++])) continue;
                        TSystem.doArrayCopy(src, srcPos, dest, destPos, i);
                        throw new TArrayStoreException();
                    }
                    TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
                    return;
                }
                if (!srcType.isPrimitive() || !targetType.isPrimitive()) {
                    throw new TArrayStoreException();
                }
            }
        }
        TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
    }

    static void fastArraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > Array.getLength(src) || destPos + length > Array.getLength(dest)) {
            throw new TIndexOutOfBoundsException();
        }
        TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemDependencyPlugin.class)
    @DelegateTo(value="doArrayCopyLowLevel")
    @NoSideEffects
    static native void doArrayCopy(Object var0, int var1, Object var2, int var3, int var4);

    @Unmanaged
    static void doArrayCopyLowLevel(RuntimeArray src, int srcPos, RuntimeArray dest, int destPos, int length) {
        RuntimeClass type = RuntimeClass.getClass((RuntimeObject)src);
        int itemSize = type.itemType.size;
        if ((type.itemType.flags & 2) == 0) {
            itemSize = Address.sizeOf();
            GC.writeBarrier((RuntimeObject)dest);
        }
        int offset = Address.align((Address)Address.fromInt((int)0).add(RuntimeArray.class, 1), (int)itemSize).toInt();
        Address srcAddress = src.toAddress().add(offset);
        srcAddress = srcAddress.add(itemSize * srcPos);
        Address destAddress = dest.toAddress().add(offset);
        destAddress = destAddress.add(itemSize * destPos);
        Allocator.moveMemoryBlock((Address)srcAddress, (Address)destAddress, (int)(length * itemSize));
    }

    @DelegateTo(value="currentTimeMillisLowLevel")
    @GeneratedBy(value=SystemNativeGenerator.class)
    @NoSideEffects
    public static native long currentTimeMillis();

    private static long currentTimeMillisLowLevel() {
        if (PlatformDetector.isWebAssembly()) {
            return WasmSupport.currentTimeMillis();
        }
        return TSystem.currentTimeMillisC();
    }

    @Import(name="teavm_currentTimeMillis")
    @RuntimeInclude(value="time.h")
    private static native long currentTimeMillisC();

    private static void initPropertiesIfNeeded() {
        if (properties == null) {
            Properties defaults = new Properties();
            defaults.put("java.version", "1.8");
            defaults.put("os.name", "TeaVM");
            defaults.put("file.separator", "/");
            defaults.put("path.separator", ":");
            defaults.put("line.separator", TSystem.lineSeparator());
            defaults.put("java.io.tmpdir", TSystem.getTempDir());
            defaults.put("java.vm.version", "1.8");
            defaults.put("user.home", TSystem.getHomeDir());
            properties = new Properties(defaults);
        }
    }

    private static String getTempDir() {
        if (!PlatformDetector.isC()) {
            return "/tmp";
        }
        Address resultPtr = Memory.malloc((int)Address.sizeOf());
        int length = CFileSystem.tempDirectory((Address)resultPtr);
        return VirtualFileSystemProvider.getInstance().canonicalize(TSystem.toJavaString(resultPtr, length));
    }

    private static String getHomeDir() {
        if (!PlatformDetector.isC()) {
            return "/";
        }
        Address resultPtr = Memory.malloc((int)Address.sizeOf());
        int length = CFileSystem.homeDirectory((Address)resultPtr);
        return VirtualFileSystemProvider.getInstance().canonicalize(TSystem.toJavaString(resultPtr, length));
    }

    private static String toJavaString(Address resultPtr, int length) {
        Address result = resultPtr.getAddress();
        Memory.free((Address)resultPtr);
        char[] chars = new char[length];
        Memory.memcpy((Address)Address.ofData((char[])chars), (Address)result, (int)(chars.length * 2));
        Memory.free((Address)result);
        return new String(chars);
    }

    public static String getProperty(String key) {
        TSystem.initPropertiesIfNeeded();
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        String value = TSystem.getProperty(key);
        return value != null ? value : def;
    }

    public static Properties getProperties() {
        TSystem.initPropertiesIfNeeded();
        Properties result = new Properties();
        TSystem.copyProperties(properties, result);
        return result;
    }

    public static void setProperties(Properties props) {
        TSystem.initPropertiesIfNeeded();
        TSystem.copyProperties(props, properties);
    }

    private static void copyProperties(Properties from, Properties to) {
        to.clear();
        if (from != null) {
            Enumeration<?> e = from.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                to.setProperty(key, from.getProperty(key));
            }
        }
    }

    public static String setProperty(String key, String value) {
        TSystem.initPropertiesIfNeeded();
        return (String)properties.put(key, value);
    }

    public static String clearProperty(String key) {
        return (String)properties.remove(key);
    }

    public static void setErr(TPrintStream err) {
        errCache = err;
    }

    public static void setOut(TPrintStream out) {
        outCache = out;
    }

    @DelegateTo(value="gcLowLevel")
    public static void gc() {
    }

    private static void gcLowLevel() {
        GC.collectGarbageFull();
    }

    public static void runFinalization() {
    }

    public static long nanoTime() {
        if (PlatformDetector.isWebAssembly()) {
            return (long)(TSystem.nanoTimeWasm() * 1000000.0);
        }
        if (PlatformDetector.isLowLevel()) {
            return TSystem.nanoTimeLowLevel();
        }
        return (long)(Performance.now() * 1000000.0);
    }

    @Import(module="teavm", name="nanoTime")
    private static native double nanoTimeWasm();

    @Import(name="teavm_currentTimeNano")
    @RuntimeInclude(value="time.h")
    private static native long nanoTimeLowLevel();

    public static int identityHashCode(Object x) {
        return ((TObject)x).identity();
    }

    public static String lineSeparator() {
        return "\n";
    }

    public static String getenv(String name) {
        return null;
    }
}

