/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.util.Objects;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.impl.IntegerUtil;
import org.teavm.classlib.java.lang.IntegerNativeGenerator;
import org.teavm.classlib.java.lang.TAbstractStringBuilder;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TSystem;
import org.teavm.interop.NoSideEffects;

public class TInteger
extends TNumber
implements TComparable<TInteger> {
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final Class<Integer> TYPE = Integer.TYPE;
    private static TInteger[] integerCache;
    private final int value;

    public TInteger(int value) {
        this.value = value;
    }

    public TInteger(String s) throws NumberFormatException {
        this(TInteger.parseInt(s));
    }

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        return new TAbstractStringBuilder(20).append(i, radix).toString();
    }

    public static int hashCode(int value) {
        return value;
    }

    public static String toHexString(int i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 4);
    }

    public static String toOctalString(int i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 3);
    }

    public static String toBinaryString(int i) {
        return IntegerUtil.toUnsignedLogRadixString(i, 1);
    }

    public static String toString(int i) {
        return TInteger.toString(i, 10);
    }

    public static int parseInt(String s, int radix) throws TNumberFormatException {
        if (s == null) {
            throw new TNumberFormatException("String is null");
        }
        return TInteger.parseIntImpl(s, 0, s.length(), radix);
    }

    public static int parseInt(CharSequence s, int beginIndex, int endIndex, int radix) throws TNumberFormatException {
        return TInteger.parseIntImpl(Objects.requireNonNull(s), beginIndex, endIndex, radix);
    }

    private static int parseIntImpl(CharSequence s, int beginIndex, int endIndex, int radix) throws TNumberFormatException {
        if (beginIndex == endIndex) {
            throw new TNumberFormatException("String is empty");
        }
        if (radix < 2 || radix > 36) {
            throw new TNumberFormatException("Illegal radix: " + radix);
        }
        boolean negative = false;
        int index = beginIndex;
        switch (s.charAt(index)) {
            case '-': {
                negative = true;
                ++index;
                break;
            }
            case '+': {
                ++index;
            }
        }
        int value = 0;
        int maxValue = 1 + Integer.MAX_VALUE / radix;
        if (index == endIndex) {
            throw new TNumberFormatException();
        }
        while (index < endIndex) {
            int digit;
            if ((digit = TInteger.decodeDigit(s.charAt(index++))) < 0) {
                throw new TNumberFormatException("String contains invalid digits: " + s.subSequence(beginIndex, endIndex));
            }
            if (digit >= radix) {
                throw new TNumberFormatException("String contains digits out of radix " + radix + ": " + s.subSequence(beginIndex, endIndex));
            }
            if (value > maxValue) {
                throw new TNumberFormatException("The value is too big for integer type");
            }
            if ((value = radix * value + digit) >= 0) continue;
            if (index == endIndex && value == Integer.MIN_VALUE && negative) {
                return Integer.MIN_VALUE;
            }
            throw new TNumberFormatException("The value is too big for int type: " + s.subSequence(beginIndex, endIndex));
        }
        return negative ? -value : value;
    }

    public static int parseInt(String s) throws TNumberFormatException {
        return TInteger.parseInt(s, 10);
    }

    public static TInteger valueOf(String s, int radix) throws TNumberFormatException {
        return TInteger.valueOf(TInteger.parseInt(s, radix));
    }

    public static TInteger valueOf(String s) throws TNumberFormatException {
        return TInteger.valueOf(s, 10);
    }

    public static TInteger valueOf(int i) {
        if (i >= -128 && i <= 127) {
            TInteger.ensureIntegerCache();
            return integerCache[i + 128];
        }
        return new TInteger(i);
    }

    private static void ensureIntegerCache() {
        if (integerCache == null) {
            integerCache = new TInteger[256];
            for (int j = 0; j < integerCache.length; ++j) {
                TInteger.integerCache[j] = new TInteger(j - 128);
            }
        }
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return TInteger.toString(this.value);
    }

    @Override
    public int hashCode() {
        return TInteger.hashCode(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TInteger && ((TInteger)other).value == this.value;
    }

    public static TInteger getInteger(TString nm) {
        return TInteger.getInteger(nm, null);
    }

    public static TInteger getInteger(TString nm, int val) {
        return TInteger.getInteger(nm, TInteger.valueOf(val));
    }

    public static TInteger getInteger(TString nm, TInteger val) {
        String result = nm != null ? TSystem.getProperty(nm.toString()) : null;
        try {
            return result != null ? TInteger.valueOf(result) : val;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static TInteger decode(String nm) throws TNumberFormatException {
        if (nm.isEmpty()) {
            throw new TNumberFormatException("Can't parse empty string");
        }
        int index = 0;
        boolean negaive = false;
        if (nm.charAt(index) == '+') {
            ++index;
        } else if (nm.charAt(index) == '-') {
            ++index;
            negaive = true;
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        int radix = 10;
        if (nm.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (nm.charAt(index) == '0') {
            if (++index == nm.length()) {
                return TInteger.valueOf(0);
            }
            if (nm.charAt(index) == 'x' || nm.charAt(index) == 'X') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException("The string does not represent a number");
        }
        int value = 0;
        int maxValue = 1 + Integer.MAX_VALUE / radix;
        while (index < nm.length()) {
            int digit;
            if ((digit = TInteger.decodeDigit(nm.charAt(index++))) < 0 || digit >= radix) {
                throw new TNumberFormatException("The string does not represent a number");
            }
            if (value > maxValue) {
                throw new TNumberFormatException("The value is too big for integer type");
            }
            if ((value = value * radix + digit) >= 0) continue;
            if (negaive && value == Integer.MIN_VALUE && index == nm.length()) {
                return TInteger.valueOf(Integer.MIN_VALUE);
            }
            throw new TNumberFormatException("The string represents a too big number");
        }
        return TInteger.valueOf(negaive ? -value : value);
    }

    private static int decodeDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        return -1;
    }

    @Override
    public int compareTo(TInteger other) {
        return TInteger.compare(this.value, other.value);
    }

    @NoSideEffects
    public static native int compare(int var0, int var1);

    public static int numberOfLeadingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 0;
        if (i >>> 16 != 0) {
            i >>>= 16;
            n |= 0x10;
        }
        if (i >>> 8 != 0) {
            i >>>= 8;
            n |= 8;
        }
        if (i >>> 4 != 0) {
            i >>>= 4;
            n |= 4;
        }
        if (i >>> 2 != 0) {
            i >>>= 2;
            n |= 2;
        }
        if (i >>> 1 != 0) {
            i >>>= 1;
            n |= 1;
        }
        return 32 - n - 1;
    }

    public static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int n = 0;
        if (i << 16 != 0) {
            i <<= 16;
            n |= 0x10;
        }
        if (i << 8 != 0) {
            i <<= 8;
            n |= 8;
        }
        if (i << 4 != 0) {
            i <<= 4;
            n |= 4;
        }
        if (i << 2 != 0) {
            i <<= 2;
            n |= 2;
        }
        if (i << 1 != 0) {
            i <<= 1;
            n |= 1;
        }
        return 32 - n - 1;
    }

    public static int highestOneBit(int i) {
        return i & Integer.MIN_VALUE >>> TInteger.numberOfLeadingZeros(i);
    }

    public static int lowestOneBit(int i) {
        return -i & i;
    }

    public static int bitCount(int i) {
        i = ((i & 0xAAAAAAAA) >>> 1) + (i & 0x55555555);
        i = ((i & 0xCCCCCCCC) >>> 2) + (i & 0x33333333);
        i = ((i & 0x70707070) >>> 4) + (i & 0x7070707);
        i = ((i & 0xF000F00) >>> 8) + (i & 0xF000F);
        i = ((i & 0x1F0000) >>> 16) + (i & 0x1F);
        return i;
    }

    public static int rotateLeft(int i, int distance) {
        return i << (distance &= 0x1F) | i >>> 32 - distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> (distance &= 0x1F) | i << 32 - distance;
    }

    public static int reverse(int i) {
        i = (i & 0xAAAAAAAA) >>> 1 | (i & 0x55555555) << 1;
        i = (i & 0xCCCCCCCC) >>> 2 | (i & 0x33333333) << 2;
        i = (i & 0xF0F0F0F0) >>> 4 | (i & 0xF0F0F0F) << 4;
        i = (i & 0xFF00FF00) >>> 8 | (i & 0xFF00FF) << 8;
        i = (i & 0xFFFF0000) >>> 16 | (i & 0xFFFF) << 16;
        return i;
    }

    public static int reverseBytes(int i) {
        i = (i & 0xFF00FF00) >>> 8 | (i & 0xFF00FF) << 8;
        i = (i >>> 16) + (i << 16);
        return i;
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    @InjectedBy(value=IntegerNativeGenerator.class)
    @NoSideEffects
    public static native int divideUnsigned(int var0, int var1);

    @InjectedBy(value=IntegerNativeGenerator.class)
    @NoSideEffects
    public static native int remainderUnsigned(int var0, int var1);

    @InjectedBy(value=IntegerNativeGenerator.class)
    @NoSideEffects
    public static native int compareUnsigned(int var0, int var1);
}

