/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.lang.reflect.Array;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;

public abstract class TAbstractCollection<E>
extends TObject
implements TCollection<E> {
    protected TAbstractCollection() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e == null ? o == null : e.equals(o))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int i = 0;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            arr[i++] = iter.next();
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i;
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else {
            for (i = size; i < a.length; ++i) {
                a[i] = null;
            }
        }
        i = 0;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i++] = iter.next();
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e == null ? o == null : e.equals(o))) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TCollection<?> c) {
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(TCollection<? extends E> c) {
        boolean changed = false;
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.add(iter.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TCollection<?> c) {
        boolean changed = false;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!c.contains(e)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(TCollection<?> c) {
        boolean changed = false;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (c.contains(e)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        TIterator iter = this.iterator();
        if (iter.hasNext()) {
            sb.append(String.valueOf(iter.next()));
        }
        while (iter.hasNext()) {
            sb.append(", ").append(String.valueOf(iter.next()));
        }
        sb.append("]");
        return sb.toString();
    }
}

