/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.javascript.ni.Injector;
import org.teavm.javascript.ni.InjectorContext;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ObjectNativeGenerator
implements Generator,
Injector,
DependencyPlugin {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getDescriptor().getName()) {
            case "<init>": {
                this.generateInit(context, writer);
                break;
            }
            case "hashCode": 
            case "identity": {
                this.generateHashCode(context, writer);
                break;
            }
            case "clone": {
                this.generateClone(context, writer);
            }
        }
    }

    public void generate(InjectorContext context, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "getClass": {
                this.generateGetClass(context);
                break;
            }
            case "wrap": {
                this.generateWrap(context);
            }
        }
    }

    public void methodAchieved(DependencyChecker checker, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "clone": {
                method.getVariable(0).connect(method.getResult());
                break;
            }
            case "getClass": {
                this.achieveGetClass(checker, method);
                break;
            }
            case "wrap": {
                method.getVariable(1).connect(method.getResult());
            }
        }
    }

    private void generateInit(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append(context.getParameterName(0)).append(".$id = $rt_nextId();").softNewLine();
    }

    private void generateGetClass(InjectorContext context) throws IOException {
        SourceWriter writer = context.getWriter();
        writer.append("$rt_cls(");
        context.writeExpr(context.getArgument(0));
        writer.append(".constructor)");
    }

    private void achieveGetClass(DependencyChecker checker, MethodDependency method) {
        String classClass = "java.lang.Class";
        MethodReference initMethod = new MethodReference(classClass, new MethodDescriptor("createNew", new ValueType[]{ValueType.object((String)classClass)}));
        checker.addEntryPoint(initMethod, new String[0]);
        method.getResult().propagate("java.lang.Class");
    }

    private void generateHashCode(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("return ").append(context.getParameterName(0)).append(".$id;").softNewLine();
    }

    private void generateClone(GeneratorContext context, SourceWriter writer) throws IOException {
        String obj = context.getParameterName(0);
        writer.append("var copy = new ").append(obj).append(".constructor();").softNewLine();
        writer.append("for (var field in " + obj + ") {").softNewLine().indent();
        writer.append("if (!" + obj + ".hasOwnProperty(field)) {").softNewLine().indent();
        writer.append("continue;").softNewLine().outdent().append("}").softNewLine();
        writer.append("copy[field] = " + obj + "[field];").softNewLine().outdent().append("}").softNewLine();
        writer.append("return copy;").softNewLine();
    }

    private void generateWrap(InjectorContext context) throws IOException {
        context.writeExpr(context.getArgument(0));
    }
}

