/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import org.teavm.classlib.impl.charset.ByteBuffer;
import org.teavm.classlib.impl.charset.CharBuffer;
import org.teavm.classlib.impl.charset.Charset;
import org.teavm.classlib.impl.charset.UTF8Charset;
import org.teavm.classlib.java.io.TIOException;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.io.TReader;
import org.teavm.classlib.java.lang.TString;

public class TInputStreamReader
extends TReader {
    private TInputStream stream;
    private Charset charset;
    private TString charsetName;
    private byte[] inData = new byte[8192];
    private ByteBuffer inBuffer = new ByteBuffer(this.inData);
    private char[] outData = new char[1024];
    private CharBuffer outBuffer = new CharBuffer(this.outData);
    private boolean streamEof;
    private boolean eof;

    public TInputStreamReader(TInputStream in, TString charsetName) {
        this(in, Charset.get(charsetName.toString()));
        this.charsetName = charsetName;
    }

    public TInputStreamReader(TInputStream in) {
        this(in, new UTF8Charset());
        this.charsetName = TString.wrap("UTF-8");
    }

    private TInputStreamReader(TInputStream in, Charset charset) {
        this.stream = in;
        this.charset = charset;
        this.outBuffer.skip(this.outBuffer.available());
        this.inBuffer.skip(this.inBuffer.available());
    }

    public TString getEncoding() {
        return this.charsetName;
    }

    @Override
    public void close() throws TIOException {
        this.stream.close();
    }

    @Override
    public int read() throws TIOException {
        if (this.eof && this.outBuffer.end()) {
            return -1;
        }
        if (!this.outBuffer.end()) {
            return this.outBuffer.get();
        }
        return this.fillBuffer() ? (int)this.outBuffer.get() : -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws TIOException {
        CharBuffer wrapBuffer = new CharBuffer(cbuf, off, off + len);
        while (!wrapBuffer.end()) {
            wrapBuffer.put(this.outBuffer);
            if (!this.outBuffer.end() || this.fillBuffer()) continue;
            break;
        }
        return wrapBuffer.position() - off;
    }

    private boolean fillBuffer() throws TIOException {
        int oldAvail;
        if (this.eof) {
            return false;
        }
        CharBuffer newBuffer = new CharBuffer(this.outData);
        newBuffer.put(this.outBuffer);
        do {
            if (this.inBuffer.end() && !this.fillReadBuffer()) {
                this.eof = true;
                break;
            }
            oldAvail = newBuffer.available();
            this.charset.decode(this.inBuffer, newBuffer);
        } while (oldAvail != newBuffer.available());
        this.outBuffer = new CharBuffer(this.outData, 0, newBuffer.position());
        return true;
    }

    private boolean fillReadBuffer() throws TIOException {
        if (this.streamEof) {
            return false;
        }
        int off = 0;
        while (!this.inBuffer.end()) {
            this.inData[off] = this.inBuffer.get();
        }
        this.inBuffer.rewind(0);
        while (off < this.inData.length) {
            int bytesRead = this.stream.read(this.inData, off, this.inData.length - off);
            if (bytesRead == -1) {
                this.streamEof = true;
                this.inBuffer = new ByteBuffer(this.inData, 0, this.inBuffer.position());
                break;
            }
            off += bytesRead;
            if (bytesRead != 0) continue;
            break;
        }
        this.inBuffer = new ByteBuffer(this.inData, 0, off);
        return true;
    }

    @Override
    public boolean ready() throws TIOException {
        return !this.outBuffer.end() || this.inBuffer.end();
    }
}

