/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers.doxia;

import java.util.List;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.tautua.markdownpapers.ast.CharRef;
import org.tautua.markdownpapers.ast.Code;
import org.tautua.markdownpapers.ast.CodeSpan;
import org.tautua.markdownpapers.ast.CodeText;
import org.tautua.markdownpapers.ast.Comment;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Emphasis;
import org.tautua.markdownpapers.ast.EmptyTag;
import org.tautua.markdownpapers.ast.EndTag;
import org.tautua.markdownpapers.ast.Header;
import org.tautua.markdownpapers.ast.Image;
import org.tautua.markdownpapers.ast.InlineUrl;
import org.tautua.markdownpapers.ast.Item;
import org.tautua.markdownpapers.ast.Line;
import org.tautua.markdownpapers.ast.LineBreak;
import org.tautua.markdownpapers.ast.Link;
import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.Paragraph;
import org.tautua.markdownpapers.ast.Quote;
import org.tautua.markdownpapers.ast.Resource;
import org.tautua.markdownpapers.ast.ResourceDefinition;
import org.tautua.markdownpapers.ast.Ruler;
import org.tautua.markdownpapers.ast.SimpleNode;
import org.tautua.markdownpapers.ast.StartTag;
import org.tautua.markdownpapers.ast.Tag;
import org.tautua.markdownpapers.ast.TagAttribute;
import org.tautua.markdownpapers.ast.TagAttributeList;
import org.tautua.markdownpapers.ast.TagBody;
import org.tautua.markdownpapers.ast.Text;
import org.tautua.markdownpapers.ast.Visitor;
import org.tautua.markdownpapers.util.DequeStack;
import org.tautua.markdownpapers.util.Stack;

public class SinkEventEmitter
implements Visitor {
    private Stack<Header> stack = new DequeStack();
    private Sink sink;

    public SinkEventEmitter(Sink sink) {
        this.sink = sink;
    }

    public void visit(CharRef node) {
        this.sink.text(node.getValue());
    }

    public void visit(Code node) {
        this.sink.verbatim(SinkEventAttributeSet.BOXED);
        node.childrenAccept((Visitor)this);
        this.sink.verbatim_();
    }

    public void visit(CodeSpan node) {
        this.sink.text(node.getText(), SinkEventAttributeSet.MONOSPACED);
    }

    public void visit(CodeText node) {
        this.sink.text(node.getValue());
    }

    public void visit(Comment node) {
        this.sink.comment(node.getText());
    }

    public void visit(Document node) {
        this.sink.body();
        node.childrenAccept((Visitor)this);
        while (this.stack.size() != 0) {
            this.sink.section_(((Header)this.stack.pop()).getLevel());
        }
        this.sink.body_();
    }

    public void visit(Emphasis node) {
        switch (node.getType()) {
            case BOLD: {
                this.sink.bold();
                this.sink.text(node.getText());
                this.sink.bold_();
                break;
            }
            case ITALIC: {
                this.sink.italic();
                this.sink.text(node.getText());
                this.sink.italic_();
                break;
            }
            case ITALIC_AND_BOLD: {
                this.sink.italic();
                this.sink.bold();
                this.sink.text(node.getText());
                this.sink.bold_();
                this.sink.italic_();
            }
        }
    }

    public void visit(EmptyTag node) {
    }

    public void visit(EndTag node) {
    }

    public void visit(Header node) {
        if (this.stack.size() == 0) {
            this.stack.push((Object)node);
        } else if (((Header)this.stack.peek()).getLevel() < node.getLevel()) {
            this.stack.push((Object)node);
        } else {
            do {
                this.sink.section_(((Header)this.stack.pop()).getLevel());
            } while (this.stack.size() != 0 && ((Header)this.stack.peek()).getLevel() >= node.getLevel());
            this.stack.push((Object)node);
        }
        this.sink.section(node.getLevel(), null);
        this.sink.sectionTitle(node.getLevel(), null);
        node.childrenAccept((Visitor)this);
        this.sink.sectionTitle_(node.getLevel());
    }

    public void visit(Image node) {
        Resource resource = node.getResource();
        SinkEventAttributeSet attr = new SinkEventAttributeSet();
        attr.addAttribute((Object)"alt", (Object)node.getText());
        if (resource.getHint() != null) {
            attr.addAttribute((Object)"title", (Object)resource.getHint());
        }
        this.sink.figureGraphics(resource.getLocation(), (SinkEventAttributes)attr);
    }

    public void visit(Link node) {
        Resource resource = node.getResource();
        if (resource != null) {
            this.sink.link(resource.getLocation());
            node.childrenAccept((Visitor)this);
            this.sink.link_();
        } else {
            this.sink.text("[");
            node.childrenAccept((Visitor)this);
            this.sink.text("]");
        }
    }

    public void visit(InlineUrl node) {
        this.sink.link(node.getUrl());
        this.sink.text(node.getUrl());
        this.sink.link_();
    }

    public void visit(Item node) {
        this.sink.listItem();
        node.childrenAccept((Visitor)this);
        this.sink.listItem_();
    }

    public void visit(Line node) {
        node.childrenAccept((Visitor)this);
        this.sink.text("\n");
    }

    public void visit(LineBreak node) {
        this.sink.lineBreak();
    }

    public void visit(ResourceDefinition node) {
    }

    public void visit(org.tautua.markdownpapers.ast.List node) {
        if (node.isOrdered()) {
            this.sink.numberedList(0);
            node.childrenAccept((Visitor)this);
            this.sink.numberedList_();
        } else {
            this.sink.list();
            node.childrenAccept((Visitor)this);
            this.sink.list_();
        }
    }

    private void appendAttributes(List<TagAttribute> attributes) {
        for (TagAttribute a : attributes) {
            this.sink.rawText(" ");
            this.sink.rawText(a.getName());
            this.sink.rawText("=\"");
            this.sink.rawText(a.getValue());
            this.sink.rawText("\"");
        }
    }

    public void visit(Paragraph node) {
        Node parent = node.jjtGetParent();
        if (parent instanceof Item && !((Item)parent).isLoose()) {
            node.childrenAccept((Visitor)this);
            return;
        }
        this.sink.paragraph();
        node.childrenAccept((Visitor)this);
        this.sink.paragraph_();
    }

    public void visit(Quote node) {
    }

    public void visit(Ruler node) {
        this.sink.horizontalRule();
    }

    public void visit(SimpleNode node) {
        throw new UnsupportedOperationException();
    }

    public void visit(Tag node) {
        TagAttributeList attributes = node.getAttributeList();
        TagBody body = node.getBody();
        this.sink.rawText("<");
        this.sink.rawText(node.getName());
        if (attributes != null) {
            attributes.accept((Visitor)this);
        }
        if (body == null) {
            this.sink.rawText("/>");
        } else {
            this.sink.rawText(">");
            body.accept((Visitor)this);
            this.sink.rawText("</");
            this.sink.rawText(node.getName());
            this.sink.rawText(">");
        }
    }

    public void visit(TagAttribute node) {
        this.sink.rawText(" ");
        this.sink.rawText(node.getName());
        this.sink.rawText("=\"");
        this.sink.rawText(node.getValue());
        this.sink.rawText("\"");
    }

    public void visit(TagAttributeList node) {
        node.childrenAccept((Visitor)this);
    }

    public void visit(TagBody node) {
        node.childrenAccept((Visitor)this);
    }

    public void visit(Text node) {
        this.sink.text(node.getValue());
    }

    public void visit(StartTag node) {
    }
}

