/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.testng.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.tap4j.model.TestResult;
import org.testng.ITestResult;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class TapTestNGYamlUtil {
    private static final int EXTRA_SPACE = 3;
    public static final String LINE_SEPARATOR = DumperOptions.LineBreak.UNIX.getString();

    private TapTestNGYamlUtil() {
    }

    public static String getMessage(ITestResult testNgTestResult) {
        return "TestNG Test " + testNgTestResult.getName();
    }

    public static String getSeverity(ITestResult testNgTestResult) {
        String severity = "~";
        if (testNgTestResult.getThrowable() != null) {
            severity = "High";
        }
        return severity;
    }

    public static String getSource(ITestResult testNgTestResult) {
        String source = testNgTestResult.getTestClass().getName() + ":" + testNgTestResult.getMethod().getMethodName();
        return source;
    }

    public static String getDatetime(ITestResult testNgTestResult) {
        long ms = testNgTestResult.getStartMillis();
        Date date = new Date(ms);
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
    }

    public static String getFile(ITestResult testNgTestResult) {
        return testNgTestResult.getTestClass().getName();
    }

    public static String getLine(ITestResult testNgTestResult) {
        String line = "~";
        Throwable testNGException = testNgTestResult.getThrowable();
        if (testNGException != null) {
            StackTraceElement el;
            StringBuilder lookFor = new StringBuilder();
            lookFor.append(testNgTestResult.getTestClass().getName());
            lookFor.append('.');
            lookFor.append(testNgTestResult.getMethod().getMethodName());
            lookFor.append('(');
            lookFor.append(testNgTestResult.getTestClass().getClass().getSimpleName());
            lookFor.append(".java:");
            StackTraceElement[] els = testNGException.getStackTrace();
            for (int i = 0; i < els.length && (line = TapTestNGYamlUtil.getLineNumberFromExceptionTraceLine((el = els[i]).toString(), lookFor.toString())).equals("") != Boolean.FALSE.booleanValue(); ++i) {
            }
        }
        return line;
    }

    public static String getLineNumberFromExceptionTraceLine(String exceptionTraceLine, String substrToSearch) {
        String lineNumber = "";
        int index = exceptionTraceLine.indexOf(substrToSearch);
        if (index >= 0) {
            int length = substrToSearch.length() + index;
            if (exceptionTraceLine.lastIndexOf(41) > length) {
                lineNumber = exceptionTraceLine.substring(length, exceptionTraceLine.lastIndexOf(41));
            }
        }
        return lineNumber;
    }

    public static String getName(ITestResult testNgTestResult) {
        return testNgTestResult.getName();
    }

    public static Object getExtensions(ITestResult testNgTestResult) {
        Serializable extensions = null;
        Set attributeNames = testNgTestResult.getAttributeNames();
        Iterator iterator = attributeNames.iterator();
        if (iterator.hasNext()) {
            extensions = new LinkedHashMap();
            while (iterator.hasNext()) {
                String attributeName = (String)iterator.next();
                Object attributeValue = testNgTestResult.getAttribute(attributeName);
                ((Map)((Object)extensions)).put(attributeName, attributeValue);
            }
        } else {
            extensions = Character.valueOf('~');
        }
        return extensions;
    }

    public static String getExpected(ITestResult testNgTestResult) {
        Throwable throwable = testNgTestResult.getThrowable();
        String expected = null;
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stringException = sw.toString();
            String expectedToken = "expected:";
            String butWasToken = " but was:";
            int index = stringException.indexOf(expectedToken);
            if (index > 0) {
                expected = stringException.substring(index + expectedToken.length(), stringException.lastIndexOf(butWasToken));
            }
        }
        return expected;
    }

    public static String getActual(ITestResult testNgTestResult) {
        Throwable throwable = testNgTestResult.getThrowable();
        String actual = "~";
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stringException = sw.toString();
            String expectedToken = "expected:";
            String butWasToken = " but was:";
            int index = stringException.indexOf(expectedToken);
            if (index > 0) {
                index = stringException.indexOf(butWasToken);
                int eolIndex = stringException.indexOf(System.getProperty("line.separator"), index);
                actual = stringException.substring(index + butWasToken.length(), eolIndex);
            }
        }
        return actual;
    }

    public static String getDisplay(ITestResult testNgTestResult) {
        StringBuilder displayBuffer = new StringBuilder();
        String expected = TapTestNGYamlUtil.getExpected(testNgTestResult);
        String actual = TapTestNGYamlUtil.getActual(testNgTestResult);
        if (expected != null && expected.trim().length() > 0 && actual != null && actual.trim().length() > 0) {
            int expectedLength = expected.length();
            int actualLength = actual.length();
            int greater = expectedLength;
            if (actualLength > expectedLength) {
                greater = actualLength;
            } else if ("Expected".length() > greater) {
                greater = "Expected".length();
            }
            int greaterPlus3 = greater + 3;
            displayBuffer.append("+" + TapTestNGYamlUtil.fill(greaterPlus3, '-') + "+" + TapTestNGYamlUtil.fill(greaterPlus3, '-') + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TapTestNGYamlUtil.fill(greater, "Got") + "|" + TapTestNGYamlUtil.fill(greater, "Expected") + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TapTestNGYamlUtil.fill(greaterPlus3, '-') + "+" + TapTestNGYamlUtil.fill(greaterPlus3, '-') + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TapTestNGYamlUtil.fill(greater, actual) + "|" + TapTestNGYamlUtil.fill(greater, expected) + "+");
            displayBuffer.append(LINE_SEPARATOR);
            displayBuffer.append("+" + TapTestNGYamlUtil.fill(greaterPlus3, '-') + "+" + TapTestNGYamlUtil.fill(greaterPlus3, '-') + "+");
        } else {
            displayBuffer.append('~');
        }
        return displayBuffer.toString();
    }

    private static String fill(int greater, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < greater; ++i) {
            sb.append(Character.toString(c));
        }
        return sb.toString();
    }

    private static String fill(int greater, String s) {
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        sb.append(s);
        int newgreater = greater - s.length();
        sb.append(TapTestNGYamlUtil.fill(newgreater + 1, ' '));
        sb.append(' ');
        return sb.toString();
    }

    public static Object getDump(ITestResult testNgTestResult) {
        Object returnObject = null;
        Object[] parameters = testNgTestResult.getParameters();
        if (parameters.length > 0) {
            returnObject = new LinkedHashMap();
            for (int i = 0; i < parameters.length; ++i) {
                Object parameter = parameters[i];
                ((Map)returnObject).put("param" + (i + 1), parameter);
            }
        } else {
            returnObject = "~";
        }
        return returnObject.toString();
    }

    public static String getError(ITestResult testNgTestResult) {
        String error = "~";
        Throwable t = testNgTestResult.getThrowable();
        if (t != null) {
            error = t.getMessage();
        }
        return error;
    }

    public static String getBacktrace(ITestResult testNgTestResult) {
        StringBuilder stackTrace = new StringBuilder();
        Throwable throwable = testNgTestResult.getThrowable();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            String stackTraceString = sw.toString();
            stackTraceString = stackTraceString.trim().replaceAll("\\r\\n", "\n");
            StringTokenizer st = new StringTokenizer(stackTraceString, LINE_SEPARATOR);
            while (st.hasMoreTokens()) {
                String stackTraceLine = st.nextToken();
                stackTrace.append(stackTraceLine);
                stackTrace.append(LINE_SEPARATOR);
            }
        } else {
            stackTrace.append('~');
        }
        return stackTrace.toString();
    }

    public static StringBuilder toYaml(XmlSuite suite) {
        StringBuilder result = new StringBuilder();
        TapTestNGYamlUtil.maybeAdd(result, "name", suite.getName(), null);
        TapTestNGYamlUtil.maybeAdd(result, "junit", suite.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        TapTestNGYamlUtil.maybeAdd(result, "verbose", suite.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        TapTestNGYamlUtil.maybeAdd(result, "threadCount", suite.getThreadCount(), XmlSuite.DEFAULT_THREAD_COUNT);
        TapTestNGYamlUtil.maybeAdd(result, "dataProviderThreadCount", suite.getDataProviderThreadCount(), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT);
        TapTestNGYamlUtil.maybeAdd(result, "timeOut", suite.getTimeOut(), null);
        TapTestNGYamlUtil.maybeAdd(result, "parallel", suite.getParallel(), XmlSuite.DEFAULT_PARALLEL);
        TapTestNGYamlUtil.maybeAdd(result, "skipFailedInvocationCounts", suite.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        TapTestNGYamlUtil.toYaml(result, "parameters", "", suite.getParameters());
        TapTestNGYamlUtil.toYaml(result, suite.getPackages());
        if (suite.getListeners().size() > 0) {
            result.append("listeners:\n");
            TapTestNGYamlUtil.toYaml(result, "  ", suite.getListeners());
        }
        if (suite.getPackages().size() > 0) {
            result.append("packages:\n");
            TapTestNGYamlUtil.toYaml(result, suite.getPackages());
        }
        TapTestNGYamlUtil.toYaml(result, "listeners", suite.getListeners());
        if (suite.getTests().size() > 0) {
            result.append("tests:\n");
            for (XmlTest t : suite.getTests()) {
                TapTestNGYamlUtil.toYaml(result, "  ", t);
            }
        }
        if (suite.getChildSuites().size() > 0) {
            result.append("suite-files:\n");
            TapTestNGYamlUtil.toYaml(result, "  ", suite.getSuiteFiles());
        }
        return result;
    }

    private static void maybeAdd(StringBuilder sb, String key, Object value, Object def) {
        TapTestNGYamlUtil.maybeAdd(sb, "", key, value, def);
    }

    private static void maybeAdd(StringBuilder sb, String sp, String key, Object value, Object def) {
        if (value != null && !value.equals(def)) {
            sb.append(sp).append(key).append(": ").append(value.toString()).append("\n");
        }
    }

    private static void toYaml(StringBuilder result, String sp, XmlTest t) {
        Map mg;
        String sp2 = sp + "  ";
        result.append(sp).append("- name: ").append(t.getName()).append("\n");
        TapTestNGYamlUtil.maybeAdd(result, sp2, "junit", t.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        TapTestNGYamlUtil.maybeAdd(result, sp2, "verbose", t.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        TapTestNGYamlUtil.maybeAdd(result, sp2, "timeOut", t.getTimeOut(), null);
        TapTestNGYamlUtil.maybeAdd(result, sp2, "parallel", t.getParallel(), XmlSuite.DEFAULT_PARALLEL);
        TapTestNGYamlUtil.maybeAdd(result, sp2, "skipFailedInvocationCounts", t.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        TapTestNGYamlUtil.maybeAdd(result, "preserveOrder", sp2, t.getPreserveOrder(), "false");
        TapTestNGYamlUtil.toYaml(result, "parameters", sp2, t.getAllParameters());
        if (t.getIncludedGroups().size() > 0) {
            result.append(sp2).append("includedGroups: [ ").append(TapTestNGYamlUtil.join(t.getIncludedGroups())).append(" ]\n");
        }
        if (t.getExcludedGroups().size() > 0) {
            result.append(sp2).append("excludedGroups: [ ").append(TapTestNGYamlUtil.join(t.getExcludedGroups())).append(" ]\n");
        }
        if ((mg = t.getMetaGroups()).size() > 0) {
            result.append(sp2).append("metaGroups: { ");
            boolean first = true;
            for (Map.Entry entry : mg.entrySet()) {
                String group = (String)entry.getKey();
                if (!first) {
                    result.append(", ");
                }
                result.append(group).append(": [ ").append(TapTestNGYamlUtil.join((List)entry.getValue())).append(" ] ");
                first = false;
            }
            result.append(" }\n");
        }
        if (t.getXmlPackages().size() > 0) {
            result.append(sp2).append("xmlPackages:\n");
            for (XmlPackage xp : t.getXmlPackages()) {
                TapTestNGYamlUtil.toYaml(result, sp2 + "  - ", xp);
            }
        }
        if (t.getXmlClasses().size() > 0) {
            result.append(sp2).append("classes:\n");
            for (XmlClass xc : t.getXmlClasses()) {
                TapTestNGYamlUtil.toYaml(result, sp2 + "  ", xc);
            }
        }
        result.append("\n");
    }

    private static String join(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            sb.append(strings.get(i));
            if (i + 1 >= strings.size()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static void toYaml(StringBuilder result, String sp2, XmlClass xc) {
        List im = xc.getIncludedMethods();
        List em = xc.getExcludedMethods();
        String name = im.size() > 0 || em.size() > 0 ? "name: " : "";
        result.append(sp2).append("- " + name).append(xc.getName()).append("\n");
        if (im.size() > 0) {
            result.append(sp2 + "  includedMethods:\n");
            for (XmlInclude xi : im) {
                TapTestNGYamlUtil.toYaml(result, sp2 + "    ", xi);
            }
        }
        if (em.size() > 0) {
            result.append(sp2 + "  excludedMethods:\n");
            TapTestNGYamlUtil.toYaml(result, sp2 + "    ", em);
        }
    }

    private static void toYaml(StringBuilder result, String sp2, XmlInclude xi) {
        result.append(sp2 + "- " + xi.getName()).append("\n");
    }

    private static void toYaml(StringBuilder result, String sp, List<String> strings) {
        for (String l : strings) {
            result.append(sp).append("- ").append(l).append("\n");
        }
    }

    private static void toYaml(StringBuilder sb, List<XmlPackage> packages) {
        if (packages.size() > 0) {
            sb.append("packages:\n");
            for (XmlPackage p : packages) {
                TapTestNGYamlUtil.toYaml(sb, "  ", p);
            }
        }
        for (XmlPackage p : packages) {
            TapTestNGYamlUtil.toYaml(sb, "  ", p);
        }
    }

    private static void toYaml(StringBuilder sb, String sp, XmlPackage p) {
        sb.append(sp).append("name: ").append(p.getName()).append("\n");
        TapTestNGYamlUtil.generateIncludeExclude(sb, sp, "includes", p.getInclude());
        TapTestNGYamlUtil.generateIncludeExclude(sb, sp, "excludes", p.getExclude());
    }

    private static void generateIncludeExclude(StringBuilder sb, String sp, String key, List<String> includes) {
        if (includes.size() > 0) {
            sb.append(sp).append("  ").append(key).append("\n");
            for (String inc : includes) {
                sb.append(sp).append("    ").append(inc);
            }
        }
    }

    private static void mapToYaml(Map<String, String> map, StringBuilder out) {
        if (map.size() > 0) {
            out.append("{ ");
            boolean first = true;
            for (Map.Entry<String, String> e : map.entrySet()) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(e.getKey() + ": " + e.getValue());
            }
            out.append(" }\n");
        }
    }

    private static void toYaml(StringBuilder sb, String key, String sp, Map<String, String> parameters) {
        if (parameters.size() > 0) {
            sb.append(sp).append(key).append(": ");
            TapTestNGYamlUtil.mapToYaml(parameters, sb);
        }
    }

    private static void addToMap(Map suite, String name, Map target) {
        List parameters = (List)suite.get(name);
        if (parameters != null) {
            for (Map parameter : parameters) {
                for (Map.Entry p : parameter.entrySet()) {
                    target.put(p.getKey(), p.getValue().toString());
                }
            }
        }
    }

    private static void addToList(Map suite, String name, List target) {
        List parameters = (List)suite.get(name);
        if (parameters != null) {
            for (Map parameter : parameters) {
                for (Map.Entry p : parameter.entrySet()) {
                    target.add(p.getValue().toString());
                }
            }
        }
    }

    public static XmlSuite parse(String filePath, InputStream is) throws FileNotFoundException {
        if (is == null) {
            is = new FileInputStream(new File(filePath));
        }
        XmlSuite result = (XmlSuite)new Yaml().loadAs(is, XmlSuite.class);
        result.setFileName(filePath);
        for (XmlTest t : result.getTests()) {
            t.setSuite(result);
        }
        return result;
    }

    public static void createTestNGYAMLishData(TestResult testResult, ITestResult testNgTestResult) {
        Map yamlish = testResult.getDiagnostic();
        TapTestNGYamlUtil.createYAMLishMessage(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishSeverity(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishSource(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishDatetime(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishFile(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishLine(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishName(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishExtensions(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishActualAndExpected(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishDisplay(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishDump(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishError(yamlish, testNgTestResult);
        TapTestNGYamlUtil.createYAMLishBacktrace(yamlish, testNgTestResult);
    }

    public static void createYAMLishMessage(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String message = TapTestNGYamlUtil.getMessage(testNgTestResult);
        yamlish.put("message", message);
    }

    public static void createYAMLishSeverity(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String severity = TapTestNGYamlUtil.getSeverity(testNgTestResult);
        yamlish.put("severity", severity);
    }

    public static void createYAMLishSource(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String source = TapTestNGYamlUtil.getSource(testNgTestResult);
        yamlish.put("source", source);
    }

    public static void createYAMLishDatetime(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String datetime = TapTestNGYamlUtil.getDatetime(testNgTestResult);
        yamlish.put("datetime", datetime);
    }

    public static void createYAMLishFile(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String file = TapTestNGYamlUtil.getFile(testNgTestResult);
        yamlish.put("file", file);
    }

    public static void createYAMLishLine(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String line = TapTestNGYamlUtil.getLine(testNgTestResult);
        yamlish.put("line", line);
    }

    public static void createYAMLishName(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String name = TapTestNGYamlUtil.getName(testNgTestResult);
        yamlish.put("name", name);
    }

    public static void createYAMLishExtensions(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        Object extensions = TapTestNGYamlUtil.getExtensions(testNgTestResult);
        yamlish.put("extensions", extensions);
    }

    public static void createYAMLishActualAndExpected(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String expected = TapTestNGYamlUtil.getExpected(testNgTestResult);
        String actual = TapTestNGYamlUtil.getActual(testNgTestResult);
        if (expected == null) {
            expected = "~";
        }
        yamlish.put("got", actual);
        yamlish.put("expected", expected);
    }

    public static void createYAMLishDisplay(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String display = TapTestNGYamlUtil.getDisplay(testNgTestResult);
        yamlish.put("display", display);
    }

    public static void createYAMLishDump(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        Object dump = TapTestNGYamlUtil.getDump(testNgTestResult);
        yamlish.put("dump", dump);
    }

    public static void createYAMLishError(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String error = TapTestNGYamlUtil.getError(testNgTestResult);
        yamlish.put("error", error);
    }

    public static void createYAMLishBacktrace(Map<String, Object> yamlish, ITestResult testNgTestResult) {
        String backtrace = TapTestNGYamlUtil.getBacktrace(testNgTestResult);
        yamlish.put("backtrace", backtrace);
    }
}

