/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.junit.listener;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.tap4j.ext.junit.model.JUnitTestData;
import org.tap4j.ext.junit.util.TapJUnitUtil;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.producer.Producer;
import org.tap4j.producer.TapProducer;
import org.tap4j.representer.DumperOptions;
import org.tap4j.representer.Representer;
import org.tap4j.representer.Tap13Representer;

abstract class TapListener
extends RunListener {
    private List<JUnitTestData> testMethodsList = new LinkedList<JUnitTestData>();
    private Producer tapProducer = new TapProducer();

    public TapListener() {
        if (this.isYaml()) {
            DumperOptions options = new DumperOptions();
            options.setPrintDiagnostics(true);
            Tap13Representer representer = new Tap13Representer(options);
            this.tapProducer = new TapProducer((Representer)representer);
        } else {
            this.tapProducer = new TapProducer();
        }
    }

    public abstract boolean isYaml();

    public void testRunStarted(Description description) throws Exception {
        if (this.isYaml()) {
            DumperOptions options = new DumperOptions();
            options.setPrintDiagnostics(true);
            Tap13Representer representer = new Tap13Representer(options);
            this.tapProducer = new TapProducer((Representer)representer);
        } else {
            this.tapProducer = new TapProducer();
        }
        this.testMethodsList = new LinkedList<JUnitTestData>();
    }

    public abstract void testRunFinished(Result var1) throws Exception;

    public void testStarted(Description description) throws Exception {
        this.setTestInfo(description);
    }

    protected void setTestInfo(Description description) {
        JUnitTestData testMethod = new JUnitTestData(false, false);
        testMethod.setDescription(description);
        if (!this.testMethodsList.contains(testMethod)) {
            this.testMethodsList.add(testMethod);
        }
    }

    public void testIgnored(Description description) throws Exception {
        JUnitTestData testMethod = new JUnitTestData(false, false);
        testMethod.setDescription(description);
        if (!this.testMethodsList.contains(testMethod)) {
            this.testMethodsList.add(testMethod);
        } else {
            testMethod = this.testMethodsList.get(this.testMethodsList.indexOf(testMethod));
        }
        testMethod.setIgnored(true);
    }

    public void testFailure(Failure failure) throws Exception {
        JUnitTestData testMethod = new JUnitTestData(false, true);
        testMethod.setDescription(failure.getDescription());
        if (!this.testMethodsList.contains(testMethod)) {
            this.testMethodsList.add(testMethod);
        } else {
            testMethod = this.testMethodsList.get(this.testMethodsList.indexOf(testMethod));
        }
        testMethod.setFailed(true);
        testMethod.setFailException(failure.getException());
        testMethod.setDescription(failure.getDescription());
    }

    public void testFinished(Description description) throws Exception {
    }

    protected void generateTapPerMethod(Result result) {
        for (JUnitTestData testMethod : this.testMethodsList) {
            TestResult tapTestResult = TapJUnitUtil.generateTAPTestResult(testMethod, 1, this.isYaml());
            TestSet testSet = new TestSet();
            testSet.setPlan(new Plan(Integer.valueOf(1)));
            testSet.addTestResult(tapTestResult);
            String className = TapJUnitUtil.extractClassName(testMethod.getDescription());
            String methodName = TapJUnitUtil.extractMethodName(testMethod.getDescription());
            File output = new File(System.getProperty("tap.junit.results", "target/"), className + ":" + methodName + ".tap");
            this.tapProducer.dump(testSet, output);
        }
    }

    protected void generateTapPerClass(Result result) {
        HashMap<String, List> testsByClass = new HashMap<String, List>();
        for (JUnitTestData testMethod : this.testMethodsList) {
            String className2 = TapJUnitUtil.extractClassName(testMethod.getDescription());
            testsByClass.computeIfAbsent(className2, k -> new ArrayList()).add(testMethod);
        }
        testsByClass.forEach((className, testMethods) -> {
            TestSet testSet = new TestSet();
            testSet.setPlan(new Plan(Integer.valueOf(testMethods.size())));
            testMethods.forEach(testMethod -> {
                TestResult tapTestResult = TapJUnitUtil.generateTAPTestResult(testMethod, 1, this.isYaml());
                testSet.addTestResult(tapTestResult);
            });
            File output = new File(System.getProperty("tap.junit.results", "target/"), className + ".tap");
            this.tapProducer.dump(testSet, output);
        });
    }

    protected void generateTapPerSuite(Result result) {
        TestSet testSet = new TestSet();
        testSet.setPlan(new Plan(Integer.valueOf(this.testMethodsList.size())));
        String className = "";
        for (JUnitTestData testMethod : this.testMethodsList) {
            className = TapJUnitUtil.extractClassName(testMethod.getDescription());
            TestResult tapTestResult = TapJUnitUtil.generateTAPTestResult(testMethod, 1, this.isYaml());
            testSet.addTestResult(tapTestResult);
        }
        File output = new File(System.getProperty("tap.junit.results", "target/"), className + "-SUITE.tap");
        this.tapProducer.dump(testSet, output);
    }

    protected void setFailedTestsStatus(Result result) {
        if (result.getFailureCount() > 0) {
            for (Failure f : result.getFailures()) {
                for (JUnitTestData testMethod : this.testMethodsList) {
                    if (!testMethod.getDescription().getDisplayName().equals(f.getTestHeader())) continue;
                    testMethod.setFailed(true);
                    testMethod.setFailMessage(f.getMessage());
                    testMethod.setFailException(f.getException());
                    testMethod.setFailTrace(f.getTrace());
                }
            }
        }
    }

    public static enum Type {
        METHOD,
        CLASS,
        SUITE,
        ALL;

    }
}

