/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.ext.jmeter.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.tap4j.ext.jmeter.model.AbstractSample;
import org.tap4j.ext.jmeter.model.AssertionResult;
import org.tap4j.ext.jmeter.model.HttpSample;
import org.tap4j.model.Header;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.parser.ParserException;
import org.tap4j.producer.TapProducer;
import org.tap4j.producer.TapProducerFactory;
import org.tap4j.representer.DumperOptions;
import org.tap4j.util.StatusValues;

public class JmeterResultParser {
    private static final Integer TAP_VERSION = 13;
    private static final Integer INITIAL_TEST_STEP = 1;
    private static final CharSequence XML_EXT = ".xml";
    private static final CharSequence TAP_EXT = ".tap";
    private static final String FAILURE_MESSAGE = "- FailureMessage:";
    private static final String FAIL_ASSERT = "failAssert ";
    private static final String ERROR = "error ";
    private static final String DUMP = "dump";
    private static final String SEVERITY = "severity";
    private static final String MESSAGE = "message";
    public static final String VALUE_SPLIT = " - ";
    private Charset charset;

    public JmeterResultParser() {
        this.charset = Charset.defaultCharset();
    }

    public JmeterResultParser(Charset pCharset) {
        this.charset = pCharset;
    }

    public TestSet parseFile(File file, boolean generateTapFile) {
        TestSet testSet = new TestSet();
        Header header = new Header(TAP_VERSION);
        testSet.setHeader(header);
        List<AbstractSample> sampleResultList = this.getResultList(file);
        Plan plan = new Plan(INITIAL_TEST_STEP, Integer.valueOf(sampleResultList.size()));
        testSet.setPlan(plan);
        for (AbstractSample httpSample : sampleResultList) {
            List<AssertionResult> assetionResultList = httpSample.getAssertionResult();
            boolean resultError = false;
            String failitureMessage = "";
            String severity = "";
            for (AssertionResult assertionResult : assetionResultList) {
                resultError = assertionResult.isFailure() != false || assertionResult.isError() != false;
                if (!resultError) continue;
                failitureMessage = failitureMessage + FAILURE_MESSAGE + assertionResult.getFailureMessage();
                if (assertionResult.isFailure().booleanValue()) {
                    severity = FAIL_ASSERT;
                }
                if (!assertionResult.isError().booleanValue()) continue;
                severity = severity + ERROR;
            }
            TestResult testResult = new TestResult();
            testResult.setDescription(httpSample.getLb());
            StatusValues status = StatusValues.OK;
            if (resultError) {
                Map yamlish = testResult.getDiagnostic();
                this.createYAMLishMessage(yamlish, httpSample, failitureMessage);
                this.createYAMLishSeverity(yamlish, severity);
                this.createYAMLishDump(yamlish, httpSample);
                status = StatusValues.NOT_OK;
            }
            testResult.setStatus(status);
            testSet.addTestResult(testResult);
        }
        if (generateTapFile) {
            this.generateTapFile(file, testSet);
        }
        return testSet;
    }

    /*
     * Exception decompiling
     */
    private List<AbstractSample> getResultList(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateTapFile(File file, TestSet testSet) {
        String fileName = file.getAbsolutePath();
        String tapFileName = fileName.replace(XML_EXT, TAP_EXT);
        DumperOptions options = new DumperOptions();
        options.setPrintDiagnostics(true);
        options.setCharset(this.charset.name());
        TapProducer tapProducer = TapProducerFactory.makeTap13YamlProducer();
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tapFileName), this.charset));
            tapProducer.dump(testSet, (Writer)out);
            ((Writer)out).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParserException(String.format("TAP file not found: %s", tapFileName), (Throwable)fileNotFoundException);
        }
        catch (IOException e) {
            throw new ParserException(String.format("Error IOException: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void createYAMLishMessage(Map<String, Object> yamlish, AbstractSample httpSample, String failitureMessage) {
        yamlish.put(MESSAGE, httpSample.getRc() + VALUE_SPLIT + httpSample.getRm() + failitureMessage);
    }

    private void createYAMLishSeverity(Map<String, Object> yamlish, String severity) {
        yamlish.put(SEVERITY, severity);
    }

    private void createYAMLishDump(Map<String, Object> yamlish, AbstractSample httpSample) {
        String dump = "";
        if (httpSample instanceof HttpSample) {
            dump = ((HttpSample)httpSample).getResponseData().getValue();
        }
        yamlish.put(DUMP, dump);
    }
}

