/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin;

import hudson.FilePath;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.tasks.test.TestObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.tap4j.consumer.TapConsumer;
import org.tap4j.consumer.TapConsumerFactory;
import org.tap4j.model.BailOut;
import org.tap4j.model.Comment;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.plugin.model.ParseErrorTestSetMap;
import org.tap4j.plugin.model.TapAttachment;
import org.tap4j.plugin.model.TestSetMap;
import org.tap4j.plugin.util.DiagnosticUtil;
import org.tap4j.plugin.util.Util;

public class TapResult
implements ModelObject,
Serializable {
    private static final long serialVersionUID = 4343399327336076951L;
    private static final Logger LOGGER = Logger.getLogger(TapResult.class.getName());
    private static final String DURATION_KEY = "duration_ms";
    private Run build;
    private List<TestSetMap> testSets;
    private List<TestSetMap> parseErrorTestSets;
    private int failed = 0;
    private int passed = 0;
    private int skipped = 0;
    private int todo = 0;
    private int bailOuts = 0;
    private int total = 0;
    private float duration = 0.0f;
    private String name;
    private Boolean todoIsFailure;
    private Boolean includeCommentDiagnostics;
    private Boolean validateNumberOfTests;
    private Boolean showOnlyFailures = Boolean.FALSE;

    public TapResult(String name, Run owner, List<TestSetMap> testSets, Boolean todoIsFailure, Boolean includeCommentDiagnostics, Boolean validateNumberOfTests) {
        this.name = name;
        this.build = owner;
        this.testSets = this.filterTestSet(testSets);
        this.parseErrorTestSets = this.filterParseErrorTestSets(testSets);
        this.todoIsFailure = todoIsFailure;
        this.includeCommentDiagnostics = includeCommentDiagnostics;
        this.validateNumberOfTests = validateNumberOfTests;
    }

    public TapResult copyWithExtraTestSets(List<TestSetMap> testSets) {
        ArrayList<TestSetMap> mergedTestSets = new ArrayList<TestSetMap>(this.getTestSets());
        mergedTestSets.addAll(testSets);
        return new TapResult(this.getName(), this.getOwner(), mergedTestSets, this.getTodoIsFailure(), this.getIncludeCommentDiagnostics(), this.getValidateNumberOfTests());
    }

    public Boolean getShowOnlyFailures() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.showOnlyFailures, (boolean)Boolean.FALSE);
    }

    public void setShowOnlyFailures(Boolean showOnlyFailures) {
        this.showOnlyFailures = showOnlyFailures;
    }

    public Boolean getTodoIsFailure() {
        return this.todoIsFailure;
    }

    public Boolean getIncludeCommentDiagnostics() {
        return this.includeCommentDiagnostics == null ? true : this.includeCommentDiagnostics;
    }

    public Boolean getValidateNumberOfTests() {
        return this.validateNumberOfTests == null ? false : this.validateNumberOfTests;
    }

    private List<TestSetMap> filterParseErrorTestSets(List<TestSetMap> testSets) {
        ArrayList<TestSetMap> filtered = new ArrayList<TestSetMap>();
        for (TestSetMap testSet : testSets) {
            if (!(testSet instanceof ParseErrorTestSetMap)) continue;
            String rootDir = this.build.getRootDir().getAbsolutePath();
            try {
                rootDir = new File(this.build.getRootDir().getCanonicalPath().toString(), "tap-master-files").getAbsolutePath();
            }
            catch (IOException e) {
                LOGGER.warning(e.getMessage());
            }
            filtered.add(new TestSetMap(Util.normalizeFolders(rootDir, testSet.getFileName()), testSet.getTestSet()));
        }
        return filtered;
    }

    private List<TestSetMap> filterTestSet(List<TestSetMap> testSets) {
        ArrayList<TestSetMap> filtered = new ArrayList<TestSetMap>();
        for (TestSetMap testSet : testSets) {
            if (testSet instanceof ParseErrorTestSetMap) continue;
            String rootDir = this.build.getRootDir().getAbsolutePath();
            try {
                rootDir = new File(this.build.getRootDir().getCanonicalPath().toString(), "tap-master-files").getAbsolutePath();
            }
            catch (IOException e) {
                LOGGER.warning(e.getMessage());
            }
            filtered.add(new TestSetMap(Util.normalizeFolders(rootDir, testSet.getFileName()), testSet.getTestSet()));
        }
        return filtered;
    }

    public void tally() {
        this.failed = 0;
        this.passed = 0;
        this.skipped = 0;
        this.todo = 0;
        this.bailOuts = 0;
        this.total = 0;
        this.duration = 0.0f;
        for (TestSetMap testSet : this.testSets) {
            TestSet realTestSet = testSet.getTestSet();
            List testResults = realTestSet.getTestResults();
            this.total += testResults.size();
            Plan plan = realTestSet.getPlan();
            if (plan != null && plan.isSkip().booleanValue()) {
                this.skipped += testResults.size();
            } else {
                for (TestResult testResult : testResults) {
                    Object duration;
                    Map diagnostic;
                    if (Util.isSkipped(testResult)) {
                        ++this.skipped;
                    } else if (Util.isFailure(testResult, this.todoIsFailure)) {
                        ++this.failed;
                    } else if (Util.isTodo(testResult)) {
                        ++this.todo;
                    } else {
                        ++this.passed;
                    }
                    if ((diagnostic = testResult.getDiagnostic()) == null || diagnostic.isEmpty() || (duration = diagnostic.get(DURATION_KEY)) == null) continue;
                    Float durationMS = Float.valueOf(Float.parseFloat(duration.toString()));
                    this.duration += durationMS.floatValue();
                }
            }
            this.bailOuts += realTestSet.getNumberOfBailOuts();
        }
    }

    public Run getOwner() {
        return this.build;
    }

    public void setOwner(Run owner) {
        this.build = owner;
    }

    public List<TestSetMap> getTestSets() {
        return this.testSets;
    }

    public boolean isEmptyTestSet() {
        return this.testSets.size() <= 0;
    }

    public List<TestSetMap> getParseErrorTestSets() {
        return this.parseErrorTestSets;
    }

    public boolean hasParseErrors() {
        return this.parseErrorTestSets.size() > 0;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getToDo() {
        return this.todo;
    }

    public int getPassed() {
        return this.passed;
    }

    public int getBailOuts() {
        return this.bailOuts;
    }

    public int getTotal() {
        return this.total;
    }

    public float getDuration() {
        return this.duration;
    }

    public String createDiagnosticTable(String tapFile, Map<String, Object> diagnostic) {
        return DiagnosticUtil.createDiagnosticTable(tapFile, diagnostic);
    }

    public boolean isTestResult(Object tapResult) {
        return tapResult != null && tapResult instanceof TestResult;
    }

    public boolean isBailOut(Object tapResult) {
        return tapResult != null && tapResult instanceof BailOut;
    }

    public boolean isComment(Object tapResult) {
        return tapResult != null && tapResult instanceof Comment;
    }

    public String escapeHTML(String html) {
        return StringUtils.replaceEach((String)html, (String[])new String[]{"&", "\"", "<", ">"}, (String[])new String[]{"&amp;", "&quot;", "&lt;", "&gt;"});
    }

    @Exported(visibility=999)
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDownloadAttachment(StaplerRequest request, StaplerResponse response) {
        block8: {
            String f = request.getParameter("f");
            String key = request.getParameter("key");
            try {
                FilePath parent = new FilePath(new File(this.build.getRootDir(), "tap-master-files"));
                FilePath tapDir = parent.child(TestObject.safe((String)f));
                ServletOutputStream sos = response.getOutputStream();
                if (tapDir.exists()) {
                    String tapStream = tapDir.readToString();
                    TapConsumer consumer = TapConsumerFactory.makeTap13YamlConsumer();
                    TestSet ts = consumer.load(tapStream);
                    TapAttachment attachment = this.getAttachment(ts, key);
                    if (attachment != null) {
                        response.setContentType("application/force-download");
                        response.setContentLength(attachment.getSize());
                        response.setHeader("Content-Transfer-Encoding", "binary");
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + attachment.getFileName() + "\"");
                        sos.write(attachment.getContent());
                        sos.print('\n');
                    } else {
                        sos.println("Couldn't locate attachment in YAMLish: " + f);
                    }
                    break block8;
                }
                sos.println("Couldn't read FilePath.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private TapAttachment getAttachment(TestSet ts, String key) {
        for (TestResult tr : ts.getTestResults()) {
            TapAttachment attachement;
            Map diagnostics = tr.getDiagnostic();
            if (diagnostics == null || diagnostics.size() <= 0 || (attachement = this.recursivelySearch(diagnostics, null, key)) == null) continue;
            return attachement;
        }
        return null;
    }

    private TapAttachment recursivelySearch(Map<String, Object> diagnostics, String parentKey, String key) {
        for (String diagnosticKey : diagnostics.keySet()) {
            Object o;
            Object value = diagnostics.get(diagnosticKey);
            if (value == null) continue;
            if (value instanceof Map) {
                TapAttachment attachment = this.recursivelySearch((Map)value, diagnosticKey, key);
                if (attachment == null) continue;
                return attachment;
            }
            if (parentKey != null && parentKey.equals(key)) {
                o = diagnostics.get("File-Content");
                if (o == null) {
                    o = diagnostics.get("File-content");
                }
                if (o == null || !(o instanceof String)) continue;
                return new TapAttachment(Base64.decodeBase64((String)((String)o)), diagnostics);
            }
            if (!diagnosticKey.equalsIgnoreCase("file-name") || !value.equals(key)) continue;
            o = diagnostics.get("File-Content");
            if (o == null) {
                o = diagnostics.get("File-content");
            }
            if (o == null || !(o instanceof String)) continue;
            return new TapAttachment(Base64.decodeBase64((String)((String)o)), diagnostics);
        }
        return null;
    }
}

