/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.plugin;

import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.RunList;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tap4j.plugin.AbstractTapProjectAction;
import org.tap4j.plugin.TapBuildAction;
import org.tap4j.plugin.TapResult;
import org.tap4j.plugin.util.GraphHelper;

public class TapProjectAction
extends AbstractTapProjectAction {
    private transient Map<String, Integer> requestMap = new HashMap<String, Integer>();

    public TapProjectAction(AbstractProject<?, ?> project) {
        super(project);
    }

    public TapProjectAction(Job<?, ?> job) {
        super(job);
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    protected Class<TapBuildAction> getBuildActionClass() {
        return TapBuildAction.class;
    }

    public TapBuildAction getLastBuildAction() {
        TapBuildAction action = null;
        Run<?, ?> lastBuild = this.getLastBuildWithTap();
        if (lastBuild != null) {
            action = (TapBuildAction)lastBuild.getAction(TapBuildAction.class);
        }
        return action;
    }

    private Run<?, ?> getLastBuildWithTap() {
        Run lastBuild;
        for (lastBuild = this.job.getLastBuild(); lastBuild != null && lastBuild.getAction(TapBuildAction.class) == null; lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> lastBuild = this.getLastBuildWithTap();
        if (lastBuild == null) {
            response.sendRedirect2("nodata");
        } else {
            int buildNumber = lastBuild.getNumber();
            response.sendRedirect2(String.format("../%d/%s", buildNumber, "tapResults"));
        }
    }

    public void doGraph(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doPng(req, rsp);
    }

    public void doGraphMap(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doMap(req, rsp);
    }

    public boolean isGraphActive() {
        Run build = this.job.getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (this.job instanceof MatrixProject) {
                MatrixProject mp = (MatrixProject)this.job;
                for (Job j : mp.getAllJobs()) {
                    Run sub;
                    if (j == mp || (sub = j.getBuild(build.getId())) == null || sub.getAction(this.getBuildActionClass()) == null) continue;
                    ++numPoints;
                    break;
                }
            } else if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = build.getPreviousBuild();
        }
        return true;
    }

    private boolean newGraphNotNeeded(StaplerRequest req, StaplerResponse rsp) {
        Calendar t = this.job.getLastCompletedBuild().getTimestamp();
        Integer prevNumBuilds = this.requestMap.get(req.getRequestURI());
        int numBuilds = 0;
        RunList builds = this.job.getBuilds();
        Iterator it = builds.iterator();
        while (it.hasNext()) {
            it.next();
            ++numBuilds;
        }
        if ((prevNumBuilds = Integer.valueOf(prevNumBuilds == null ? 0 : prevNumBuilds)) != numBuilds) {
            this.requestMap.put(req.getRequestURI(), numBuilds);
        }
        if (this.requestMap.keySet().size() > 10) {
            this.requestMap.clear();
        }
        return prevNumBuilds == numBuilds && req.checkIfModified(t, rsp);
    }

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        Job p = this.job;
        for (Run build = this.job.getLastBuild(); build != null; build = build.getPreviousBuild()) {
            if (build.getAction(TapBuildAction.class) == null) continue;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            Result r = new Result();
            if (p instanceof MatrixProject) {
                MatrixProject mp = (MatrixProject)p;
                for (Job j : mp.getAllJobs()) {
                    Run sub;
                    if (j == mp || (sub = j.getBuild(build.getId())) == null) continue;
                    r.add(this.summarizeBuild(sub));
                }
            } else {
                r = this.summarizeBuild(build);
            }
            dataset.add((Number)r.numPassed, (Comparable)((Object)"Passed"), (Comparable)label);
            dataset.add((Number)r.numFailed, (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)r.numSkipped, (Comparable)((Object)"Skipped"), (Comparable)label);
            dataset.add((Number)r.numToDo, (Comparable)((Object)"ToDo"), (Comparable)label);
        }
    }

    protected Result summarizeBuild(Run<?, ?> b) {
        Result r = new Result();
        TapBuildAction action = (TapBuildAction)b.getAction(this.getBuildActionClass());
        if (action != null) {
            TapResult report = action.getResult();
            report.tally();
            r.numPassed = report.getPassed();
            r.numFailed = report.getFailed();
            r.numSkipped = report.getSkipped();
            r.numToDo = report.getToDo();
        }
        return r;
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }

    protected class Result {
        public int numPassed = 0;
        public int numFailed = 0;
        public int numSkipped = 0;
        public int numToDo = 0;

        public void add(Result r) {
            this.numPassed += r.numPassed;
            this.numFailed += r.numFailed;
            this.numSkipped += r.numSkipped;
            this.numToDo += r.numToDo;
        }
    }
}

