/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BasicContainer;
import org.mp4parser.Box;
import org.mp4parser.BoxParser;
import org.mp4parser.PropertyBoxParserImpl;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.support.DoNotParseDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DoNotParseDetail
public class IsoFile
extends BasicContainer
implements Closeable {
    public static volatile long MAX_RECORD_SIZE_OVERRIDE = -1L;
    private static Logger LOG = LoggerFactory.getLogger(IsoFile.class);
    private ReadableByteChannel readableByteChannel;

    public IsoFile(String file) throws IOException {
        this(new File(file));
    }

    public IsoFile(File file) throws IOException {
        this.readableByteChannel = new FileInputStream(file).getChannel();
        try {
            this.initContainer(this.readableByteChannel, file.length(), new PropertyBoxParserImpl(new String[0]));
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public IsoFile(ReadableByteChannel readableByteChannel) throws IOException {
        this(readableByteChannel, new PropertyBoxParserImpl(new String[0]));
    }

    public IsoFile(ReadableByteChannel readableByteChannel, BoxParser boxParser) throws IOException {
        this.readableByteChannel = readableByteChannel;
        this.initContainer(readableByteChannel, -1L, boxParser);
    }

    public static byte[] fourCCtoBytes(String fourCC) {
        byte[] result = new byte[4];
        if (fourCC != null) {
            int i = 0;
            while (i < Math.min(4, fourCC.length())) {
                result[i] = (byte)fourCC.charAt(i);
                ++i;
            }
        }
        return result;
    }

    public static String bytesToFourCC(byte[] type) {
        byte[] result = new byte[4];
        if (type != null) {
            System.arraycopy(type, 0, result, 0, Math.min(type.length, 4));
        }
        try {
            return new String(result, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Required character encoding is missing", e);
        }
    }

    public long getSize() {
        return this.getContainerSize();
    }

    public MovieBox getMovieBox() {
        for (Box box : this.getBoxes()) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }

    public void getBox(WritableByteChannel os) throws IOException {
        this.writeContainer(os);
    }

    @Override
    public void close() throws IOException {
        try {
            for (Box box : this.getBoxes()) {
                if (!(box instanceof Closeable)) continue;
                ((Closeable)((Object)box)).close();
            }
        }
        finally {
            this.readableByteChannel.close();
        }
    }

    @Override
    public String toString() {
        return "model(" + this.readableByteChannel.toString() + ")";
    }
}

