/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.source;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.PostConstruct;
import org.talend.runtime.documentation.component.configuration.TableDataSet;
import org.talend.runtime.documentation.component.messages.Messages;
import org.talend.runtime.documentation.component.service.MockTableService;
import org.talend.runtime.documentation.component.service.http.TableApiClient;
import org.talend.runtime.documentation.component.source.MockTableSource;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.input.Assessor;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.input.PartitionSize;
import org.talend.sdk.component.api.input.Split;
import org.talend.sdk.component.api.meta.Documentation;

@Version
@Icon(value=Icon.IconType.CUSTOM, custom="MockInput")
@PartitionMapper(name="MockInput")
@Documentation(value="MockInput is a configurable connector that is responsible of reading from Service Now Table using a query to filter the records.")
public class MockTableMapper
implements Serializable {
    private final TableDataSet ds;
    private final MockTableService service;
    private final Messages i18n;
    private final TableApiClient tableAPI;

    public MockTableMapper(@Option(value="tableDataSet") TableDataSet tableDataSet, MockTableService service, Messages i18n, TableApiClient tableAPI) {
        this.ds = tableDataSet;
        this.service = service;
        this.tableAPI = tableAPI;
        this.i18n = i18n;
    }

    @PostConstruct
    public void init() {
        this.tableAPI.base(this.ds.getDataStore().getUrlWithSlashEnding() + "api/now" + "/" + "v2");
    }

    @Assessor
    public long estimateSize() {
        int totalData = this.tableAPI.count(this.ds.getCommonConfig().getTableName().name(), this.ds.getDataStore().getAuthorizationHeader(), this.ds.buildQuery());
        int requestedSize = this.ds.getMaxRecords() == -1 ? totalData : Math.min(totalData, this.ds.getMaxRecords());
        long recordSize = this.tableAPI.estimateRecordSize(this.ds.getCommonConfig().getTableName().name(), this.ds.getDataStore().getAuthorizationHeader(), this.ds.buildQuery(), this.ds.getCommonConfig().getFieldsCommaSeparated());
        return recordSize * (long)requestedSize;
    }

    @Split
    public List<MockTableMapper> split(@PartitionSize long bundles) {
        long recordSize = this.tableAPI.estimateRecordSize(this.ds.getCommonConfig().getTableName().name(), this.ds.getDataStore().getAuthorizationHeader(), this.ds.buildQuery(), this.ds.getCommonConfig().getFieldsCommaSeparated());
        long nbBundle = Math.max(1L, this.estimateSize() / bundles);
        long bundleCount = bundles / recordSize;
        int totalData = this.tableAPI.count(this.ds.getCommonConfig().getTableName().name(), this.ds.getDataStore().getAuthorizationHeader(), this.ds.buildQuery());
        int requestedSize = this.ds.getMaxRecords() == -1 ? totalData : Math.min(totalData, this.ds.getMaxRecords());
        return LongStream.range(0L, nbBundle).mapToObj(i -> {
            int to;
            int from = (int)(bundleCount * i);
            int n = to = i == nbBundle - 1L ? requestedSize : (int)((long)from + bundleCount);
            if (to == 0) {
                return null;
            }
            TableDataSet dataSetChunk = new TableDataSet(this.ds);
            dataSetChunk.setOffset(from);
            dataSetChunk.setMaxRecords(to);
            return new MockTableMapper(dataSetChunk, this.service, this.i18n, this.tableAPI);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Emitter
    public MockTableSource createWorker() {
        return new MockTableSource(this.ds, this.i18n, this.tableAPI);
    }
}

