/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.output;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.runtime.documentation.component.configuration.OutputConfig;
import org.talend.runtime.documentation.component.output.Reject;
import org.talend.runtime.documentation.component.service.http.TableApiClient;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Input;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.processor.OutputEmitter;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.http.HttpException;

@Version
@Icon(value=Icon.IconType.CUSTOM, custom="MockOutput")
@Processor(name="MockOutput")
@Documentation(value="MockOutput is a configurable connector able to write records to Service Now Table")
public class MockOutput
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MockOutput.class);
    private final OutputConfig outputConfig;
    private final JsonBuilderFactory factory;
    TableApiClient client;

    public MockOutput(@Option(value="configuration") OutputConfig outputConfig, TableApiClient client, JsonBuilderFactory factory) {
        this.outputConfig = outputConfig;
        this.client = client;
        this.factory = factory;
    }

    @PostConstruct
    public void init() {
        this.client.base(this.outputConfig.getDataStore().getUrlWithSlashEnding() + "api/now" + "/" + "v2");
    }

    @ElementListener
    public void onNext(@Input JsonObject record, @Output OutputEmitter<JsonObject> success, @Output(value="reject") OutputEmitter<Reject> reject) {
        try {
            String sysId = null;
            if (record.containsKey((Object)"sys_id")) {
                sysId = record.getString("sys_id");
            }
            switch (this.outputConfig.getActionOnTable()) {
                case Insert: {
                    JsonObject copy = sysId != null && sysId.isEmpty() ? record.entrySet().stream().filter(e -> !((String)e.getKey()).equals("sys_id")).collect(() -> ((JsonBuilderFactory)this.factory).createObjectBuilder(), (b, a) -> b.add((String)a.getKey(), (JsonValue)a.getValue()), JsonObjectBuilder::addAll).build() : record;
                    JsonObject newRec = this.client.create(this.outputConfig.getCommonConfig().getTableName().name(), this.outputConfig.getDataStore().getAuthorizationHeader(), this.outputConfig.isNoResponseBody(), copy);
                    if (newRec != null) {
                        success.emit((Object)newRec);
                    }
                    break;
                }
                case Update: {
                    if (sysId == null || sysId.isEmpty()) {
                        reject.emit((Object)new Reject(1, "sys_id is required to update the record", null, record));
                        break;
                    }
                    JsonObject newRec = this.client.update(this.outputConfig.getCommonConfig().getTableName().name(), sysId, this.outputConfig.getDataStore().getAuthorizationHeader(), this.outputConfig.isNoResponseBody(), record);
                    if (newRec != null) {
                        success.emit((Object)newRec);
                    }
                    break;
                }
                case Delete: {
                    if (sysId == null || sysId.isEmpty()) {
                        reject.emit((Object)new Reject(2, "sys_id is required to delete the record", null, record));
                        break;
                    }
                    this.client.deleteRecordById(this.outputConfig.getCommonConfig().getTableName().name(), sysId, this.outputConfig.getDataStore().getAuthorizationHeader());
                    success.emit((Object)record);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.outputConfig.getActionOnTable()) + " is not supported yet");
                }
            }
        }
        catch (HttpException httpError) {
            JsonObject error = (JsonObject)httpError.getResponse().error(JsonObject.class);
            if (error != null && error.containsKey((Object)"error")) {
                reject.emit((Object)new Reject(httpError.getResponse().status(), error.getJsonObject("error").getString("message"), error.getJsonObject("error").getString("detail"), record));
            }
            reject.emit((Object)new Reject(httpError.getResponse().status(), "unknown", "unknown", record));
        }
    }
}

