/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.configuration;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.talend.runtime.documentation.component.configuration.BasicAuthConfig;
import org.talend.runtime.documentation.component.configuration.CommonConfig;
import org.talend.runtime.documentation.component.configuration.OrderBuilder;
import org.talend.runtime.documentation.component.configuration.QueryBuilder;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.condition.ActiveIf;
import org.talend.sdk.component.api.configuration.type.DataSet;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayout;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayouts;
import org.talend.sdk.component.api.meta.Documentation;

@DataSet(value="table")
@GridLayouts(value={@GridLayout(value={@GridLayout.Row(value={"dataStore"}), @GridLayout.Row(value={"commonConfig"}), @GridLayout.Row(value={"queryBuilder"}), @GridLayout.Row(value={"ordered"}), @GridLayout.Row(value={"orderBuilder"})}), @GridLayout(names={"Advanced"}, value={@GridLayout.Row(value={"limit"}), @GridLayout.Row(value={"maxRecords"}), @GridLayout.Row(value={"commonConfig"})})})
@Documentation(value="This data set represent a Service Now Table, like incident, problem, service...")
public class TableDataSet
implements Serializable {
    public static final int READ_ALL_RECORD_FROM_SERVER = -1;
    public static final int MAX_LIMIT = 10000;
    @Option
    private BasicAuthConfig dataStore;
    @Option
    private CommonConfig commonConfig;
    @Option
    @Documentation(value="Query builder")
    private List<QueryBuilder> queryBuilder;
    @Option
    @Documentation(value="Order of the data set.")
    private boolean ordered = false;
    @Option
    @ActiveIf(target="ordered", value={"true"})
    @Documentation(value="the data set fields order")
    private List<OrderBuilder> orderBuilder;
    private int offset;
    @Option
    @Documentation(value="Max record to retrieve. Default if -1, set to -1 to get all the data from service now server.")
    private int maxRecords = -1;
    @Option
    @Documentation(value="limit for pagination. The default is 10000.")
    private int limit = 10000;

    public TableDataSet(TableDataSet mDataSet) {
        this.dataStore = mDataSet.getDataStore();
        this.commonConfig = mDataSet.getCommonConfig();
        this.ordered = mDataSet.isOrdered();
        this.orderBuilder = mDataSet.getOrderBuilder();
        this.queryBuilder = mDataSet.getQueryBuilder();
        this.offset = mDataSet.getOffset();
        this.maxRecords = mDataSet.getMaxRecords();
        this.limit = mDataSet.getLimit();
    }

    public String buildQuery() {
        String query = "";
        if (this.getQueryBuilder() != null && !this.getQueryBuilder().isEmpty()) {
            query = this.getQueryBuilder().stream().map(f -> f.getField() + f.getOperation().operation() + f.getValue()).collect(Collectors.joining("^"));
        }
        if (this.isOrdered() && this.getOrderBuilder() != null && !this.getOrderBuilder().isEmpty()) {
            String order = this.getOrderBuilder().stream().map(o -> "ORDERBY" + o.getField()).collect(Collectors.joining("^"));
            query = query + "^" + order;
        }
        return query.isEmpty() ? null : query;
    }

    public int getPageSize() {
        return this.maxRecords == -1 ? this.limit : Math.min(this.limit, this.maxRecords - this.offset);
    }

    public BasicAuthConfig getDataStore() {
        return this.dataStore;
    }

    public CommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    public List<QueryBuilder> getQueryBuilder() {
        return this.queryBuilder;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public List<OrderBuilder> getOrderBuilder() {
        return this.orderBuilder;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setDataStore(BasicAuthConfig dataStore) {
        this.dataStore = dataStore;
    }

    public void setCommonConfig(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public void setQueryBuilder(List<QueryBuilder> queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setOrderBuilder(List<OrderBuilder> orderBuilder) {
        this.orderBuilder = orderBuilder;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDataSet)) {
            return false;
        }
        TableDataSet other = (TableDataSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOrdered() != other.isOrdered()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getMaxRecords() != other.getMaxRecords()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        BasicAuthConfig this$dataStore = this.getDataStore();
        BasicAuthConfig other$dataStore = other.getDataStore();
        if (this$dataStore == null ? other$dataStore != null : !((Object)this$dataStore).equals(other$dataStore)) {
            return false;
        }
        CommonConfig this$commonConfig = this.getCommonConfig();
        CommonConfig other$commonConfig = other.getCommonConfig();
        if (this$commonConfig == null ? other$commonConfig != null : !((Object)this$commonConfig).equals(other$commonConfig)) {
            return false;
        }
        List<QueryBuilder> this$queryBuilder = this.getQueryBuilder();
        List<QueryBuilder> other$queryBuilder = other.getQueryBuilder();
        if (this$queryBuilder == null ? other$queryBuilder != null : !((Object)this$queryBuilder).equals(other$queryBuilder)) {
            return false;
        }
        List<OrderBuilder> this$orderBuilder = this.getOrderBuilder();
        List<OrderBuilder> other$orderBuilder = other.getOrderBuilder();
        return !(this$orderBuilder == null ? other$orderBuilder != null : !((Object)this$orderBuilder).equals(other$orderBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDataSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOrdered() ? 79 : 97);
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getMaxRecords();
        result = result * 59 + this.getLimit();
        BasicAuthConfig $dataStore = this.getDataStore();
        result = result * 59 + ($dataStore == null ? 43 : ((Object)$dataStore).hashCode());
        CommonConfig $commonConfig = this.getCommonConfig();
        result = result * 59 + ($commonConfig == null ? 43 : ((Object)$commonConfig).hashCode());
        List<QueryBuilder> $queryBuilder = this.getQueryBuilder();
        result = result * 59 + ($queryBuilder == null ? 43 : ((Object)$queryBuilder).hashCode());
        List<OrderBuilder> $orderBuilder = this.getOrderBuilder();
        result = result * 59 + ($orderBuilder == null ? 43 : ((Object)$orderBuilder).hashCode());
        return result;
    }

    public String toString() {
        return "TableDataSet(dataStore=" + this.getDataStore() + ", commonConfig=" + this.getCommonConfig() + ", queryBuilder=" + this.getQueryBuilder() + ", ordered=" + this.isOrdered() + ", orderBuilder=" + this.getOrderBuilder() + ", offset=" + this.getOffset() + ", maxRecords=" + this.getMaxRecords() + ", limit=" + this.getLimit() + ")";
    }

    public TableDataSet() {
    }

    public TableDataSet(BasicAuthConfig dataStore, CommonConfig commonConfig, List<QueryBuilder> queryBuilder, boolean ordered, List<OrderBuilder> orderBuilder, int offset, int maxRecords, int limit) {
        this.dataStore = dataStore;
        this.commonConfig = commonConfig;
        this.queryBuilder = queryBuilder;
        this.ordered = ordered;
        this.orderBuilder = orderBuilder;
        this.offset = offset;
        this.maxRecords = maxRecords;
        this.limit = limit;
    }
}

