/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.configuration;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.action.Checkable;
import org.talend.sdk.component.api.configuration.action.Validable;
import org.talend.sdk.component.api.configuration.type.DataStore;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayout;
import org.talend.sdk.component.api.configuration.ui.widget.Credential;
import org.talend.sdk.component.api.meta.Documentation;

@Checkable(value="basicAuth")
@DataStore(value="basicAuth")
@GridLayout(value={@GridLayout.Row(value={"url"}), @GridLayout.Row(value={"username", "password"})})
@Documentation(value="Basic auth data store for Service Now")
public class BasicAuthConfig
implements Serializable {
    public static final String NAME = "basicAuth";
    @Option
    @Validable(value="urlValidation")
    @Documentation(value="Service Now API instance URL")
    private String url;
    @Option
    @Documentation(value="Service Now Instance username")
    private String username;
    @Option
    @Credential
    @Documentation(value="Service Now Instance password")
    private String password;

    public String getUrlWithSlashEnding() {
        if (this.url == null) {
            return null;
        }
        String urlWithSlash = this.url;
        if (!this.url.endsWith("/")) {
            urlWithSlash = urlWithSlash + "/";
        }
        return urlWithSlash;
    }

    public String getAuthorizationHeader() {
        try {
            return "Basic " + Base64.getEncoder().encodeToString((this.getUsername() + ":" + this.getPassword()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthConfig)) {
            return false;
        }
        BasicAuthConfig other = (BasicAuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicAuthConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "BasicAuthConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public BasicAuthConfig() {
    }

    public BasicAuthConfig(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }
}

