/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.runtime.documentation.WriteIfDifferentStream;

public class StaticRedirector {
    private static final Logger log = LoggerFactory.getLogger(StaticRedirector.class);
    public static final String LATEST_REDIRECT = "<!DOCTYPE html>\n<meta charset=\"utf-8\">\n<link rel=\"canonical\" href=\"https://talend.github.io/component-runtime/main/latest/index.html\">\n<script>location=\"main/latest/index.html\"</script>\n<meta http-equiv=\"refresh\" content=\"0; url=main/latest/index.html\">\n<meta name=\"robots\" content=\"noindex\">\n<title>Redirect Notice</title>\n<h1>Redirect Notice</h1>\n<p>The page you requested has been relocated to <a href=\"main/latest/index.html\">https://talend.github.io/component-runtime/main/latest/index.html</a>.</p>";

    public static void main(String[] args) {
        log.info("Creating redirection file to latest.");
        File siteRoot = new File(args[0]);
        File index = new File(siteRoot, "index.html");
        try (WriteIfDifferentStream output = new WriteIfDifferentStream(index);){
            ((OutputStream)output).write(LATEST_REDIRECT.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new IllegalStateException(e);
        }
        log.info("Created {}", (Object)index);
    }

    private StaticRedirector() {
    }
}

