/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Optional;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.runtime.documentation.Contributor;

public class Gravatars {
    private static final Logger log = LoggerFactory.getLogger(Gravatars.class);
    public static final String GRAVATAR_BASE = "https://fr.gravatar.com/";

    public static String url(String input) {
        String hash = Gravatars.gravatarHash(input == null ? "" : input);
        return "https://www.gravatar.com/avatar/" + hash + "?s=140";
    }

    public static Contributor loadGravatar(WebTarget target, String input) {
        String hash = Gravatars.gravatarHash(input);
        String gravatarUrl = "https://www.gravatar.com/avatar/" + hash + "?s=140";
        Response gravatar = target.path(hash + ".json").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        return Optional.ofNullable(gravatar).filter(r -> r.getStatus() == 200).map(r -> ((Gravatar)r.readEntity(Gravatar.class)).getEntry()).map(e -> e[0]).map(e -> Contributor.builder().id(e.getId()).name(Optional.ofNullable(e.getName()).map(n -> Optional.ofNullable(n.getFormatted()).orElse(Optional.ofNullable(n.getGivenName()).orElse("") + Optional.ofNullable(n.getFamilyName()).orElse(""))).orElseGet(() -> Optional.ofNullable(e.getDisplayName()).orElse(Optional.ofNullable(e.getPreferredUsername()).orElse(input)))).description(Optional.ofNullable(e.getAboutMe()).orElse("")).gravatar(gravatarUrl).build()).orElse(Contributor.builder().name(input).id(input).description("").gravatar(gravatarUrl).build());
    }

    private static String gravatarHash(String mail) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] cp1252s = md.digest(mail.getBytes("CP1252"));
            StringBuilder sb = new StringBuilder();
            for (byte anArray : cp1252s) {
                sb.append(Integer.toHexString(anArray & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private Gravatars() {
    }

    public static class GravatarEntry {
        private String id;
        private String hash;
        private String aboutMe;
        private String requestHash;
        private String profileUrl;
        private String preferredUsername;
        private String thumbnailUrl;
        private GravatarName name;
        private GravatarUrl[] urls;
        private GravatarAccount[] accounts;
        private String displayName;

        public String getId() {
            return this.id;
        }

        public String getHash() {
            return this.hash;
        }

        public String getAboutMe() {
            return this.aboutMe;
        }

        public String getRequestHash() {
            return this.requestHash;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public String getPreferredUsername() {
            return this.preferredUsername;
        }

        public String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        public GravatarName getName() {
            return this.name;
        }

        public GravatarUrl[] getUrls() {
            return this.urls;
        }

        public GravatarAccount[] getAccounts() {
            return this.accounts;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public void setAboutMe(String aboutMe) {
            this.aboutMe = aboutMe;
        }

        public void setRequestHash(String requestHash) {
            this.requestHash = requestHash;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        public void setPreferredUsername(String preferredUsername) {
            this.preferredUsername = preferredUsername;
        }

        public void setThumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
        }

        public void setName(GravatarName name) {
            this.name = name;
        }

        public void setUrls(GravatarUrl[] urls) {
            this.urls = urls;
        }

        public void setAccounts(GravatarAccount[] accounts) {
            this.accounts = accounts;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GravatarEntry)) {
                return false;
            }
            GravatarEntry other = (GravatarEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            String this$aboutMe = this.getAboutMe();
            String other$aboutMe = other.getAboutMe();
            if (this$aboutMe == null ? other$aboutMe != null : !this$aboutMe.equals(other$aboutMe)) {
                return false;
            }
            String this$requestHash = this.getRequestHash();
            String other$requestHash = other.getRequestHash();
            if (this$requestHash == null ? other$requestHash != null : !this$requestHash.equals(other$requestHash)) {
                return false;
            }
            String this$profileUrl = this.getProfileUrl();
            String other$profileUrl = other.getProfileUrl();
            if (this$profileUrl == null ? other$profileUrl != null : !this$profileUrl.equals(other$profileUrl)) {
                return false;
            }
            String this$preferredUsername = this.getPreferredUsername();
            String other$preferredUsername = other.getPreferredUsername();
            if (this$preferredUsername == null ? other$preferredUsername != null : !this$preferredUsername.equals(other$preferredUsername)) {
                return false;
            }
            String this$thumbnailUrl = this.getThumbnailUrl();
            String other$thumbnailUrl = other.getThumbnailUrl();
            if (this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl)) {
                return false;
            }
            GravatarName this$name = this.getName();
            GravatarName other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getUrls(), other.getUrls())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAccounts(), other.getAccounts())) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GravatarEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            String $aboutMe = this.getAboutMe();
            result = result * 59 + ($aboutMe == null ? 43 : $aboutMe.hashCode());
            String $requestHash = this.getRequestHash();
            result = result * 59 + ($requestHash == null ? 43 : $requestHash.hashCode());
            String $profileUrl = this.getProfileUrl();
            result = result * 59 + ($profileUrl == null ? 43 : $profileUrl.hashCode());
            String $preferredUsername = this.getPreferredUsername();
            result = result * 59 + ($preferredUsername == null ? 43 : $preferredUsername.hashCode());
            String $thumbnailUrl = this.getThumbnailUrl();
            result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
            GravatarName $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getUrls());
            result = result * 59 + Arrays.deepHashCode(this.getAccounts());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "Gravatars.GravatarEntry(id=" + this.getId() + ", hash=" + this.getHash() + ", aboutMe=" + this.getAboutMe() + ", requestHash=" + this.getRequestHash() + ", profileUrl=" + this.getProfileUrl() + ", preferredUsername=" + this.getPreferredUsername() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", name=" + this.getName() + ", urls=" + Arrays.deepToString(this.getUrls()) + ", accounts=" + Arrays.deepToString(this.getAccounts()) + ", displayName=" + this.getDisplayName() + ")";
        }
    }

    public static class Gravatar {
        private GravatarEntry[] entry;

        public GravatarEntry[] getEntry() {
            return this.entry;
        }

        public void setEntry(GravatarEntry[] entry) {
            this.entry = entry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Gravatar)) {
                return false;
            }
            Gravatar other = (Gravatar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.getEntry(), other.getEntry());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Gravatar;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getEntry());
            return result;
        }

        public String toString() {
            return "Gravatars.Gravatar(entry=" + Arrays.deepToString(this.getEntry()) + ")";
        }
    }

    public static class GravatarAccount {
        private String shortname;
        private String url;

        public String getShortname() {
            return this.shortname;
        }

        public String getUrl() {
            return this.url;
        }

        public void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GravatarAccount)) {
                return false;
            }
            GravatarAccount other = (GravatarAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$shortname = this.getShortname();
            String other$shortname = other.getShortname();
            if (this$shortname == null ? other$shortname != null : !this$shortname.equals(other$shortname)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GravatarAccount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $shortname = this.getShortname();
            result = result * 59 + ($shortname == null ? 43 : $shortname.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "Gravatars.GravatarAccount(shortname=" + this.getShortname() + ", url=" + this.getUrl() + ")";
        }
    }

    public static class GravatarUrl {
        private String value;
        private String title;

        public String getValue() {
            return this.value;
        }

        public String getTitle() {
            return this.title;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GravatarUrl)) {
                return false;
            }
            GravatarUrl other = (GravatarUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GravatarUrl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "Gravatars.GravatarUrl(value=" + this.getValue() + ", title=" + this.getTitle() + ")";
        }
    }

    public static class GravatarName {
        private String formatted;
        private String givenName;
        private String familyName;

        public String getFormatted() {
            return this.formatted;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GravatarName)) {
                return false;
            }
            GravatarName other = (GravatarName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$formatted = this.getFormatted();
            String other$formatted = other.getFormatted();
            if (this$formatted == null ? other$formatted != null : !this$formatted.equals(other$formatted)) {
                return false;
            }
            String this$givenName = this.getGivenName();
            String other$givenName = other.getGivenName();
            if (this$givenName == null ? other$givenName != null : !this$givenName.equals(other$givenName)) {
                return false;
            }
            String this$familyName = this.getFamilyName();
            String other$familyName = other.getFamilyName();
            return !(this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GravatarName;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $formatted = this.getFormatted();
            result = result * 59 + ($formatted == null ? 43 : $formatted.hashCode());
            String $givenName = this.getGivenName();
            result = result * 59 + ($givenName == null ? 43 : $givenName.hashCode());
            String $familyName = this.getFamilyName();
            result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
            return result;
        }

        public String toString() {
            return "Gravatars.GravatarName(formatted=" + this.getFormatted() + ", givenName=" + this.getGivenName() + ", familyName=" + this.getFamilyName() + ")";
        }
    }

    public static class Link {
        private String name;
        private String url;

        Link(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public static LinkBuilder builder() {
            return new LinkBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Link;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "Gravatars.Link(name=" + this.getName() + ", url=" + this.getUrl() + ")";
        }

        public static class LinkBuilder {
            private String name;
            private String url;

            LinkBuilder() {
            }

            public LinkBuilder name(String name) {
                this.name = name;
                return this;
            }

            public LinkBuilder url(String url) {
                this.url = url;
                return this;
            }

            public Link build() {
                return new Link(this.name, this.url);
            }

            public String toString() {
                return "Gravatars.Link.LinkBuilder(name=" + this.name + ", url=" + this.url + ")";
            }
        }
    }
}

