/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbProperty;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.runtime.documentation.Contributor;
import org.talend.runtime.documentation.Gravatars;
import org.talend.sdk.component.maven.MavenDecrypter;
import org.talend.sdk.component.maven.Server;

public class Github {
    private static final Logger log = LoggerFactory.getLogger(Github.class);
    private final String user;
    private final String password;
    private final GenericType<Collection<GithubContributor>> responseType = new GenericType<Collection<GithubContributor>>(){};

    public Collection<Contributor> load() {
        String token = "Basic " + Base64.getEncoder().encodeToString((this.user + ':' + this.password).getBytes(StandardCharsets.UTF_8));
        Client client = (Client)ClientBuilder.newClient().register((Object)new JsonbJaxrsProvider());
        try {
            client.register(Thread.currentThread().getContextClassLoader().loadClass("org.apache.cxf.transport.common.gzip.GZIPFeature"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        WebTarget gravatarBase = client.target("https://fr.gravatar.com/");
        ExecutorService pool = Executors.newCachedThreadPool(r -> new Thread(r, Github.class.getName() + "-" + r.hashCode()));
        try {
            CompletableFuture[] contributorLookups = Github.toArray(Stream.of("component-api", "component-runtime").map(repo -> Github.toStage(pool, () -> this.contributors(client, token, "https://api.github.com/repos/talend/" + repo + "/contributors").collect(Collectors.toList()))));
            Collection collection = (Collection)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(contributorLookups).thenApply(ignored -> Github.toArray(Stream.of(contributorLookups).flatMap(it -> ((List)this.getResult((Future)it)).stream()).collect(Collectors.toMap(e -> this.normalizeLogin(((GithubContributor)e).login), Function.identity(), (c1, c2) -> {
                ((GithubContributor)c1).contributions += ((GithubContributor)c2).contributions;
                return c1;
            })).values().stream().map(contributor -> Github.toStage(pool, () -> this.loadContributor(token, client, gravatarBase, (GithubContributor)contributor)))))).thenCompose(contribs -> CompletableFuture.allOf(contribs).thenApply(ignored -> Stream.of(contribs).map(this::getResult).filter(Objects::nonNull).sorted(Comparator.comparing(Contributor::getCommits).reversed()).collect(Collectors.toList())))).get();
            return collection;
        }
        catch (ExecutionException ee) {
            Response response;
            if (WebApplicationException.class.isInstance(ee.getCause()) && (response = ((WebApplicationException)WebApplicationException.class.cast(ee.getCause())).getResponse()) != null && response.getEntity() != null) {
                log.error((String)response.readEntity(String.class));
            }
            throw new IllegalStateException(ee.getCause());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            client.close();
            pool.shutdownNow();
        }
    }

    private <T> T getResult(Future<T> f) {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private static <T> CompletableFuture<T> toStage(ExecutorService pool, Supplier<T> supplier) {
        CompletableFuture stage = new CompletableFuture();
        pool.submit(() -> {
            try {
                stage.complete(supplier.get());
            }
            catch (Exception e) {
                stage.completeExceptionally(e);
            }
        });
        return stage;
    }

    private static <T> CompletableFuture<T>[] toArray(Stream<CompletableFuture<T>> stream) {
        return (CompletableFuture[])stream.toArray(CompletableFuture[]::new);
    }

    private Contributor loadContributor(String token, Client client, WebTarget gravatarBase, GithubContributor contributor) {
        if (contributor.url == null) {
            try {
                Contributor gravatar = Gravatars.loadGravatar(gravatarBase, contributor.email);
                return Contributor.builder().name(contributor.name).commits(contributor.contributions).description(gravatar.getDescription()).gravatar(gravatar.getGravatar()).build();
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                return new Contributor(contributor.email, contributor.email, "", Gravatars.url(contributor.email), contributor.contributions);
            }
        }
        GithubUser user = (GithubUser)client.target(contributor.url).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)token).get(GithubUser.class);
        return Contributor.builder().id(contributor.login).name(Optional.ofNullable(user.name).orElse(contributor.name)).description((user.bio == null ? "" : user.bio) + (user.blog != null && !user.blog.trim().isEmpty() && (user.bio == null || !user.bio.contains(user.blog)) ? "\n\nBlog: " + user.blog : "")).commits(contributor.contributions).gravatar(Optional.ofNullable(contributor.avatarUrl).orElseGet(() -> {
            String gravatarId = contributor.gravatarId == null || contributor.gravatarId.isEmpty() ? contributor.email : contributor.gravatarId;
            try {
                return Gravatars.loadGravatar(gravatarBase, gravatarId).getGravatar();
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                return Gravatars.url(gravatarId);
            }
        })).build();
    }

    private String normalizeLogin(String login) {
        if (login != null) {
            switch (login.toLowerCase(Locale.ROOT)) {
                case "jsomsanith-tlnd": 
                case "jso-technologies": {
                    return "jsomsanith";
                }
                case "toutpt": {
                    return "jmfrancois";
                }
            }
        }
        return login;
    }

    private Stream<GithubContributor> contributors(Client client, String token, String url) {
        return Stream.of(client.target(url).queryParam("per_page", new Object[]{100}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)token).get()).flatMap(response -> {
            String link = response.getHeaderString("Link");
            if (response.getStatus() > 299) {
                throw new IllegalStateException("Invalid response: HTP " + response.getStatus() + " / " + (String)response.readEntity(String.class));
            }
            Stream pageContributors = ((Collection)response.readEntity(this.responseType)).stream();
            if (link == null) {
                return pageContributors;
            }
            return Stream.concat(pageContributors, Stream.of(link.split(",")).map(String::trim).filter(s -> s.endsWith("rel=\"next\"")).flatMap(l -> {
                int from = l.indexOf(60);
                int to = l.indexOf(62);
                return this.contributors(client, token, l.substring(from + 1, to));
            }));
        });
    }

    public static void main(String[] args) {
        Server server = new MavenDecrypter().find("github");
        Collection<Contributor> contributors = new Github(server.getUsername(), server.getPassword()).load();
        System.out.println(contributors);
    }

    public Github(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public static class GithubContributor {
        private String login;
        private String url;
        private String email;
        private String name;
        private int contributions;
        @JsonbProperty(value="avatar_url")
        private String avatarUrl;
        @JsonbProperty(value="gravatar_id")
        private String gravatarId;

        public String getLogin() {
            return this.login;
        }

        public String getUrl() {
            return this.url;
        }

        public String getEmail() {
            return this.email;
        }

        public String getName() {
            return this.name;
        }

        public int getContributions() {
            return this.contributions;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public String getGravatarId() {
            return this.gravatarId;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setContributions(int contributions) {
            this.contributions = contributions;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public void setGravatarId(String gravatarId) {
            this.gravatarId = gravatarId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GithubContributor)) {
                return false;
            }
            GithubContributor other = (GithubContributor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getContributions() != other.getContributions()) {
                return false;
            }
            String this$login = this.getLogin();
            String other$login = other.getLogin();
            if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$avatarUrl = this.getAvatarUrl();
            String other$avatarUrl = other.getAvatarUrl();
            if (this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl)) {
                return false;
            }
            String this$gravatarId = this.getGravatarId();
            String other$gravatarId = other.getGravatarId();
            return !(this$gravatarId == null ? other$gravatarId != null : !this$gravatarId.equals(other$gravatarId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GithubContributor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getContributions();
            String $login = this.getLogin();
            result = result * 59 + ($login == null ? 43 : $login.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $avatarUrl = this.getAvatarUrl();
            result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
            String $gravatarId = this.getGravatarId();
            result = result * 59 + ($gravatarId == null ? 43 : $gravatarId.hashCode());
            return result;
        }

        public String toString() {
            return "Github.GithubContributor(login=" + this.getLogin() + ", url=" + this.getUrl() + ", email=" + this.getEmail() + ", name=" + this.getName() + ", contributions=" + this.getContributions() + ", avatarUrl=" + this.getAvatarUrl() + ", gravatarId=" + this.getGravatarId() + ")";
        }
    }

    public static class GithubUser {
        private String name;
        private String bio;
        private String blog;

        public String getName() {
            return this.name;
        }

        public String getBio() {
            return this.bio;
        }

        public String getBlog() {
            return this.blog;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBio(String bio) {
            this.bio = bio;
        }

        public void setBlog(String blog) {
            this.blog = blog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GithubUser)) {
                return false;
            }
            GithubUser other = (GithubUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$bio = this.getBio();
            String other$bio = other.getBio();
            if (this$bio == null ? other$bio != null : !this$bio.equals(other$bio)) {
                return false;
            }
            String this$blog = this.getBlog();
            String other$blog = other.getBlog();
            return !(this$blog == null ? other$blog != null : !this$blog.equals(other$blog));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GithubUser;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $bio = this.getBio();
            result = result * 59 + ($bio == null ? 43 : $bio.hashCode());
            String $blog = this.getBlog();
            result = result * 59 + ($blog == null ? 43 : $blog.hashCode());
            return result;
        }

        public String toString() {
            return "Github.GithubUser(name=" + this.getName() + ", bio=" + this.getBio() + ", blog=" + this.getBlog() + ")";
        }
    }
}

