/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.WordUtils;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.ziplock.IO;
import org.apache.ziplock.JarLocation;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jruby.Ruby;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.runtime.documentation.Contributor;
import org.talend.runtime.documentation.Github;
import org.talend.runtime.documentation.WriteIfDifferentStream;
import org.talend.sdk.component.api.configuration.action.BuiltInSuggestable;
import org.talend.sdk.component.api.configuration.condition.ActiveIf;
import org.talend.sdk.component.api.configuration.condition.ActiveIfs;
import org.talend.sdk.component.api.configuration.condition.meta.Condition;
import org.talend.sdk.component.api.configuration.constraint.meta.Validation;
import org.talend.sdk.component.api.configuration.constraint.meta.Validations;
import org.talend.sdk.component.api.configuration.type.meta.ConfigurationType;
import org.talend.sdk.component.api.configuration.ui.layout.AutoLayout;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayout;
import org.talend.sdk.component.api.configuration.ui.meta.Ui;
import org.talend.sdk.component.api.configuration.ui.widget.DateTime;
import org.talend.sdk.component.api.configuration.ui.widget.Structure;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.asyncvalidation.ValidationResult;
import org.talend.sdk.component.api.service.completion.SuggestionValues;
import org.talend.sdk.component.api.service.completion.Values;
import org.talend.sdk.component.api.service.healthcheck.HealthCheckStatus;
import org.talend.sdk.component.junit.environment.BaseEnvironmentProvider;
import org.talend.sdk.component.remoteengine.customizer.Cli;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ConditionParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ConfigurationTypeParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.UiParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ValidationParameterEnricher;
import org.talend.sdk.component.runtime.manager.xbean.KnownClassesFilter;
import org.talend.sdk.component.runtime.record.SchemaImpl;
import org.talend.sdk.component.runtime.reflect.Defaults;
import org.talend.sdk.component.runtime.server.vault.proxy.endpoint.security.SecurityFilter;
import org.talend.sdk.component.runtime.server.vault.proxy.service.VaultService;
import org.talend.sdk.component.runtime.server.vault.proxy.service.http.ClientSetup;
import org.talend.sdk.component.runtime.server.vault.proxy.service.jcache.CacheConfigurationFactory;
import org.talend.sdk.component.runtime.server.vault.proxy.service.jcache.JCacheSetup;
import org.talend.sdk.component.runtime.server.vault.proxy.service.jcache.VaultProxyCacheResolver;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.spi.parameter.ParameterExtensionEnricher;

public class Generator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);

    public static void main(String[] args) {
        if (Boolean.parseBoolean(args[7]) || Boolean.getBoolean(System.getenv("TRAVIS"))) {
            log.info("Skipping doc generation as requested");
            return;
        }
        File generatedDir = new File(args[0], "_partials");
        generatedDir.mkdirs();
        String version = args[3].replace("-SNAPSHOT", "");
        try (Tasks tasks = new Tasks();){
            tasks.register(Asciidoctor.Factory::create).thenApply(adoc -> {
                Generator.generatedDocumentationIndex(generatedDir, adoc);
                return null;
            }).thenAccept(ignored -> Ruby.getGlobalRuntime().getJITCompiler().tearDown());
            tasks.register(() -> Generator.generatedTypes(generatedDir));
            tasks.register(() -> Generator.generatedConstraints(generatedDir));
            tasks.register(() -> Generator.generatedConditions(generatedDir));
            tasks.register(() -> Generator.generatedActions(generatedDir));
            tasks.register(() -> Generator.generatedUi(generatedDir));
            tasks.register(() -> Generator.generatedServerConfiguration(generatedDir));
            tasks.register(() -> Generator.generatedServerVaultProxyConfiguration(generatedDir));
            tasks.register(() -> Generator.updateComponentServerApi(generatedDir, version));
            tasks.register(() -> Generator.updateComponentServerVaultApi(generatedDir, version));
            tasks.register(() -> Generator.generatedJUnitEnvironment(generatedDir));
            tasks.register(() -> Generator.generatedScanningExclusions(generatedDir));
            tasks.register(() -> Generator.generatedRemoteEngineCustomizerHelp(generatedDir));
            boolean offline = "offline=true".equals(args[4]);
            if (offline) {
                log.info("System is offline, skipping jira changelog and github contributor generation");
            } else {
                tasks.register(() -> Generator.generatedContributors(generatedDir, args[5], args[6]));
                tasks.register(() -> Generator.generatedJira(generatedDir, args[1], args[2], version));
            }
        }
    }

    private static void generatedRemoteEngineCustomizerHelp(File generatedDir) throws Exception {
        try (PrintStream printStream = new PrintStream(new WriteIfDifferentStream(generatedDir.toPath().resolve("generated_remote-engine-customizer-help.adoc").toFile()));){
            printStream.println(Cli.run((String[])new String[]{"help", "register-component-archive"}));
        }
    }

    private static void updateComponentServerApi(File generatedDir, String version) throws Exception {
        Generator.writeServerOpenApi(new File(generatedDir, "generated_rest-resources.adoc"), "META-INF/resources/documentation/openapi.json", version);
    }

    private static void updateComponentServerVaultApi(File generatedDir, String version) throws Exception {
        Generator.writeServerOpenApi(new File(generatedDir, "generated_rest-resources-vault.adoc"), "META-INF/resources/openapi.json", version);
    }

    private static void writeServerOpenApi(File output, String resource, String version) throws Exception {
        block19: {
            try (InputStream source = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                 Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig());){
                int end;
                String newJson = IO.slurp((InputStream)source);
                String oldJson = !output.exists() ? "{}" : String.join((CharSequence)"\n", Files.readAllLines(output.toPath()));
                int start = oldJson.indexOf(".swaggerUi = ");
                if (start > 0) {
                    oldJson = oldJson.substring(start + ".swaggerUi = ".length());
                }
                if ((end = oldJson.indexOf(";</script>")) > 0) {
                    oldJson = oldJson.substring(0, end);
                }
                JsonBuilderFactory builderFactory = Json.createBuilderFactory(Collections.emptyMap());
                JsonObject oldApi = !oldJson.startsWith("{") ? builderFactory.createObjectBuilder().build() : (JsonObject)jsonb.fromJson(oldJson, JsonObject.class);
                JsonObject newApi = builderFactory.createObjectBuilder((JsonObject)jsonb.fromJson(newJson, JsonObject.class)).add("servers", builderFactory.createArrayBuilder().add(builderFactory.createObjectBuilder().add("url", String.format("https://starter-toolkit.talend.io/api/demo/%s", version)))).build();
                if (oldJson.startsWith("{") && Generator.areEqualsIgnoringOrder((JsonValue)oldApi, (JsonValue)newApi)) break block19;
                try (WriteIfDifferentStream writer = new WriteIfDifferentStream(output);){
                    ((OutputStream)writer).write(("== Component Server API\n:page-talend_swaggerui:\n\n++++\n<script>\n(window.talend = (window.talend || {})).swaggerUi = " + newApi.toString() + ";</script>\n<div id=\"swagger-ui\"></div>\n++++\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    private static boolean areEqualsIgnoringOrder(JsonValue oldValue, JsonValue newValue) {
        if (!oldValue.getValueType().equals((Object)newValue.getValueType())) {
            return false;
        }
        switch (oldValue.getValueType()) {
            case STRING: {
                return ((JsonString)JsonString.class.cast(oldValue)).getString().equals(((JsonString)JsonString.class.cast(newValue)).getString());
            }
            case NUMBER: {
                return ((JsonNumber)JsonNumber.class.cast(oldValue)).doubleValue() == ((JsonNumber)JsonNumber.class.cast(newValue)).doubleValue();
            }
            case OBJECT: {
                JsonObject oldObject = oldValue.asJsonObject();
                JsonObject newObject = newValue.asJsonObject();
                if (!oldObject.keySet().equals(newObject.keySet())) {
                    return false;
                }
                return oldObject.keySet().stream().map(key -> Generator.areEqualsIgnoringOrder((JsonValue)oldObject.get(key), (JsonValue)newObject.get(key))).reduce(true, (a, b) -> a != false && b != false);
            }
            case ARRAY: {
                JsonArray oldArray = oldValue.asJsonArray();
                JsonArray newArray = newValue.asJsonArray();
                if (oldArray.size() != newArray.size()) {
                    return false;
                }
                if (oldArray.isEmpty()) {
                    return true;
                }
                for (JsonValue oldItem : oldArray) {
                    if (!newArray.stream().noneMatch(newitem -> Generator.areEqualsIgnoringOrder(oldItem, newitem))) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private static void generatedDocumentationIndex(File generatedDir, Asciidoctor asciidoctor) {
        File baseDir = JarLocation.jarLocation(Generator.class).getParentFile().getParentFile();
        File pages = new File(baseDir, "src/main/antora/modules/ROOT/pages/");
        Collection items = Stream.of(Objects.requireNonNull(pages.listFiles(), "Missing pages")).filter(f -> f.getName().endsWith(".adoc")).map(file -> {
            Document document = asciidoctor.loadFile(file, Collections.emptyMap());
            if (document.getAttributes().keySet().stream().noneMatch(it -> it.startsWith("page-documentationindex"))) {
                return null;
            }
            String name = file.getName();
            return new DocumentationItem(Optional.ofNullable(document.getAttribute((Object)"page-documentationindex-index")).map(String::valueOf).map(Integer::parseInt).orElse(Integer.MAX_VALUE), Optional.ofNullable(document.getAttribute((Object)"page-documentationindex-icon")).map(String::valueOf).orElse("link"), Optional.ofNullable(document.getAttribute((Object)"page-documentationindex-label")).map(String::valueOf).orElseGet(() -> ((Document)document).getTitle()), Optional.ofNullable(document.getAttribute((Object)"page-documentationindex-description")).map(String::valueOf).orElseGet(() -> Optional.ofNullable(document.getDoctitle()).orElse(document.getTitle())), name.substring(0, name.length() - ".adoc".length()) + ".html");
        }).filter(Objects::nonNull).sorted(Comparator.comparing(DocumentationItem::getIndex)).collect(Collectors.toList());
        File file2 = new File(generatedDir, "generated_documentationindex.adoc");
        try (Jsonb jsonb = Generator.newJsonb();
             WriteIfDifferentStream writer = new WriteIfDifferentStream(file2);){
            ((OutputStream)writer).write("++++\n<jsonArray>".getBytes(StandardCharsets.UTF_8));
            ((OutputStream)writer).write(jsonb.toJson((Object)items).getBytes(StandardCharsets.UTF_8));
            ((OutputStream)writer).write("</jsonArray>\n++++".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void processSection(StructuralNode node, StringBuilder builder, String target) {
        node.getBlocks().stream().filter(Section.class::isInstance).map(Section.class::cast).forEach(section -> {
            boolean root = section.getLevel() == 1;
            builder.append(root ? "." : IntStream.range(0, section.getLevel() - 1).mapToObj(i -> "*").collect(Collectors.joining()) + " xref:" + target + "#" + section.getId() + "[").append(root ? Generator.mapTitle(section.getTitle()) : section.getTitle()).append(root ? "" : "]").append('\n');
            Generator.processSection((StructuralNode)section, builder, target);
            if (root) {
                builder.append('\n');
            }
        });
    }

    private static String mapTitle(String title) {
        switch (title) {
            case "Talend Components Definitions Documentation": {
                return "Programming Model";
            }
            case "Components Packaging": {
                return "Package";
            }
            case ".Build tools": {
                return "Build";
            }
            case "Talend Component Testing Documentation": {
                return "Testing";
            }
        }
        return title;
    }

    private static void generatedScanningExclusions(File generatedDir) {
        File file = new File(generatedDir, "generated_scanning-exclusions.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println("= Package Scanning");
            stream.println();
            stream.println("Since the framework can be used in the case of __fatjars__ or __shades__,");
            stream.println("and because it still uses scanning,");
            stream.println("it is important to ensure we don't scan the whole classes for performances reason.");
            stream.println();
            stream.println("Therefore, the following packages are ignored:");
            stream.println();
            stream.println("[.talend-filterlist]");
            ((KnownClassesFilter.OptimizedExclusionFilter)KnownClassesFilter.OptimizedExclusionFilter.class.cast(((KnownClassesFilter)KnownClassesFilter.class.cast(KnownClassesFilter.INSTANCE)).getDelegateSkip())).getIncluded().stream().sorted().distinct().map(prefix -> "- " + prefix).forEach(stream::println);
            stream.println();
            stream.println();
            stream.println("NOTE: it is not recommanded but possible to add in your plugin module a");
            stream.println("`TALEND-INF/scanning.properties` file with `classloader.includes` and");
            stream.println("`classloader.excludes` entries to refine the scanning with custom rules.");
            stream.println("In such a case, exclusions win over inclusions.");
            stream.println();
            stream.println();
        }
    }

    private static void generatedJUnitEnvironment(File generatedDir) throws MalformedURLException {
        File file = new File(generatedDir, "generated_junit-environments.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            stream.println("NOTE: the configuration is read from system properties, environment variables, ....");
            stream.println();
            File api = JarLocation.jarLocation(BaseEnvironmentProvider.class);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            AnnotationFinder finder = new AnnotationFinder((Archive)(api.isDirectory() ? new FileArchive(loader, api) : new JarArchive(loader, api.toURI().toURL())));
            finder.link().findSubclasses(BaseEnvironmentProvider.class).stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).sorted(Comparator.comparing(Class::getName)).forEach(type -> {
                BaseEnvironmentProvider environment;
                try {
                    environment = (BaseEnvironmentProvider)BaseEnvironmentProvider.class.cast(type.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
                stream.println(environment.getName() + ":: __class: " + type.getSimpleName() + "_. ");
            });
            stream.println();
        }
    }

    private static void generatedContributors(File generatedDir, String user, String pwd) throws Exception {
        Collection<Contributor> contributors;
        if (user == null || user.trim().isEmpty() || "skip".equals(user)) {
            log.error("No Github credentials, will skip contributors generation");
            return;
        }
        try {
            contributors = new Github(user, pwd).load();
        }
        catch (RuntimeException re) {
            log.error(re.getMessage(), (Throwable)re);
            return;
        }
        File file = new File(generatedDir, "generated_contributors.adoc");
        try (Jsonb jsonb = Generator.newJsonb();
             WriteIfDifferentStream writer = new WriteIfDifferentStream(file);){
            ((OutputStream)writer).write("++++\n<jsonArray>".getBytes(StandardCharsets.UTF_8));
            ((OutputStream)writer).write(jsonb.toJson(contributors).getBytes(StandardCharsets.UTF_8));
            ((OutputStream)writer).write("</jsonArray>\n++++".getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generatedJira(File generatedDir, String username, String password, String version) {
        if (username == null || username.trim().isEmpty() || "skip".equals(username)) {
            log.error("No JIRA credentials, will skip changelog generation");
            return;
        }
        String project = "TCOMP";
        String jiraBase = "https://jira.talendforge.org";
        File file = new File(generatedDir, "generated_changelog.adoc");
        String auth = "Basic " + Base64.getEncoder().encodeToString((username + ':' + password).getBytes(StandardCharsets.UTF_8));
        try (Client client = (Client)ClientBuilder.newClient().register((Object)new JsonbJaxrsProvider());){
            WebTarget restApi = (WebTarget)client.target("https://jira.talendforge.org/rest/api/2").property("http.connection.timeout", (Object)60000L);
            List versions = (List)restApi.path("project/{project}/versions").resolveTemplate("project", (Object)"TCOMP").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)auth).get((GenericType)new GenericType<List<JiraVersion>>(){});
            List jiraLoggedVersions = versions.stream().filter(v -> v.isReleased() || Generator.jiraVersionMatches(version, v.getName())).collect(Collectors.toList());
            if (jiraLoggedVersions.isEmpty()) {
                try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
                    stream.println("No version found.");
                }
                return;
            }
            HashMap<String, String> changelogPerVersion = new HashMap<String, String>();
            try (BufferedReader reader = new BufferedReader(new StringReader(String.join((CharSequence)"\n", Files.readAllLines(file.toPath()))));){
                String line;
                StringBuilder builder = new StringBuilder();
                String versionRead = null;
                while ((line = reader.readLine()) != null) {
                    if (builder.length() == 0 && line.trim().isEmpty()) continue;
                    if (line.startsWith("== Version ")) {
                        if (builder.length() != 0) {
                            changelogPerVersion.put(versionRead, builder.toString());
                            builder.setLength(0);
                        }
                        versionRead = line.substring("== Version ".length()).replace(" (dev)", "");
                    }
                    builder.append(line).append('\n');
                }
                if (builder.length() != 0) {
                    changelogPerVersion.put(versionRead, builder.toString());
                    builder.setLength(0);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            int maxVersionPerQuery = 10;
            final BiFunction<String, Long, JiraIssues> searchFrom = (jql, startAt) -> (JiraIssues)restApi.path("search").queryParam("jql", new Object[]{jql}).queryParam("startAt", new Object[]{startAt}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)auth).get(JiraIssues.class);
            BiFunction<String, JiraIssues, Stream<JiraIssues>> paginate = new BiFunction<String, JiraIssues, Stream<JiraIssues>>(){

                @Override
                public Stream<JiraIssues> apply(String jql, JiraIssues issues) {
                    long nextStartAt = issues.getStartAt() + issues.getMaxResults();
                    Stream fetched = Stream.of(issues);
                    return issues.getTotal() > nextStartAt ? (Stream)Stream.concat(fetched, this.apply(jql, (JiraIssues)searchFrom.apply(jql, nextStartAt))).parallel() : fetched;
                }
            };
            Set includeStatus = Stream.of("closed", "resolved", "development done", "qa done", "done").collect(Collectors.toSet());
            List queriedVersion = jiraLoggedVersions.stream().filter(it -> !changelogPerVersion.containsKey(it.getName()) || version.equals(it.getName())).collect(Collectors.toList());
            Map issues = IntStream.range(0, (queriedVersion.size() + 10 - 1) / 10).mapToObj(pageIdx -> queriedVersion.subList(pageIdx * 10, Math.min(10 * (pageIdx + 1), queriedVersion.size()))).map(pageVersions -> "project=TCOMP AND labels=\"changelog\"" + pageVersions.stream().map(v -> "fixVersion=" + v.getName()).collect(Collectors.joining(" OR ", " AND (", ")"))).flatMap(jql -> Stream.of((JiraIssues)searchFrom.apply((String)jql, 0L)).flatMap(it -> (Stream)paginate.apply((String)jql, (JiraIssues)it)).flatMap(i -> Optional.ofNullable(i.getIssues()).map(Collection::stream).orElseGet(Stream::empty)).filter(issue -> includeStatus.contains(issue.getFields().getStatus().getName().toLowerCase(Locale.ENGLISH))).flatMap(i -> i.getFields().getFixVersions().stream().map(v -> Pair.of((Object)v, (Object)i)))).collect(Collectors.groupingBy(pair -> ((JiraVersion)pair.getKey()).getName(), () -> new TreeMap(Generator.versionComparator()), Collectors.groupingBy(pair -> ((JiraIssue)pair.getValue()).getFields().getIssuetype().getName(), TreeMap::new, Collectors.collectingAndThen(Collectors.mapping(Pair::getValue, Collectors.toList()), l -> {
                l.sort(Comparator.comparing(JiraIssue::getKey));
                return l;
            }))));
            issues.forEach((name, issuesMap) -> changelogPerVersion.put((String)name, "\n\n== Version " + name + issuesMap.entrySet().stream().collect(StringBuilder::new, (builder, issuesByType) -> builder.append("\n\n=== ").append((String)issuesByType.getKey()).append("\n\n").append((CharSequence)((List)issuesByType.getValue()).stream().collect(StringBuilder::new, (a, i) -> a.append("- link:").append("https://jira.talendforge.org").append("/browse/").append(i.getKey()).append("[").append(i.getKey()).append("^]").append(": ").append(i.getFields().getSummary().trim()).append("\n"), StringBuilder::append)).append('\n'), StringBuilder::append)));
            String changelog = changelogPerVersion.entrySet().stream().sorted((v1, v2) -> {
                if (v1.equals(v2)) {
                    return 0;
                }
                int[] parts1 = Stream.of(((String)v1.getKey()).replace(" (dev)", "").split("\\.")).mapToInt(Integer::parseInt).toArray();
                int[] parts2 = Stream.of(((String)v2.getKey()).replace(" (dev)", "").split("\\.")).mapToInt(Integer::parseInt).toArray();
                for (int i = 0; i < parts1.length; ++i) {
                    if (parts2.length <= i) {
                        return 1;
                    }
                    int comp = parts2[i] - parts1[i];
                    if (comp == 0) continue;
                    return comp;
                }
                return 0;
            }).map(Map.Entry::getValue).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
            try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
                stream.println(changelog);
            }
        }
    }

    private static Comparator<String> versionComparator() {
        return (o1, o2) -> {
            String[] parts1 = o1.split("\\.");
            String[] parts2 = o2.split("\\.");
            for (int i = 0; i < Math.max(parts1.length, parts2.length); ++i) {
                try {
                    int major = (parts2.length > i ? Integer.parseInt(parts2[i]) : 0) - (parts1.length > i ? Integer.parseInt(parts1[i]) : 0);
                    if (major == 0) continue;
                    return major;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return o2.compareTo((String)o1);
        };
    }

    private static boolean jiraVersionMatches(String ref, String name) {
        return ref.equals(name) || ref.equals(name + ".0");
    }

    private static void generatedServerConfiguration(File generatedDir) {
        File file = new File(generatedDir, "generated_server-configuration.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            stream.println("NOTE: the configuration is read from system properties, environment variables, ....");
            stream.println();
            Generator.generateConfigTableContent(stream, ComponentServerConfiguration.class);
            stream.println();
        }
    }

    private static void generatedServerVaultProxyConfiguration(File generatedDir) {
        File file = new File(generatedDir, "generated_server-vault-proxy-configuration.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            stream.println("NOTE: the configuration is read from system properties, environment variables, ....");
            stream.println();
            Generator.generateConfigTableContent(stream, ClientSetup.class, VaultService.class, JCacheSetup.class, SecurityFilter.class, VaultProxyCacheResolver.class, CacheConfigurationFactory.class);
            stream.println();
        }
    }

    private static void generateConfigTableContent(PrintStream stream, Class<?> ... configClass) {
        Stream.of(configClass).flatMap(c -> Stream.of(c.getDeclaredFields())).filter(field -> field.isAnnotationPresent(ConfigProperty.class)).map(field -> {
            ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
            String name = field.getAnnotation(ConfigProperty.class).name();
            return name.startsWith("git.") ? null : name + ":: " + Optional.of(configProperty.defaultValue()).filter(it -> !it.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")).map(it -> "Default value: `" + it + "`. ").orElse("") + Stream.of(field.getDeclaredAnnotations()).filter(a -> a.annotationType().getSimpleName().equals("Documentation")).map(a -> {
                try {
                    return a.annotationType().getMethod("value", new Class[0]).invoke(a, new Object[0]).toString();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return "-";
                }
            }).findFirst().orElse("-");
        }).filter(Objects::nonNull).sorted().forEach(stream::println);
    }

    private static void generatedActions(File generatedDir) throws Exception {
        File file = new File(generatedDir, "generated_actions.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            File api = JarLocation.jarLocation(ActionType.class);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            AnnotationFinder finder = new AnnotationFinder((Archive)(api.isDirectory() ? new FileArchive(loader, api) : new JarArchive(loader, api.toURI().toURL())));
            try (Jsonb jsonb = Generator.newJsonb();){
                finder.findAnnotatedClasses(ActionType.class).stream().sorted(Comparator.comparing(t -> t.getAnnotation(ActionType.class).value() + "#" + t.getSimpleName())).forEach(type -> {
                    ActionType actionType = type.getAnnotation(ActionType.class);
                    Class returnedType = actionType.expectedReturnedType();
                    String actionTypeValue = actionType.value();
                    stream.println();
                    stream.println("= " + Generator.capitalizeWords(actionTypeValue));
                    stream.println();
                    stream.println(Generator.extractDoc(type));
                    stream.println();
                    stream.println("- Type: `" + actionTypeValue + "`");
                    stream.println("- API: `@" + type.getName() + "`");
                    if (returnedType != Object.class) {
                        stream.println("- Returned type: `" + returnedType.getName() + "`");
                        stream.println("- Sample:");
                        stream.println();
                        stream.println("[source,js]");
                        stream.println("----");
                        stream.println(Generator.sample(jsonb, returnedType));
                        stream.println("----");
                    }
                    stream.println();
                });
            }
            stream.println();
            stream.println("== Built In Actions");
            stream.println();
            stream.println("These actions are provided - or not - by the application the UI runs within.");
            stream.println();
            stream.println("TIP: always ensure you don't require this action in your component.");
            stream.println();
            Stream.of(BuiltInSuggestable.class).forEach(it -> {
                stream.println("= built_in_suggestable");
                stream.println();
                stream.println(Generator.extractDoc(BuiltInSuggestable.class));
                stream.println();
                stream.println("- API: `@" + BuiltInSuggestable.class.getName() + "`");
                stream.println();
            });
        }
    }

    private static String capitalizeWords(String actionTypeValue) {
        return Stream.of(actionTypeValue.replace("_", " ").split(" ")).map(WordUtils::capitalize).collect(Collectors.joining(" "));
    }

    private static void generatedUi(File generatedDir) throws Exception {
        File file = new File(generatedDir, "generated_ui.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            File api = JarLocation.jarLocation(Ui.class);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            AnnotationFinder finder = new AnnotationFinder((Archive)(api.isDirectory() ? new FileArchive(loader, api) : new JarArchive(loader, api.toURI().toURL())));
            UiParameterEnricher enricher = new UiParameterEnricher();
            try (Jsonb jsonb = Generator.newJsonb();){
                finder.findAnnotatedClasses(Ui.class).stream().sorted(Comparator.comparing(Class::getName)).forEach(arg_0 -> Generator.lambda$generatedUi$59(stream, (ParameterExtensionEnricher)enricher, jsonb, arg_0));
            }
            stream.println();
        }
    }

    private static void renderUiDoc(PrintStream stream, ParameterExtensionEnricher enricher, Jsonb jsonb, Class<?> type) {
        stream.println();
        stream.print("= @" + type.getSimpleName());
        stream.println();
        stream.println();
        stream.println(Generator.extractDoc(type));
        stream.println();
        stream.println("- API: `@" + type.getName() + "`");
        stream.println();
        stream.println("== Snippets");
        stream.println();
        Generator.getDocUiTypes(type).forEach(paramType -> {
            stream.println("[source,js]");
            stream.println("----");
            stream.println(jsonb.toJson(Generator.getMeta(enricher, type, paramType)));
            stream.println("----");
            stream.println();
        });
    }

    private static Map<String, String> getMeta(ParameterExtensionEnricher enricher, Class<?> type, Class<?> paramType) {
        return new TreeMap<String, String>(enricher.onParameterAnnotation("theparameter", paramType, Generator.generateAnnotation(type)).entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replace("tcomp::", ""), Map.Entry::getValue)));
    }

    private static Stream<? extends Class<? extends Object>> getDocUiTypes(Class<?> type) {
        return type == DateTime.class ? Stream.of(LocalTime.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class) : Stream.of(Object.class);
    }

    private static String sample(Jsonb jsonb, Class<?> returnedType) {
        if (returnedType == Values.class) {
            Values list = new Values();
            list.setItems(new ArrayList());
            Values.Item item = new Values.Item();
            item.setId("value");
            item.setLabel("label");
            list.getItems().add(item);
            return jsonb.toJson((Object)list);
        }
        if (returnedType == SuggestionValues.class) {
            SuggestionValues list = new SuggestionValues();
            list.setItems(new ArrayList());
            SuggestionValues.Item item = new SuggestionValues.Item();
            item.setId("value");
            item.setLabel("label");
            list.getItems().add(item);
            return jsonb.toJson((Object)list);
        }
        if (returnedType == HealthCheckStatus.class) {
            HealthCheckStatus status = new HealthCheckStatus();
            status.setStatus(HealthCheckStatus.Status.KO);
            status.setComment("Something went wrong");
            return jsonb.toJson((Object)status);
        }
        if (returnedType == org.talend.sdk.component.api.service.schema.Schema.class) {
            Schema.Entry entry = new SchemaImpl.EntryImpl.BuilderImpl().withName("column1").withType(Schema.Type.STRING).build();
            org.talend.sdk.component.api.service.schema.Schema schema = new org.talend.sdk.component.api.service.schema.Schema();
            schema.setEntries(new ArrayList());
            schema.getEntries().add(entry);
            return jsonb.toJson((Object)schema);
        }
        if (returnedType == Schema.class) {
            return jsonb.toJson((Object)new SchemaImpl.BuilderImpl().withType(Schema.Type.RECORD).withEntry(new SchemaImpl.EntryImpl.BuilderImpl().withName("column1").withRawName("column 1").withType(Schema.Type.STRING).withNullable(false).withComment("The column 1").build()).withEntry(new SchemaImpl.EntryImpl.BuilderImpl().withName("column2").withRawName("column 2").withType(Schema.Type.INT).withComment("The int column").build()).build());
        }
        if (returnedType == ValidationResult.class) {
            ValidationResult status = new ValidationResult();
            status.setStatus(ValidationResult.Status.KO);
            status.setComment("Something went wrong");
            return jsonb.toJson((Object)status);
        }
        return "{\n" + Stream.of(returnedType.getDeclaredFields()).map(f -> " \"" + f.getName() + "\": " + Generator.createSample(f.getType())).collect(Collectors.joining("\n")) + "\n}";
    }

    private static String createSample(Class<?> type) {
        if (type.isEnum()) {
            return Stream.of(type.getEnumConstants()).map(e -> ((Enum)Enum.class.cast(e)).name()).collect(Collectors.joining("\"|\"", "\"", "\""));
        }
        return "\"...\"";
    }

    private static void generatedConditions(File generatedDir) throws Exception {
        File file = new File(generatedDir, "generated_conditions.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            File api = JarLocation.jarLocation(Condition.class);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ConditionParameterEnricher enricher = new ConditionParameterEnricher();
            try (Jsonb jsonb = Generator.newJsonb();){
                AnnotationFinder finder = new AnnotationFinder((Archive)(api.isDirectory() ? new FileArchive(loader, api) : new JarArchive(loader, api.toURI().toURL())));
                finder.findAnnotatedClasses(Condition.class).stream().sorted(Comparator.comparing(Class::getName)).forEach(type -> {
                    stream.println();
                    stream.println("= " + Generator.capitalizeWords(type.getSimpleName()));
                    stream.println();
                    stream.println(Generator.extractDoc(type));
                    stream.println();
                    stream.println("- API: `@" + type.getName() + "`");
                    stream.println("- Type: `" + type.getAnnotation(Condition.class).value() + "`");
                    stream.println("- Sample:");
                    stream.println();
                    stream.println("[source,js]");
                    stream.println("----");
                    stream.println(jsonb.toJson(new TreeMap(enricher.onParameterAnnotation("test", String.class, Generator.generateAnnotation(type)))).replace("tcomp::", ""));
                    stream.println("----");
                    stream.println();
                });
                stream.println();
            }
        }
    }

    private static void generatedTypes(File generatedDir) throws Exception {
        File file = new File(generatedDir, "generated_configuration-types.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            File api = JarLocation.jarLocation(ConfigurationType.class);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ConfigurationTypeParameterEnricher enricher = new ConfigurationTypeParameterEnricher();
            AnnotationFinder finder = new AnnotationFinder((Archive)(api.isDirectory() ? new FileArchive(loader, api) : new JarArchive(loader, api.toURI().toURL())));
            try (Jsonb jsonb = Generator.newJsonb();){
                finder.findAnnotatedClasses(ConfigurationType.class).stream().sorted(Comparator.comparing(Class::getName)).forEach(type -> {
                    stream.println();
                    stream.println("= " + Generator.capitalizeWords(type.getAnnotation(ConfigurationType.class).value()));
                    stream.println();
                    stream.println(Generator.extractDoc(type));
                    stream.println();
                    stream.println("- API: @" + type.getName());
                    stream.println("- Sample:");
                    stream.println();
                    stream.println("[source,js]");
                    stream.println("----");
                    stream.println(jsonb.toJson(new TreeMap(enricher.onParameterAnnotation("value", String.class, Generator.generateAnnotation(type)))));
                    stream.println("----");
                    stream.println();
                });
            }
            stream.println();
        }
    }

    private static void generatedConstraints(File generatedDir) throws Exception {
        File file = new File(generatedDir, "generated_constraints.adoc");
        try (PrintStream stream = new PrintStream(new WriteIfDifferentStream(file));){
            stream.println();
            File api = JarLocation.jarLocation(Validation.class);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            AnnotationFinder finder = new AnnotationFinder((Archive)(api.isDirectory() ? new FileArchive(loader, api) : new JarArchive(loader, api.toURI().toURL())));
            ValidationParameterEnricher enricher = new ValidationParameterEnricher();
            try (Jsonb jsonb = Generator.newJsonb();){
                Stream.concat(finder.findAnnotatedClasses(Validation.class).stream().map(validation -> {
                    Validation val = validation.getAnnotation(Validation.class);
                    return Generator.createConstraint(validation, val);
                }), finder.findAnnotatedClasses(Validations.class).stream().flatMap(validations -> Stream.of(validations.getAnnotation(Validations.class).value()).map(validation -> Generator.createConstraint(validations, validation)))).sorted((o1, o2) -> {
                    int types = Stream.of(((Constraint)o1).types).map(Class::getName).collect(Collectors.joining("/")).compareTo(Stream.of(((Constraint)o2).types).map(Class::getName).collect(Collectors.joining("/")));
                    if (types == 0) {
                        return ((Constraint)o1).name.compareTo(((Constraint)o2).name);
                    }
                    return types;
                }).forEach(constraint -> {
                    stream.println();
                    stream.println("= " + Generator.capitalizeWords(((Constraint)constraint).name));
                    stream.println();
                    stream.println(((Constraint)constraint).description);
                    stream.println();
                    stream.println("- API: `@" + ((Constraint)constraint).marker.getName() + "`");
                    stream.println("- Name: `" + ((Constraint)constraint).name + "`");
                    stream.println("- Parameter Type: `" + ((Constraint)constraint).paramType + "`");
                    stream.println("- Supported Types:");
                    Stream.of(((Constraint)constraint).types).map(Class::getName).map(it -> "-- `" + it + "`").forEach(stream::println);
                    stream.println("- Sample:");
                    stream.println();
                    stream.println("[source,js]");
                    stream.println("----");
                    stream.println(jsonb.toJson(new TreeMap(enricher.onParameterAnnotation("test", (Type)((Constraint)constraint).types[0], Generator.generateAnnotation(((Constraint)constraint).marker)))).replace("tcomp::", ""));
                    stream.println("----");
                    stream.println();
                });
            }
            stream.println();
        }
    }

    private static Constraint createConstraint(Class<?> validation, Validation val) {
        return new Constraint(val.name(), val.expectedTypes(), Generator.getParamType(validation), validation, Generator.extractDoc(validation));
    }

    private static String extractDoc(Class<?> validation) {
        return Optional.ofNullable(validation.getAnnotation(Documentation.class)).map(Documentation::value).orElse("-").replace("|", "\\|");
    }

    private static String getParamType(Class<?> validation) {
        try {
            Class<?> returnType = validation.getMethod("value", new Class[0]).getReturnType();
            return returnType.getName().toLowerCase(Locale.ENGLISH);
        }
        catch (NoSuchMethodException e) {
            return "-";
        }
    }

    private static <T extends Annotation> T generateAnnotation(Class<?> type) {
        return (T)((Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            Class<?> returnType;
            if ("annotationType".equals(method.getName()) && Annotation.class == method.getDeclaringClass()) {
                return type;
            }
            if (method.isDefault()) {
                try {
                    return Defaults.handleDefault(method.getDeclaringClass(), (Method)method, (Object)proxy, (Object[])args);
                }
                catch (Throwable e) {
                    log.error("[generateAnnotation] handleDefault failed: {}", (Object)e.getMessage());
                }
            }
            if (Integer.TYPE == (returnType = method.getReturnType())) {
                return 1234;
            }
            if (Boolean.TYPE == returnType) {
                return false;
            }
            if (Double.TYPE == returnType) {
                return 12.34;
            }
            if (String.class == returnType) {
                return "test";
            }
            if (Class.class == returnType) {
                return AutoLayout.class;
            }
            if (String[].class == returnType) {
                return new String[]{"value1", "value2"};
            }
            if (ActiveIf.EvaluationStrategy.class == returnType) {
                return ActiveIf.EvaluationStrategy.DEFAULT;
            }
            if (ActiveIf.EvaluationStrategyOption[].class == returnType) {
                return new ActiveIf.EvaluationStrategyOption[0];
            }
            if (ActiveIfs.Operator.class == returnType) {
                return ActiveIfs.Operator.AND;
            }
            if (Structure.Type.class == returnType) {
                return Structure.Type.IN;
            }
            if (GridLayout.Row[].class == returnType) {
                return new GridLayout.Row[]{new GridLayout.Row(){

                    public Class<? extends Annotation> annotationType() {
                        return GridLayout.Row.class;
                    }

                    public String[] value() {
                        return new String[]{"first"};
                    }
                }, new GridLayout.Row(){

                    public Class<? extends Annotation> annotationType() {
                        return GridLayout.Row.class;
                    }

                    public String[] value() {
                        return new String[]{"second", "third"};
                    }
                }};
            }
            if (ActiveIf[].class == returnType) {
                return new ActiveIf[]{new ActiveIf(){

                    public ActiveIf.EvaluationStrategyOption[] evaluationStrategyOptions() {
                        return new ActiveIf.EvaluationStrategyOption[0];
                    }

                    public String target() {
                        return "sibling1";
                    }

                    public String[] value() {
                        return new String[]{"value1", "value2"};
                    }

                    public boolean negate() {
                        return false;
                    }

                    public ActiveIf.EvaluationStrategy evaluationStrategy() {
                        return ActiveIf.EvaluationStrategy.DEFAULT;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return ActiveIf.class;
                    }
                }, new ActiveIf(){

                    public ActiveIf.EvaluationStrategyOption[] evaluationStrategyOptions() {
                        return new ActiveIf.EvaluationStrategyOption[0];
                    }

                    public String target() {
                        return "../../other";
                    }

                    public String[] value() {
                        return new String[]{"SELECTED"};
                    }

                    public boolean negate() {
                        return true;
                    }

                    public ActiveIf.EvaluationStrategy evaluationStrategy() {
                        return ActiveIf.EvaluationStrategy.LENGTH;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return ActiveIf.class;
                    }
                }};
            }
            if (GridLayout[].class == returnType) {
                return new GridLayout[]{new GridLayout(){

                    public GridLayout.Row[] value() {
                        return new GridLayout.Row[]{new GridLayout.Row(){

                            public Class<? extends Annotation> annotationType() {
                                return GridLayout.Row.class;
                            }

                            public String[] value() {
                                return new String[]{"first"};
                            }
                        }, new GridLayout.Row(){

                            public Class<? extends Annotation> annotationType() {
                                return GridLayout.Row.class;
                            }

                            public String[] value() {
                                return new String[]{"second", "third"};
                            }
                        }};
                    }

                    public String[] names() {
                        return new String[]{"Main"};
                    }

                    public Class<? extends Annotation> annotationType() {
                        return GridLayout.class;
                    }
                }, new GridLayout(){

                    public GridLayout.Row[] value() {
                        return new GridLayout.Row[]{new GridLayout.Row(){

                            public Class<? extends Annotation> annotationType() {
                                return GridLayout.Row.class;
                            }

                            public String[] value() {
                                return new String[]{"another"};
                            }
                        }};
                    }

                    public String[] names() {
                        return new String[]{"Advanced"};
                    }

                    public Class<? extends Annotation> annotationType() {
                        return GridLayout.class;
                    }
                }};
            }
            return null;
        }));
    }

    private static Jsonb newJsonb() {
        return JsonbBuilder.create((JsonbConfig)new JsonbConfig().withPropertyOrderStrategy("LEXICOGRAPHICAL").withFormatting(Boolean.valueOf(true)));
    }

    private Generator() {
    }

    private static /* synthetic */ void lambda$generatedUi$59(PrintStream stream, ParameterExtensionEnricher enricher, Jsonb jsonb, Class type) {
        Generator.renderUiDoc(stream, enricher, jsonb, type);
    }

    private static class ManualFuture<T>
    implements Future<T> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final AtomicBoolean done = new AtomicBoolean(false);
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private volatile T instance;
        private volatile Exception error;

        private ManualFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.latch.countDown();
            this.cancelled.set(true);
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.done.get();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return this.getResult();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            this.latch.await(timeout, unit);
            return this.getResult();
        }

        private T getResult() throws ExecutionException {
            if (this.error != null) {
                throw new ExecutionException(this.error);
            }
            return this.instance;
        }

        public void onFailure(Exception o) {
            this.error = o;
            this.done.set(true);
            this.latch.countDown();
        }

        public void onSuccess(T o) {
            this.instance = o;
            this.done.set(true);
            this.latch.countDown();
        }
    }

    private static class Tasks
    implements AutoCloseable {
        private final ForkJoinPool executorService;
        private final Collection<Future<?>> tasks = new ArrayList();
        private final Collection<Throwable> errors = new ArrayList<Throwable>();

        public Tasks() {
            final ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.executorService = new ForkJoinPool(Math.max(4, Runtime.getRuntime().availableProcessors() * 8), p -> new ForkJoinWorkerThread(p){
                {
                    super(pool);
                    this.setContextClassLoader(loader);
                }
            }, (r, executor) -> this.errors.add(new IllegalStateException("Task rejected: " + r)), false);
        }

        <T> CompletionStage<T> register(ThrowingSupplier<T> runnable) {
            CompletableFuture out = new CompletableFuture<T>(){

                @Override
                public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
                    ManualFuture future = new ManualFuture();
                    tasks.add(future);
                    return super.thenAccept((T a) -> {
                        try {
                            action.accept(a);
                        }
                        finally {
                            future.onSuccess(null);
                        }
                    });
                }

                @Override
                public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
                    ManualFuture future = new ManualFuture();
                    tasks.add(future);
                    return super.thenApply((T a) -> {
                        try {
                            Object r = fn.apply(a);
                            return r;
                        }
                        finally {
                            future.onSuccess(null);
                        }
                    });
                }
            };
            this.tasks.add(this.executorService.submit(() -> {
                try {
                    out.complete(runnable.get());
                }
                catch (Exception e) {
                    out.completeExceptionally(e);
                    this.errors.add(e);
                    throw new IllegalStateException(e);
                }
            }));
            return out;
        }

        void register(ThrowingRunnable runnable) {
            this.register(() -> {
                runnable.run();
                return null;
            });
        }

        @Override
        public void close() {
            this.executorService.shutdown();
            this.tasks.forEach(it -> {
                try {
                    it.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    this.errors.add(cause);
                    throw new IllegalStateException(cause);
                }
            });
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.errors.isEmpty()) {
                throw new IllegalStateException(this.errors.stream().map(Throwable::getMessage).collect(Collectors.joining("\n")));
            }
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable<T> {
        public void run() throws Exception;
    }

    @FunctionalInterface
    private static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }

    public static class Icon {
        private String name;
        private String path;
        private boolean legacy;

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isLegacy() {
            return this.legacy;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setLegacy(boolean legacy) {
            this.legacy = legacy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Icon)) {
                return false;
            }
            Icon other = (Icon)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isLegacy() != other.isLegacy()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Icon;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLegacy() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.Icon(name=" + this.getName() + ", path=" + this.getPath() + ", legacy=" + this.isLegacy() + ")";
        }

        public Icon(String name, String path, boolean legacy) {
            this.name = name;
            this.path = path;
            this.legacy = legacy;
        }

        public Icon() {
        }
    }

    public static class Status {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Status;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.Status(name=" + this.getName() + ")";
        }
    }

    public static class DocumentationItem {
        private int index;
        private String icon;
        private String label;
        private String description;
        private String link;

        public int getIndex() {
            return this.index;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLink() {
            return this.link;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocumentationItem)) {
                return false;
            }
            DocumentationItem other = (DocumentationItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$icon = this.getIcon();
            String other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$link = this.getLink();
            String other$link = other.getLink();
            return !(this$link == null ? other$link != null : !this$link.equals(other$link));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DocumentationItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : $link.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.DocumentationItem(index=" + this.getIndex() + ", icon=" + this.getIcon() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", link=" + this.getLink() + ")";
        }

        public DocumentationItem(int index, String icon, String label, String description, String link) {
            this.index = index;
            this.icon = icon;
            this.label = label;
            this.description = description;
            this.link = link;
        }

        public DocumentationItem() {
        }
    }

    public static class Fields {
        private String summary;
        private String description;
        private IssueType issuetype;
        private Status status;
        private Collection<JiraVersion> fixVersions;

        public String getSummary() {
            return this.summary;
        }

        public String getDescription() {
            return this.description;
        }

        public IssueType getIssuetype() {
            return this.issuetype;
        }

        public Status getStatus() {
            return this.status;
        }

        public Collection<JiraVersion> getFixVersions() {
            return this.fixVersions;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setIssuetype(IssueType issuetype) {
            this.issuetype = issuetype;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setFixVersions(Collection<JiraVersion> fixVersions) {
            this.fixVersions = fixVersions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fields)) {
                return false;
            }
            Fields other = (Fields)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$summary = this.getSummary();
            String other$summary = other.getSummary();
            if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            IssueType this$issuetype = this.getIssuetype();
            IssueType other$issuetype = other.getIssuetype();
            if (this$issuetype == null ? other$issuetype != null : !((Object)this$issuetype).equals(other$issuetype)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            Collection<JiraVersion> this$fixVersions = this.getFixVersions();
            Collection<JiraVersion> other$fixVersions = other.getFixVersions();
            return !(this$fixVersions == null ? other$fixVersions != null : !((Object)this$fixVersions).equals(other$fixVersions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Fields;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            IssueType $issuetype = this.getIssuetype();
            result = result * 59 + ($issuetype == null ? 43 : ((Object)$issuetype).hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            Collection<JiraVersion> $fixVersions = this.getFixVersions();
            result = result * 59 + ($fixVersions == null ? 43 : ((Object)$fixVersions).hashCode());
            return result;
        }

        public String toString() {
            return "Generator.Fields(summary=" + this.getSummary() + ", description=" + this.getDescription() + ", issuetype=" + this.getIssuetype() + ", status=" + this.getStatus() + ", fixVersions=" + this.getFixVersions() + ")";
        }
    }

    public static class JiraIssue {
        private String id;
        private String key;
        private Fields fields;

        public String getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public Fields getFields() {
            return this.fields;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setFields(Fields fields) {
            this.fields = fields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JiraIssue)) {
                return false;
            }
            JiraIssue other = (JiraIssue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Fields this$fields = this.getFields();
            Fields other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JiraIssue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Fields $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        public String toString() {
            return "Generator.JiraIssue(id=" + this.getId() + ", key=" + this.getKey() + ", fields=" + this.getFields() + ")";
        }
    }

    public static class IssueType {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IssueType)) {
                return false;
            }
            IssueType other = (IssueType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IssueType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.IssueType(name=" + this.getName() + ")";
        }
    }

    public static class JiraIssues {
        private long startAt;
        private long maxResults;
        private long total;
        private Collection<JiraIssue> issues;

        public long getStartAt() {
            return this.startAt;
        }

        public long getMaxResults() {
            return this.maxResults;
        }

        public long getTotal() {
            return this.total;
        }

        public Collection<JiraIssue> getIssues() {
            return this.issues;
        }

        public void setStartAt(long startAt) {
            this.startAt = startAt;
        }

        public void setMaxResults(long maxResults) {
            this.maxResults = maxResults;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public void setIssues(Collection<JiraIssue> issues) {
            this.issues = issues;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JiraIssues)) {
                return false;
            }
            JiraIssues other = (JiraIssues)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartAt() != other.getStartAt()) {
                return false;
            }
            if (this.getMaxResults() != other.getMaxResults()) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            Collection<JiraIssue> this$issues = this.getIssues();
            Collection<JiraIssue> other$issues = other.getIssues();
            return !(this$issues == null ? other$issues != null : !((Object)this$issues).equals(other$issues));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JiraIssues;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startAt = this.getStartAt();
            result = result * 59 + (int)($startAt >>> 32 ^ $startAt);
            long $maxResults = this.getMaxResults();
            result = result * 59 + (int)($maxResults >>> 32 ^ $maxResults);
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            Collection<JiraIssue> $issues = this.getIssues();
            result = result * 59 + ($issues == null ? 43 : ((Object)$issues).hashCode());
            return result;
        }

        public String toString() {
            return "Generator.JiraIssues(startAt=" + this.getStartAt() + ", maxResults=" + this.getMaxResults() + ", total=" + this.getTotal() + ", issues=" + this.getIssues() + ")";
        }
    }

    public static class JiraVersion {
        private String id;
        private String name;
        private boolean released;
        private boolean archived;
        private long projectId;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReleased() {
            return this.released;
        }

        public boolean isArchived() {
            return this.archived;
        }

        public long getProjectId() {
            return this.projectId;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setReleased(boolean released) {
            this.released = released;
        }

        public void setArchived(boolean archived) {
            this.archived = archived;
        }

        public void setProjectId(long projectId) {
            this.projectId = projectId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JiraVersion)) {
                return false;
            }
            JiraVersion other = (JiraVersion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isReleased() != other.isReleased()) {
                return false;
            }
            if (this.isArchived() != other.isArchived()) {
                return false;
            }
            if (this.getProjectId() != other.getProjectId()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JiraVersion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isReleased() ? 79 : 97);
            result = result * 59 + (this.isArchived() ? 79 : 97);
            long $projectId = this.getProjectId();
            result = result * 59 + (int)($projectId >>> 32 ^ $projectId);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.JiraVersion(id=" + this.getId() + ", name=" + this.getName() + ", released=" + this.isReleased() + ", archived=" + this.isArchived() + ", projectId=" + this.getProjectId() + ")";
        }
    }

    private static final class Constraint {
        private final String name;
        private final Class<?>[] types;
        private final String paramType;
        private final Class<?> marker;
        private final String description;

        public Constraint(String name, Class<?>[] types, String paramType, Class<?> marker, String description) {
            this.name = name;
            this.types = types;
            this.paramType = paramType;
            this.marker = marker;
            this.description = description;
        }
    }
}

