/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.text.StringSubstitutor;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.ziplock.JarLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMockUpdate {
    private static final Logger log = LoggerFactory.getLogger(ApiMockUpdate.class);

    public static void main(String[] args) throws Exception {
        if (Boolean.parseBoolean(System.getenv("APIMOCK_SKIP"))) {
            log.warn("Api mock update skipped");
            return;
        }
        ApiMockUpdate.doMain(new File(args[0]), new File(args[1]));
    }

    private static void doMain(File root, File apiPath) throws IOException, ExecutionException, InterruptedException {
        System.setProperty("talend.component.manager.m2.repository", ApiMockUpdate.createM2WithComponents(root).getAbsolutePath());
        System.setProperty("talend.component.server.component.coordinates", "org.talend.demo:components:1.0.0");
        ApiMockUpdate.updateMocks(apiPath);
    }

    private static void updateMocks(File apiPath) throws ExecutionException, InterruptedException, UnknownHostException {
        try (Meecrowave server = new Meecrowave((Configuration)new Meecrowave.Builder(){
            {
                this.randomHttpPort();
                this.setScanningExcludes("classworlds,container,freemarker,zipkin,backport,commons,component-form,component-runtime-junit,component-tools,crawler,doxia,exec,jsch,jcl,org.osgi,talend-component,component-server-vault-proxy");
                this.setScanningPackageExcludes("org.talend.sdk.component.proxy,org.talend.sdk.component.runtime.server.vault,org.talend.sdk.component.server.vault.proxy");
            }
        }).bake();){
            ApiMockUpdate.captureMocks(String.format("http://%s:%d", InetAddress.getLocalHost().getHostName(), server.getConfiguration().getHttpPort()), apiPath);
        }
        log.warn("[updateMocks] finished.");
    }

    private static File createM2WithComponents(File root) {
        File target = new File(root, ".m2/repository");
        File components = new File(root, ".m2/repository/org/talend/demo/components/1.0.0/components-1.0.0.jar");
        components.getParentFile().mkdirs();
        try (final JarOutputStream outputStream = new JarOutputStream(new FileOutputStream(components));){
            final Path base = JarLocation.jarLocation(ApiMockUpdate.class).toPath();
            Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String className = base.relativize(file).toString();
                    outputStream.putNextEntry(new JarEntry(className));
                    Files.copy(file, outputStream);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return target;
    }

    private static void captureMocks(String target, File output) throws ExecutionException, InterruptedException {
        String familyId = "Y29tcG9uZW50cyNNb2Nr";
        String componentId = "Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA";
        String configurationId = "Y29tcG9uZW50cyNNb2NrI2RhdGFzZXQjdGFibGU";
        ExecutorService executor = Executors.newFixedThreadPool(1);
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        try {
            CompletableFuture.allOf(ApiMockUpdate.capture(files, executor, "/api/v1/environment", target, Collections.emptyMap(), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/action/index", target, Collections.emptyMap(), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/action/execute", target, Collections.emptyMap(), t -> (byte[])t.queryParam("family", new Object[]{"Mock"}).queryParam("type", new Object[]{"healthcheck"}).queryParam("action", new Object[]{"basicAuth"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"{\"url\":\"http://localhost:51234/unavailable\",\"username\":\"xxx\",\"password\":\"yyy\"}", (MediaType)MediaType.APPLICATION_JSON_TYPE), byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/index", target, Collections.emptyMap(), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/details", target, Collections.emptyMap(), t -> (byte[])t.queryParam("identifiers", new Object[]{"Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/dependencies", target, Collections.emptyMap(), t -> (byte[])t.queryParam("identifiers", new Object[]{"Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/dependency/{id}", target, ApiMockUpdate.map("id", "Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA"), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/icon/{id}", target, ApiMockUpdate.map("id", "Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA"), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/icon/family/{id}", target, ApiMockUpdate.map("id", "Y29tcG9uZW50cyNNb2Nr"), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/component/migrate/{id}/{configurationVersion}", target, ApiMockUpdate.map("id", "Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA", "configurationVersion", "1"), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"{}", (MediaType)MediaType.APPLICATION_JSON_TYPE), byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/configurationtype/index", target, Collections.emptyMap(), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/configurationtype/details", target, Collections.emptyMap(), t -> (byte[])t.queryParam("identifiers", new Object[]{"Y29tcG9uZW50cyNNb2NrI2RhdGFzZXQjdGFibGU"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(byte[].class)), ApiMockUpdate.capture(files, executor, "/api/v1/configurationtype/migrate/{id}/{configurationVersion}", target, ApiMockUpdate.map("id", "Y29tcG9uZW50cyNNb2NrI2RhdGFzZXQjdGFibGU", "configurationVersion", "1"), t -> (byte[])t.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"{}", (MediaType)MediaType.APPLICATION_JSON_TYPE), byte[].class))).get(10L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        executor.shutdown();
        log.info("Updating {}", files.keySet());
        files.forEach((filePath, data) -> {
            File apiResult = new File(output, (String)filePath);
            apiResult.getParentFile().mkdirs();
            try {
                log.info("Storing {}", filePath);
                Files.write(apiResult.toPath(), data, new OpenOption[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            log.info("Stored {}", filePath);
        });
        executor.shutdownNow();
    }

    private static Map<String, String> map(String ... kv) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (int i = 0; i < kv.length; i += 2) {
            out.put(kv[i], kv[i + 1]);
        }
        return out;
    }

    private static CompletableFuture<Void> capture(Map<String, byte[]> files, Executor executor, String path, String base, Map<String, String> templates, Function<WebTarget, byte[]> target) {
        return CompletableFuture.runAsync(() -> {
            String outputPath = new StringSubstitutor(templates, "{", "}").replace(path);
            log.info("Trying to grab {}", (Object)outputPath);
            try (Client client = ClientBuilder.newClient();){
                WebTarget webTarget = client.target(base).path(path);
                for (Map.Entry tpl : templates.entrySet()) {
                    webTarget = webTarget.resolveTemplate((String)tpl.getKey(), tpl.getValue());
                }
                ((WebTarget)webTarget.property("http.connection.timeout", (Object)30000L)).property("http.receive.timeout", (Object)60000L);
                files.put(outputPath, (byte[])target.apply(webTarget));
                log.info("Grabbed to grab {}", (Object)outputPath);
            }
        }, executor);
    }

    private ApiMockUpdate() {
    }
}

