/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.service.asyncvalidation.AsyncValidation;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Suggestions;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.update.Update;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.tools.ComponentValidator;
import org.talend.sdk.component.tools.spi.ValidationExtension;
import org.talend.sdk.component.tools.validator.ActionValidator;
import org.talend.sdk.component.tools.validator.DataStoreValidator;
import org.talend.sdk.component.tools.validator.DatasetDiscoveryValidator;
import org.talend.sdk.component.tools.validator.DatasetValidator;
import org.talend.sdk.component.tools.validator.DocumentationValidator;
import org.talend.sdk.component.tools.validator.DocumentationWordingValidator;
import org.talend.sdk.component.tools.validator.ExceptionValidator;
import org.talend.sdk.component.tools.validator.ExtensionValidator;
import org.talend.sdk.component.tools.validator.FamilyValidator;
import org.talend.sdk.component.tools.validator.HttpValidator;
import org.talend.sdk.component.tools.validator.InternationalizationValidator;
import org.talend.sdk.component.tools.validator.InternationalizationWording;
import org.talend.sdk.component.tools.validator.LayoutValidator;
import org.talend.sdk.component.tools.validator.LocalConfigurationValidator;
import org.talend.sdk.component.tools.validator.MetadataValidator;
import org.talend.sdk.component.tools.validator.ModelValidator;
import org.talend.sdk.component.tools.validator.NoFinalOptionValidator;
import org.talend.sdk.component.tools.validator.OptionNameValidator;
import org.talend.sdk.component.tools.validator.OptionParameterValidator;
import org.talend.sdk.component.tools.validator.OutputConnectionValidator;
import org.talend.sdk.component.tools.validator.PlaceHolderValidator;
import org.talend.sdk.component.tools.validator.RecordValidator;
import org.talend.sdk.component.tools.validator.SchemaValidator;
import org.talend.sdk.component.tools.validator.SerializationValidator;
import org.talend.sdk.component.tools.validator.Validator;

public class Validators {
    private final List<Validator> validators;

    private Validators(List<Validator> validators) {
        this.validators = validators;
    }

    public Set<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        this.validators.stream().flatMap(validator -> validator.validate(finder, components)).forEach(errors::add);
        return errors;
    }

    public static Validators build(ComponentValidator.Configuration configuration, ValidatorHelper helper, Iterable<ValidationExtension> extensions) {
        Validator validator;
        ArrayList<Validator> activeValidators = new ArrayList<Validator>();
        if (configuration.isValidateSerializable()) {
            activeValidators.add(new SerializationValidator());
        }
        if (configuration.isValidateInternationalization()) {
            InternationalizationValidator intern = new InternationalizationValidator(helper);
            activeValidators.add(intern);
        }
        if (configuration.isValidateHttpClient()) {
            activeValidators.add(new HttpValidator());
        }
        if (configuration.isValidateModel()) {
            ModelValidator modelValidator = new ModelValidator(configuration.isValidateComponent(), helper);
            activeValidators.add(modelValidator);
        }
        if (configuration.isValidateMetadata()) {
            MetadataValidator metaValidator = new MetadataValidator(helper);
            activeValidators.add(metaValidator);
        }
        if (configuration.isValidateDataStore()) {
            validator = new DataStoreValidator(helper);
            activeValidators.add(validator);
        }
        if (configuration.isValidateDataSet()) {
            validator = new DatasetValidator(helper);
            activeValidators.add(validator);
            DatasetDiscoveryValidator discoveryValidator = new DatasetDiscoveryValidator(helper);
            activeValidators.add(discoveryValidator);
        }
        if (configuration.isValidateActions()) {
            validator = new ActionValidator(helper);
            activeValidators.add(validator);
        }
        if (configuration.isValidateDocumentation()) {
            activeValidators.add(new DocumentationValidator());
        }
        if (configuration.isValidateLayout()) {
            validator = new LayoutValidator(helper);
            activeValidators.add(validator);
        }
        if (configuration.isValidateOptionNames()) {
            activeValidators.add(new OptionNameValidator());
            activeValidators.add(new OptionParameterValidator());
        }
        if (configuration.isValidateLocalConfiguration()) {
            validator = new LocalConfigurationValidator(helper, configuration);
            activeValidators.add(validator);
        }
        if (configuration.isValidateOutputConnection()) {
            activeValidators.add(new OutputConnectionValidator());
        }
        if (configuration.isValidatePlaceholder()) {
            validator = new PlaceHolderValidator(helper);
            activeValidators.add(validator);
        }
        if (configuration.isValidateNoFinalOption()) {
            activeValidators.add(new NoFinalOptionValidator());
        }
        if (configuration.isValidateWording()) {
            if (configuration.isValidateDocumentation()) {
                activeValidators.add(new DocumentationWordingValidator());
            }
            if (configuration.isValidateInternationalization()) {
                activeValidators.add(new InternationalizationWording());
            }
        }
        if (configuration.isValidateExceptions()) {
            validator = new ExceptionValidator(helper, configuration);
            activeValidators.add(validator);
        }
        if (configuration.isValidateFamily()) {
            validator = new FamilyValidator(helper);
            activeValidators.add(validator);
        }
        if (extensions != null) {
            extensions.forEach(ext -> {
                ExtensionValidator validator = new ExtensionValidator((ValidationExtension)ext, helper);
                activeValidators.add(validator);
            });
        }
        if (configuration.isValidateRecord()) {
            activeValidators.add(new RecordValidator());
        }
        if (configuration.isValidateSchema()) {
            activeValidators.add(new SchemaValidator());
        }
        return new Validators(activeValidators);
    }

    public static Stream<Class<? extends Annotation>> getActionsStream() {
        return Stream.of(AsyncValidation.class, DynamicValues.class, HealthCheck.class, DiscoverSchema.class, Suggestions.class, Update.class);
    }

    public static Stream<ParameterMeta> flatten(Collection<ParameterMeta> options) {
        return options.stream().flatMap(it -> Stream.concat(Stream.of(it), it.getNestedParameters().isEmpty() ? Stream.empty() : Validators.flatten(it.getNestedParameters())));
    }

    public static interface ValidatorHelper {
        public boolean isService(Parameter var1);

        public ResourceBundle findResourceBundle(Class<?> var1);

        public String validateFamilyI18nKey(Class<?> var1, String ... var2);

        public List<ParameterMeta> buildOrGetParameters(Class<?> var1);

        public String validateIcon(Icon var1, Collection<String> var2);

        public ParameterModelService getParameterModelService();

        public Stream<File> componentClassFiles();
    }
}

