/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class PlaceHolderValidator
implements Validator {
    private static final String ERROR_MSG_FORMAT = "No %s._placeholder set for %s in Messages.properties of packages: %s";
    private final Validators.ValidatorHelper helper;

    public PlaceHolderValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return components.stream().map(this.helper::buildOrGetParameters).flatMap(Validators::flatten).filter(this::isStringifiable).filter(p -> !this.hasPlaceholder(loader, (ParameterMeta)p)).map(this::buildErrorMessage);
    }

    private String buildErrorMessage(ParameterMeta p) {
        String emplacement = p.getSource().declaringClass().getSimpleName() + "." + p.getSource().name();
        return String.format(ERROR_MSG_FORMAT, emplacement, p.getPath(), Arrays.asList(p.getI18nPackages()));
    }

    private boolean isStringifiable(ParameterMeta meta) {
        return ParameterMeta.Type.STRING.equals((Object)meta.getType()) || ParameterMeta.Type.ENUM.equals((Object)meta.getType());
    }

    private boolean hasPlaceholder(ClassLoader loader, ParameterMeta parameterMeta) {
        return parameterMeta.findBundle(loader, Locale.ROOT).placeholder(null).isPresent();
    }
}

