/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.ui.DefaultValue;
import org.talend.sdk.component.tools.ComponentValidator;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class LocalConfigurationValidator
implements Validator {
    private final Validators.ValidatorHelper helper;
    private final ComponentValidator.Configuration configuration;

    public LocalConfigurationValidator(Validators.ValidatorHelper helper, ComponentValidator.Configuration configuration) {
        this.helper = helper;
        this.configuration = configuration;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        String pluginId = this.pluginId();
        Stream errStart = this.helper.componentClassFiles().map(root -> new File((File)root, "TALEND-INF/local-configuration.properties")).filter(File::exists).flatMap(props -> {
            Properties properties = new Properties();
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream((File)props));){
                properties.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return properties.stringPropertyNames().stream().filter(it -> !it.toLowerCase(Locale.ROOT).startsWith(pluginId + ".")).map(it -> "'" + it + "' does not start with '" + pluginId + "', it is recommended to prefix all keys by the family");
        });
        Stream<String> familyName = Stream.concat(finder.findAnnotatedFields(DefaultValue.class).stream(), finder.findAnnotatedConstructorParameters(DefaultValue.class).stream()).map(d -> {
            DefaultValue annotation = d.getAnnotation(DefaultValue.class);
            if (annotation.value().startsWith("local_configuration:") && !annotation.value().toLowerCase(Locale.ROOT).startsWith("local_configuration:" + pluginId + ".")) {
                return d + " does not start with family name (followed by a dot): '" + pluginId + "'";
            }
            return null;
        }).filter(Objects::nonNull);
        return Stream.concat(errStart, familyName);
    }

    private String pluginId() {
        return Optional.of(this.configuration).map(ComponentValidator.Configuration::getPluginId).orElseGet(this::guessPluginId);
    }

    private String guessPluginId() {
        return this.helper.componentClassFiles().map(f -> {
            if (!f.isDirectory()) {
                return null;
            }
            int iteration = 5;
            for (File current = f; iteration-- > 0 && current != null; current = current.getParentFile()) {
                File currentRef = current;
                if (Stream.of("classes", "target", "main", "java", "build").anyMatch(it -> it.equals(currentRef.getName()))) {
                    continue;
                }
                return current.getName();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("No pluginId set"));
    }
}

