/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.runtime.manager.reflect.IconFinder;
import org.talend.sdk.component.tools.ComponentHelper;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class FamilyValidator
implements Validator {
    private final Validators.ValidatorHelper helper;
    private final IconFinder iconFinder = new IconFinder();

    public FamilyValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        return components.stream().flatMap(this::validateComponentClass);
    }

    private Stream<String> validateComponentClass(Class<?> component) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Icon icon = ComponentHelper.findPackageOrFail(component, clazz -> clazz.isAnnotationPresent(Icon.class), Icon.class.getName()).getAnnotation(Icon.class);
            Optional.ofNullable(this.helper.validateIcon(icon, errors)).ifPresent(errors::add);
        }
        catch (IllegalArgumentException iae) {
            try {
                ComponentHelper.findPackageOrFail(component, this::isIndirectIconPresent, Icon.class.getName());
            }
            catch (IllegalArgumentException iae2) {
                errors.add(iae.getMessage());
            }
        }
        return errors.stream();
    }

    private boolean isIndirectIconPresent(AnnotatedElement ae) {
        return this.iconFinder.findIndirectIcon(ae).isPresent();
    }
}

