/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.api;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.talend.sdk.component.server.front.model.DocumentationContent;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;

@Path(value="documentation")
@Tag(name="Documentation", description="Endpoint to retrieve embedded component documentation.")
public interface DocumentationResource {
    @GET
    @Path(value="component/{id}")
    @Produces(value={"application/json"})
    @Operation(description="Returns a documentation in asciidoctor format for the given component.  The component is represented by its identifier (`id`).")
    @APIResponses(value={@APIResponse(responseCode="200", description="The list of available and storable configurations (datastore, dataset, ...).", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="If the component is not found in the server, response will be an ErrorPayload with the code COMPONENT_MISSING.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))})})
    public DocumentationContent getDocumentation(@PathParam(value="id") @Parameter(name="id", description="The component identifier.", in=ParameterIn.PATH) String var1, @QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="The language requested.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String var2, @QueryParam(value="segment") @DefaultValue(value="ALL") @Parameter(name="segment", description="The documentation part to extract. Available parts are: `ALL` (default), `DESCRIPTION`, `CONFIGURATION`", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="ALL")) DocumentationSegment var3);

    public static enum DocumentationSegment {
        ALL,
        DESCRIPTION,
        CONFIGURATION;

    }
}

