/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.persistence;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;

public class DataSourceProxyFactory
implements InvocationHandler {
    public static final String PROP_DS_NAME = "org.talend.esb.datasource.name";
    private BundleContext bundleContext;
    private String dsName;
    private long timeout;
    private ServiceTracker<DataSource, DataSource> tracker;
    private DataSource proxy;
    private Filter filter;

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        if (dsName == null || dsName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (dsName.contains("\"") || dsName.contains(")")) {
            throw new IllegalArgumentException();
        }
        this.dsName = dsName;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.timeout = timeout;
    }

    public void init() throws Exception {
        this.filter = this.bundleContext.createFilter(this.getFilter(this.dsName));
        this.tracker = new ServiceTracker(this.bundleContext, this.filter, null);
        this.tracker.open();
        this.proxy = (DataSource)Proxy.newProxyInstance(DataSourceProxyFactory.class.getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)this);
    }

    public void destroy() throws Exception {
        this.tracker.close();
    }

    public DataSource getDatasource() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        DataSource realDs = (DataSource)this.tracker.waitForService(this.timeout);
        if (realDs == null) {
            throw new SQLException("Datasource '" + this.dsName + "' is not available.");
        }
        try {
            return method.invoke((Object)realDs, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected String getFilter(String dsName) {
        StringBuilder sb = new StringBuilder("(&(");
        sb.append("objectClass");
        sb.append('=');
        sb.append(DataSource.class.getName());
        sb.append(")(");
        sb.append(PROP_DS_NAME);
        sb.append('=');
        sb.append(dsName);
        sb.append("))");
        return sb.toString();
    }
}

