/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.talend.esb.sam.server.persistence.dialects.DatabaseDialect;
import org.talend.esb.sam.server.ui.CriteriaAdapter;
import org.talend.esb.sam.server.ui.JsonRowMapper;
import org.talend.esb.sam.server.ui.UIProvider;
import org.talend.esb.sam.server.ui.UIProviderUtils;

public class UIProviderImpl
extends SimpleJdbcDaoSupport
implements UIProvider {
    private static final String COUNT_QUERY = "select count(distinct MI_FLOW_ID) from EVENTS %%FILTER%%";
    private static final String SELECT_FLOW_QUERY = "select EVENTS.ID, EI_TIMESTAMP, EI_EVENT_TYPE, ORIG_CUSTOM_ID, ORIG_PROCESS_ID, ORIG_HOSTNAME, ORIG_IP, ORIG_PRINCIPAL, MI_PORT_TYPE, MI_OPERATION_NAME, MI_MESSAGE_ID, MI_FLOW_ID, MI_TRANSPORT_TYPE, CONTENT_CUT, CUST_KEY, CUST_VALUE from EVENTS left join EVENTS_CUSTOMINFO on EVENTS_CUSTOMINFO.EVENT_ID = EVENTS.ID where MI_FLOW_ID = :flowID";
    private static final String SELECT_EVENT_QUERY = "select ID, EI_TIMESTAMP, EI_EVENT_TYPE, ORIG_CUSTOM_ID, ORIG_PROCESS_ID, ORIG_HOSTNAME, ORIG_IP, ORIG_PRINCIPAL, MI_PORT_TYPE, MI_OPERATION_NAME, MI_MESSAGE_ID, MI_FLOW_ID, MI_TRANSPORT_TYPE, CONTENT_CUT, MESSAGE_CONTENT from EVENTS where ID = :eventID";
    private DatabaseDialect dialect;
    private final RowMapper<JsonObject> mapper = new JsonRowMapper();
    private final UIProviderUtils utils = new UIProviderUtils();

    public void setDialect(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public JsonObject getEvents(long offset, String baseURL, CriteriaAdapter criteria) {
        String whereClause = criteria.getWhereClause();
        String countQuery = COUNT_QUERY.replaceAll("%%FILTER%%", whereClause != null && whereClause.length() > 0 ? " WHERE " + whereClause : "");
        int rowCount = this.getSimpleJdbcTemplate().queryForInt(countQuery, (SqlParameterSource)criteria);
        JsonObject result = new JsonObject();
        result.add("count", (JsonElement)new JsonPrimitive((Number)rowCount));
        JsonArray aggregated = new JsonArray();
        if (offset < (long)rowCount) {
            String dataQuery = this.dialect.getDataQuery(criteria);
            List objects = this.getSimpleJdbcTemplate().query(dataQuery, this.mapper, (SqlParameterSource)criteria);
            aggregated = this.utils.aggregateRawData(objects, baseURL);
        }
        result.add("aggregated", (JsonElement)aggregated);
        return result;
    }

    @Override
    public JsonObject getFlowDetails(String flowID, String baseURL) {
        List list = this.getSimpleJdbcTemplate().query(SELECT_FLOW_QUERY, this.mapper, Collections.singletonMap("flowID", flowID));
        if (list.isEmpty()) {
            return null;
        }
        JsonObject result = new JsonObject();
        result.add("events", (JsonElement)this.utils.aggregateFlowDetails(list, baseURL));
        return result;
    }

    @Override
    public JsonObject getEventDetails(String eventID) {
        return (JsonObject)this.getSimpleJdbcTemplate().queryForObject(SELECT_EVENT_QUERY, this.mapper, Collections.singletonMap("eventID", eventID));
    }
}

