/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Order;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.trading.rules.AbstractRule;

public class WaitForRule
extends AbstractRule {
    private final Order.OrderType orderType;
    private final int numberOfBars;

    public WaitForRule(Order.OrderType orderType, int numberOfBars) {
        this.orderType = orderType;
        this.numberOfBars = numberOfBars;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Order lastOrder;
        boolean satisfied = false;
        if (tradingRecord != null && (lastOrder = tradingRecord.getLastOrder(this.orderType)) != null) {
            int currentNumberOfBars = index - lastOrder.getIndex();
            satisfied = currentNumberOfBars >= this.numberOfBars;
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

